/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.measurement;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.willowtreeapps.hyperion.measurement.MeasurementOverlayView;
import com.willowtreeapps.hyperion.measurement.R;
import com.willowtreeapps.hyperion.plugin.v1.OnOverlayViewChangedListener;
import com.willowtreeapps.hyperion.plugin.v1.OverlayContainer;
import com.willowtreeapps.hyperion.plugin.v1.PluginModule;

class MeasurementInspectorModule
extends PluginModule
implements View.OnClickListener,
OnOverlayViewChangedListener {
    private static final String OVERLAY_TAG = "measurement_inspector_overlay";
    private OverlayContainer overlay;
    private View view;

    MeasurementInspectorModule() {
    }

    protected void onCreate() {
        this.overlay = this.getExtension().getOverlayContainer();
        this.overlay.addOnOverlayViewChangedListener((OnOverlayViewChangedListener)this);
    }

    @Nullable
    public View createPluginView(@NonNull LayoutInflater layoutInflater, @NonNull ViewGroup parent) {
        View view = layoutInflater.inflate(R.layout.hm_item_plugin, parent, false);
        view.setOnClickListener((View.OnClickListener)this);
        View overlayView = this.overlay.getOverlayView();
        view.setSelected(overlayView != null && OVERLAY_TAG.equals(overlayView.getTag()));
        this.view = view;
        return view;
    }

    protected void onDestroy() {
        this.overlay.removeOnOverlayViewChangedListener((OnOverlayViewChangedListener)this);
    }

    public void onClick(View v) {
        View currentOverlay = this.overlay.getOverlayView();
        if (currentOverlay == null || !OVERLAY_TAG.equals(currentOverlay.getTag())) {
            MeasurementOverlayView newOverlay = new MeasurementOverlayView(this.getContext());
            newOverlay.setTag(OVERLAY_TAG);
            this.overlay.setOverlayView((View)newOverlay);
        } else {
            this.overlay.removeOverlayView();
        }
    }

    public void onOverlayViewChanged(@Nullable View view) {
        this.view.setSelected(view != null && OVERLAY_TAG.equals(view.getTag()));
    }
}

