/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.measurement;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.support.annotation.Px;
import android.support.v4.content.ContextCompat;
import android.text.TextPaint;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.willowtreeapps.hyperion.measurement.R;
import com.willowtreeapps.hyperion.plugin.v1.ExtensionProvider;
import com.willowtreeapps.hyperion.plugin.v1.MeasurementHelper;
import com.willowtreeapps.hyperion.plugin.v1.PluginExtension;

class MeasurementOverlayView
extends FrameLayout {
    private final ViewGroup contentRoot;
    private final MeasurementHelper measurementHelper;
    private final Path path = new Path();
    private final Rect outRect = new Rect();
    private final Paint paintDashed;
    private final Paint paintPrimary;
    private final Paint paintSecondary;
    private final TextPaint paintText;
    @Px
    private final int measurementTextOffset;
    private View currentView;
    private Rect rectPrimary;
    private Rect rectSecondary;
    private TextView measurementWidthText;
    private TextView measurementHeightText;
    private TextView measurementLeftText;
    private TextView measurementTopText;
    private TextView measurementRightText;
    private TextView measurementBottomText;

    MeasurementOverlayView(Context context) {
        super(context);
        PluginExtension extension = ExtensionProvider.get((Context)context);
        this.contentRoot = extension.getContentRoot();
        this.measurementHelper = extension.getMeasurementHelper();
        this.paintDashed = new Paint();
        this.paintDashed.setColor(ContextCompat.getColor((Context)context, (int)R.color.hype_blue));
        this.paintDashed.setStyle(Paint.Style.STROKE);
        this.paintDashed.setStrokeWidth(4.0f);
        this.paintDashed.setPathEffect((PathEffect)new DashPathEffect(new float[]{10.0f, 20.0f}, 0.0f));
        this.paintPrimary = new Paint();
        this.paintPrimary.setColor(ContextCompat.getColor((Context)context, (int)R.color.hype_blue));
        this.paintPrimary.setStyle(Paint.Style.STROKE);
        this.paintPrimary.setStrokeWidth(6.0f);
        this.paintSecondary = new Paint();
        this.paintSecondary.setColor(ContextCompat.getColor((Context)context, (int)R.color.hype_blue));
        this.paintSecondary.setStyle(Paint.Style.STROKE);
        this.paintSecondary.setStrokeWidth(6.0f);
        this.paintText = new TextPaint();
        this.paintText.setColor(ContextCompat.getColor((Context)context, (int)R.color.hype_blue));
        this.paintText.setTextSize(45.0f);
        this.paintText.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paintText.setStrokeWidth(2.0f);
        this.measurementTextOffset = this.getResources().getDimensionPixelSize(R.dimen.hm_measurement_text_offset);
        this.setWillNotDraw(false);
    }

    protected void onDraw(Canvas canvas) {
        if (this.rectPrimary == null) {
            return;
        }
        canvas.drawRect(this.rectPrimary, this.paintPrimary);
        this.path.reset();
        this.path.moveTo((float)this.rectPrimary.left, 0.0f);
        this.path.lineTo((float)this.rectPrimary.left, (float)this.rectPrimary.top);
        canvas.drawPath(this.path, this.paintDashed);
        this.path.reset();
        this.path.moveTo((float)this.rectPrimary.right, 0.0f);
        this.path.lineTo((float)this.rectPrimary.right, (float)this.rectPrimary.top);
        canvas.drawPath(this.path, this.paintDashed);
        this.path.reset();
        this.path.moveTo(0.0f, (float)this.rectPrimary.top);
        this.path.lineTo((float)this.rectPrimary.left, (float)this.rectPrimary.top);
        canvas.drawPath(this.path, this.paintDashed);
        this.path.reset();
        this.path.moveTo(0.0f, (float)this.rectPrimary.bottom);
        this.path.lineTo((float)this.rectPrimary.left, (float)this.rectPrimary.bottom);
        canvas.drawPath(this.path, this.paintDashed);
        this.path.reset();
        this.path.moveTo((float)this.rectPrimary.left, (float)this.rectPrimary.bottom);
        this.path.lineTo((float)this.rectPrimary.left, (float)this.getBottom());
        canvas.drawPath(this.path, this.paintDashed);
        this.path.reset();
        this.path.moveTo((float)this.rectPrimary.right, (float)this.rectPrimary.bottom);
        this.path.lineTo((float)this.rectPrimary.right, (float)this.getBottom());
        canvas.drawPath(this.path, this.paintDashed);
        this.path.reset();
        this.path.moveTo((float)this.rectPrimary.right, (float)this.rectPrimary.bottom);
        this.path.lineTo((float)this.getRight(), (float)this.rectPrimary.bottom);
        canvas.drawPath(this.path, this.paintDashed);
        this.path.reset();
        this.path.moveTo((float)this.rectPrimary.right, (float)this.rectPrimary.top);
        this.path.lineTo((float)this.getRight(), (float)this.rectPrimary.top);
        canvas.drawPath(this.path, this.paintDashed);
        if (this.rectSecondary == null) {
            if (this.measurementWidthText != null) {
                canvas.save();
                canvas.translate((float)(this.rectPrimary.centerX() - this.measurementWidthText.getWidth() / 2), (float)(this.rectPrimary.top - this.measurementWidthText.getHeight() - this.measurementTextOffset));
                this.measurementWidthText.draw(canvas);
                canvas.restore();
            }
            if (this.measurementHeightText != null) {
                canvas.save();
                canvas.translate((float)(this.rectPrimary.right + this.measurementTextOffset), (float)(this.rectPrimary.bottom - this.rectPrimary.height() / 2 - this.measurementHeightText.getHeight() / 2));
                this.measurementHeightText.draw(canvas);
                canvas.restore();
            }
        } else {
            canvas.drawRect(this.rectSecondary, this.paintSecondary);
            if (this.rectPrimary.bottom < this.rectSecondary.top) {
                canvas.drawLine((float)this.rectSecondary.centerX(), (float)this.rectPrimary.bottom, (float)this.rectSecondary.centerX(), (float)this.rectSecondary.top, this.paintPrimary);
                if (this.measurementHeightText != null) {
                    canvas.save();
                    canvas.translate((float)(this.rectSecondary.centerX() - this.measurementHeightText.getWidth() / 2), (float)((this.rectPrimary.bottom + this.rectSecondary.top) / 2 - this.measurementHeightText.getHeight() / 2));
                    this.measurementHeightText.draw(canvas);
                    canvas.restore();
                }
            }
            if (this.rectPrimary.right < this.rectSecondary.left) {
                canvas.drawLine((float)this.rectPrimary.right, (float)this.rectSecondary.centerY(), (float)this.rectSecondary.left, (float)this.rectSecondary.centerY(), this.paintPrimary);
                if (this.measurementWidthText != null) {
                    canvas.save();
                    canvas.translate((float)((this.rectPrimary.right + this.rectSecondary.left) / 2 - this.measurementWidthText.getWidth() / 2), (float)(this.rectSecondary.centerY() - this.measurementWidthText.getHeight() / 2));
                    this.measurementWidthText.draw(canvas);
                    canvas.restore();
                }
            }
            if (this.rectSecondary.bottom < this.rectPrimary.top) {
                canvas.drawLine((float)this.rectSecondary.centerX(), (float)this.rectPrimary.top, (float)this.rectSecondary.centerX(), (float)this.rectSecondary.bottom, this.paintPrimary);
                if (this.measurementHeightText != null) {
                    canvas.save();
                    canvas.translate((float)(this.rectSecondary.centerX() - this.measurementHeightText.getWidth() / 2), (float)((this.rectPrimary.top + this.rectSecondary.bottom) / 2 - this.measurementHeightText.getHeight() / 2));
                    this.measurementHeightText.draw(canvas);
                    canvas.restore();
                }
            }
            if (this.rectSecondary.right < this.rectPrimary.left) {
                canvas.drawLine((float)this.rectPrimary.left, (float)this.rectSecondary.centerY(), (float)this.rectSecondary.right, (float)this.rectSecondary.centerY(), this.paintPrimary);
                if (this.measurementWidthText != null) {
                    canvas.save();
                    canvas.translate((float)((this.rectPrimary.left + this.rectSecondary.right) / 2 - this.measurementWidthText.getWidth() / 2), (float)(this.rectSecondary.centerY() - this.measurementWidthText.getHeight() / 2));
                    this.measurementWidthText.draw(canvas);
                    canvas.restore();
                }
            }
            Rect inside = null;
            Rect outside = null;
            if (this.rectPrimary.contains(this.rectSecondary)) {
                outside = this.rectPrimary;
                inside = this.rectSecondary;
            } else if (this.rectSecondary.contains(this.rectPrimary)) {
                outside = this.rectSecondary;
                inside = this.rectPrimary;
            }
            if (inside != null && outside != null) {
                canvas.drawLine((float)outside.left, (float)inside.centerY(), (float)inside.left, (float)inside.centerY(), this.paintPrimary);
                if (this.measurementLeftText != null) {
                    canvas.save();
                    canvas.translate((float)((outside.left + inside.left) / 2 - this.measurementLeftText.getWidth() / 2), (float)(inside.centerY() - this.measurementLeftText.getHeight() / 2));
                    this.measurementLeftText.draw(canvas);
                    canvas.restore();
                }
                canvas.drawLine((float)outside.right, (float)inside.centerY(), (float)inside.right, (float)inside.centerY(), this.paintPrimary);
                if (this.measurementRightText != null) {
                    canvas.save();
                    canvas.translate((float)((outside.right + inside.right) / 2 - this.measurementRightText.getWidth() / 2), (float)(inside.centerY() - this.measurementRightText.getHeight() / 2));
                    this.measurementRightText.draw(canvas);
                    canvas.restore();
                }
                canvas.drawLine((float)inside.centerX(), (float)outside.top, (float)inside.centerX(), (float)inside.top, this.paintPrimary);
                if (this.measurementTopText != null) {
                    canvas.save();
                    canvas.translate((float)(inside.centerX() - this.measurementTopText.getWidth() / 2), (float)((outside.top + inside.top) / 2 - this.measurementTopText.getHeight() / 2));
                    this.measurementTopText.draw(canvas);
                    canvas.restore();
                }
                canvas.drawLine((float)inside.centerX(), (float)outside.bottom, (float)inside.centerX(), (float)inside.bottom, this.paintPrimary);
                if (this.measurementBottomText != null) {
                    canvas.save();
                    canvas.translate((float)(inside.centerX() - this.measurementBottomText.getWidth() / 2), (float)((outside.bottom + inside.bottom) / 2 - this.measurementBottomText.getHeight() / 2));
                    this.measurementBottomText.draw(canvas);
                    canvas.restore();
                }
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            return true;
        }
        if (event.getAction() == 1) {
            float y;
            float x = event.getX();
            View touchTarget = this.findTarget((View)this.contentRoot, x, y = event.getY());
            if (this.contentRoot == touchTarget || this.currentView == touchTarget) {
                this.currentView = null;
                this.rectPrimary = null;
                this.rectSecondary = null;
            } else if (this.rectPrimary == null) {
                this.setPrimaryTarget(touchTarget);
            } else {
                this.setSecondaryTarget(touchTarget);
            }
            this.invalidate();
            return true;
        }
        return super.onTouchEvent(event);
    }

    private View findTarget(View root, float x, float y) {
        View bestTarget = root;
        if (root instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)root;
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                View target;
                View child = parent.getChildAt(i);
                this.measurementHelper.getScreenLocation(child, this.outRect);
                if (child.getVisibility() != 0 || !(x >= (float)this.outRect.left) || !(x <= (float)this.outRect.right) || !(y >= (float)this.outRect.top) || !(y <= (float)this.outRect.bottom) || (target = this.findTarget(child, x, y)).getWidth() > bestTarget.getWidth() || target.getHeight() > bestTarget.getHeight()) continue;
                bestTarget = target;
            }
        }
        return bestTarget;
    }

    private void setPrimaryTarget(View view) {
        this.currentView = view;
        this.rectPrimary = new Rect();
        this.measurementHelper.getScreenLocation(view, this.rectPrimary);
        this.setWidthMeasurementText(this.rectPrimary.width());
        this.setHeightMeasurementText(this.rectPrimary.height());
    }

    private void setSecondaryTarget(View view) {
        this.rectSecondary = new Rect();
        this.measurementHelper.getScreenLocation(view, this.rectSecondary);
        if (this.rectPrimary.bottom < this.rectSecondary.top) {
            this.setHeightMeasurementText(this.rectSecondary.top - this.rectPrimary.bottom);
        }
        if (this.rectPrimary.right < this.rectSecondary.left) {
            this.setWidthMeasurementText(this.rectSecondary.left - this.rectPrimary.right);
        }
        if (this.rectSecondary.bottom < this.rectPrimary.top) {
            this.setHeightMeasurementText(this.rectPrimary.top - this.rectSecondary.bottom);
        }
        if (this.rectSecondary.right < this.rectPrimary.left) {
            this.setWidthMeasurementText(this.rectPrimary.left - this.rectSecondary.right);
        }
        Rect inside = null;
        Rect outside = null;
        if (this.rectPrimary.contains(this.rectSecondary)) {
            outside = this.rectPrimary;
            inside = this.rectSecondary;
        } else if (this.rectSecondary.contains(this.rectPrimary)) {
            outside = this.rectSecondary;
            inside = this.rectPrimary;
        }
        if (inside != null && outside != null) {
            this.setLeftMeasurementText(inside.left - outside.left);
            this.setTopMeasurementText(inside.top - outside.top);
            this.setRightMeasurementText(outside.right - inside.right);
            this.setBottomMeasurementText(outside.bottom - inside.bottom);
        }
    }

    private void setWidthMeasurementText(@Px int measurement) {
        if (measurement <= 0) {
            this.measurementWidthText = null;
            return;
        }
        this.measurementWidthText = this.makeMeasurementView(measurement);
    }

    private void setHeightMeasurementText(@Px int measurement) {
        if (measurement <= 0) {
            this.measurementHeightText = null;
            return;
        }
        this.measurementHeightText = this.makeMeasurementView(measurement);
    }

    private void setLeftMeasurementText(@Px int measurement) {
        if (measurement <= 0) {
            this.measurementLeftText = null;
            return;
        }
        this.measurementLeftText = this.makeMeasurementView(measurement);
    }

    private void setTopMeasurementText(@Px int measurement) {
        if (measurement <= 0) {
            this.measurementTopText = null;
            return;
        }
        this.measurementTopText = this.makeMeasurementView(measurement);
    }

    private void setRightMeasurementText(@Px int measurement) {
        if (measurement <= 0) {
            this.measurementRightText = null;
            return;
        }
        this.measurementRightText = this.makeMeasurementView(measurement);
    }

    private void setBottomMeasurementText(@Px int measurement) {
        if (measurement <= 0) {
            this.measurementBottomText = null;
            return;
        }
        this.measurementBottomText = this.makeMeasurementView(measurement);
    }

    private TextView makeMeasurementView(@Px int measurement) {
        TextView tv = new TextView(this.getContext());
        tv.setGravity(17);
        String text = this.measurementHelper.toDp(measurement) + "dp";
        tv.setText((CharSequence)text);
        tv.setTextColor(this.getResources().getColor(R.color.hype_blue));
        tv.setBackgroundResource(R.drawable.hm_rounded_measurement);
        this.layoutTextView(tv);
        return tv;
    }

    private void layoutTextView(TextView tv) {
        float fontScale = this.getResources().getConfiguration().fontScale;
        float densityMultiplier = this.getContext().getResources().getDisplayMetrics().density - 2.0f;
        Rect bounds = new Rect();
        this.paintText.getTextBounds(tv.getText().toString().toCharArray(), 0, tv.getText().length(), bounds);
        tv.layout(0, 0, (int)(((float)bounds.width() + 33.0f * densityMultiplier) * fontScale), (int)(((float)bounds.height() + 22.0f * densityMultiplier) * fontScale));
    }
}

