/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.phoenix;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.willowtreeapps.hyperion.phoenix.ProcessPhoenix;
import com.willowtreeapps.hyperion.phoenix.R;
import com.willowtreeapps.hyperion.phoenix.RebirthOptions;
import com.willowtreeapps.hyperion.plugin.v1.PluginModule;

class PhoenixModule
extends PluginModule {
    PhoenixModule() {
    }

    public View createPluginView(@NonNull LayoutInflater layoutInflater, @NonNull ViewGroup parent) {
        View view = layoutInflater.inflate(R.layout.hp_item_plugin, parent, false);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Activity activity = PhoenixModule.this.getExtension().getActivity();
                PhoenixModule.this.confirmRebirth(activity);
            }
        });
        return view;
    }

    private void confirmRebirth(final Activity activity) {
        new AlertDialog.Builder((Context)activity).setTitle(R.string.hp_pheonix_options_title).setMultiChoiceItems(R.array.hp_phoenix_options, this.loadPhoenixOptions(), new DialogInterface.OnMultiChoiceClickListener(){

            public void onClick(DialogInterface dialog, int which, boolean isChecked) {
                PhoenixModule.this.setOptionSelection(which, isChecked);
            }
        }).setPositiveButton(R.string.hp_dialog_confirmation, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ProcessPhoenix.triggerRebirth((Context)activity);
            }
        }).setNegativeButton(0x1040000, null).create().show();
    }

    private boolean[] loadPhoenixOptions() {
        RebirthOptions options = ProcessPhoenix.getOptions();
        return new boolean[]{options.shouldClearCache(), options.shouldClearData(), options.shouldRestartSelf()};
    }

    private void setOptionSelection(int selectionIndex, boolean selected) {
        RebirthOptions.Builder optionsBuilder = ProcessPhoenix.getOptions().builder();
        switch (selectionIndex) {
            case 0: {
                optionsBuilder.clearCache(selected);
                break;
            }
            case 1: {
                optionsBuilder.clearData(selected);
                break;
            }
            case 2: {
                optionsBuilder.restartSelf(selected);
            }
        }
        ProcessPhoenix.setOptions(optionsBuilder.build());
    }
}

