/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.phoenix;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Process;
import com.willowtreeapps.hyperion.phoenix.RebirthOptions;
import com.willowtreeapps.hyperion.plugin.v1.HyperionIgnore;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@HyperionIgnore
public class ProcessPhoenix
extends Activity {
    private static final String KEY_RESTART_INTENTS = "phoenix_restart_intents";
    private static final String KEY_CLEAR_CACHE = "phoenix_clear_cache";
    private static final String KEY_CLEAR_DATA = "phoenix_clear_data";
    private static RebirthOptions options = RebirthOptions.DEFAULT;

    static void setOptions(RebirthOptions options) {
        ProcessPhoenix.options = options;
    }

    static RebirthOptions getOptions() {
        return options;
    }

    public static void triggerRebirth(Context context) {
        ProcessPhoenix.triggerRebirth(context, ProcessPhoenix.getRestartIntent(context));
    }

    public static void triggerRebirth(Context context, Intent ... nextIntents) {
        Intent intent = new Intent(context, ProcessPhoenix.class);
        intent.addFlags(0x10000000);
        intent.putParcelableArrayListExtra(KEY_RESTART_INTENTS, new ArrayList<Intent>(Arrays.asList(nextIntents)));
        intent.putExtra(KEY_CLEAR_CACHE, options.shouldClearCache());
        intent.putExtra(KEY_CLEAR_DATA, options.shouldClearData());
        context.startActivity(intent);
        if (context instanceof Activity) {
            ((Activity)context).finish();
        }
        Runtime.getRuntime().exit(0);
    }

    private static Intent getRestartIntent(Context context) {
        String packageName = context.getPackageName();
        Intent intent = options.shouldRestartSelf() ? new Intent(context, context.getClass()) : context.getPackageManager().getLaunchIntentForPackage(packageName);
        if (intent != null) {
            intent.addFlags(0x10008000);
            return intent;
        }
        throw new IllegalStateException("Unable to determine default activity for " + packageName + ". Does an activity specify the DEFAULT category in its intent filter?");
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        ArrayList intents = intent.getParcelableArrayListExtra(KEY_RESTART_INTENTS);
        boolean shouldClearCache = intent.getBooleanExtra(KEY_CLEAR_CACHE, false);
        boolean shouldClearData = intent.getBooleanExtra(KEY_CLEAR_DATA, false);
        if (shouldClearCache) {
            this.clearCache();
        }
        if (shouldClearData) {
            this.clearData();
        }
        this.startActivities(intents.toArray(new Intent[intents.size()]));
        this.finish();
        Runtime.getRuntime().exit(0);
    }

    private void clearCache() {
        try {
            File[] files;
            for (File file : files = this.getCacheDir().listFiles()) {
                ProcessPhoenix.delete(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearData() {
        File cacheDirectory = this.getCacheDir();
        File applicationDirectory = new File(cacheDirectory.getParent());
        if (applicationDirectory.exists()) {
            String[] fileNames;
            for (String fileName : fileNames = applicationDirectory.list()) {
                if (fileName.equals("lib")) continue;
                ProcessPhoenix.delete(new File(applicationDirectory, fileName));
            }
        }
    }

    private static boolean delete(File file) {
        boolean deletedAll = true;
        if (file != null) {
            if (file.isDirectory()) {
                String[] children;
                for (String child : children = file.list()) {
                    deletedAll = ProcessPhoenix.delete(new File(file, child)) && deletedAll;
                }
            } else {
                deletedAll = file.delete();
            }
        }
        return deletedAll;
    }

    public static boolean isPhoenixProcess(Context context) {
        int currentPid = Process.myPid();
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List runningProcesses = manager.getRunningAppProcesses();
        if (runningProcesses != null) {
            for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
                if (processInfo.pid != currentPid || !processInfo.processName.endsWith(":phoenix")) continue;
                return true;
            }
        }
        return false;
    }
}

