/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.sharedpreferences.detail;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import com.willowtreeapps.hyperion.sharedpreferences.R;
import com.willowtreeapps.hyperion.sharedpreferences.detail.SharedPreferencesDetailAdapter;

public class SharedPreferencesNavigationView
extends FrameLayout {
    private final PreferenceListener preferenceListener = new PreferenceListener();
    private SharedPreferences sharedPreferences;
    private SharedPreferencesDetailAdapter sharedPreferencesDetailAdapter;

    public SharedPreferencesNavigationView(@NonNull Context context) {
        super(context);
    }

    public SharedPreferencesNavigationView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public SharedPreferencesNavigationView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Activity activity = (Activity)this.getContext();
        String prefsName = activity.getIntent().getStringExtra("prefs_name");
        this.sharedPreferences = this.getContext().getSharedPreferences(prefsName, 0);
        this.sharedPreferencesDetailAdapter = new SharedPreferencesDetailAdapter(this.sharedPreferences);
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.hsp_navigation_recycler);
        recyclerView.setAdapter((RecyclerView.Adapter)this.sharedPreferencesDetailAdapter);
        this.sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this.preferenceListener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this.preferenceListener);
    }

    private class PreferenceListener
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private PreferenceListener() {
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
            SharedPreferencesNavigationView.this.sharedPreferencesDetailAdapter.notifyKeyChanged(key);
        }
    }
}

