/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder;

import android.content.SharedPreferences;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.Switch;
import com.willowtreeapps.hyperion.sharedpreferences.R;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.PreferenceViewHolder;

public class BooleanPreferenceViewHolder
extends PreferenceViewHolder<Boolean> {
    private final Switch switchValue;

    public BooleanPreferenceViewHolder(View itemView, SharedPreferences sharedPreferences) {
        super(itemView);
        this.switchValue = (Switch)itemView.findViewById(R.id.hsp_navigation_preference_value);
        this.switchValue.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)new CheckChangedListener(sharedPreferences));
    }

    @Override
    public void bind(String preferenceKey, Boolean preferenceValue) {
        super.bind(preferenceKey, preferenceValue);
        this.switchValue.setChecked(preferenceValue.booleanValue());
    }

    private class CheckChangedListener
    implements CompoundButton.OnCheckedChangeListener {
        private final SharedPreferences sharedPreferences;

        private CheckChangedListener(SharedPreferences sharedPreferences) {
            this.sharedPreferences = sharedPreferences;
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (this.sharedPreferences.getBoolean(BooleanPreferenceViewHolder.this.getKey(), false) != isChecked) {
                this.sharedPreferences.edit().putBoolean(BooleanPreferenceViewHolder.this.getKey(), isChecked).apply();
            }
        }
    }
}

