/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.willowtreeapps.hyperion.sharedpreferences.R;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.PreferenceViewHolder;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.SharedPreferenceEditorListener;

public class FloatPreferenceViewHolder
extends PreferenceViewHolder<Float> {
    private static final String TAG = "FloatPrefViewHolder";
    private final EditText editTextValue;

    public FloatPreferenceViewHolder(View itemView, SharedPreferences sharedPreferences) {
        super(itemView);
        this.editTextValue = (EditText)itemView.findViewById(R.id.hsp_navigation_preference_value);
        this.editTextValue.setOnEditorActionListener((TextView.OnEditorActionListener)new EditorListener(sharedPreferences));
    }

    private static Boolean floatEquals(float left, float right) {
        return (double)Math.abs(left - right) < 1.0E-12;
    }

    @Override
    @SuppressLint(value={"SetTextI18n"})
    public void bind(String preferenceKey, Float preferenceValue) {
        super.bind(preferenceKey, preferenceValue);
        this.editTextValue.setText((CharSequence)preferenceValue.toString());
    }

    private class EditorListener
    extends SharedPreferenceEditorListener {
        EditorListener(SharedPreferences sharedPreferences) {
            super(sharedPreferences);
        }

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            try {
                float value = Float.parseFloat(v.getText().toString());
                if (!FloatPreferenceViewHolder.floatEquals(value, this.sharedPreferences.getFloat(FloatPreferenceViewHolder.this.getKey(), 0.0f)).booleanValue()) {
                    this.sharedPreferences.edit().putFloat(FloatPreferenceViewHolder.this.getKey(), value).apply();
                }
            }
            catch (Exception e) {
                Log.e((String)FloatPreferenceViewHolder.TAG, (String)"Unable to parse integer", (Throwable)e);
            }
            return true;
        }
    }
}

