/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.willowtreeapps.hyperion.sharedpreferences.R;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.PreferenceViewHolder;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.SharedPreferenceEditorListener;

public class IntPreferenceViewHolder
extends PreferenceViewHolder<Integer> {
    private static final String TAG = "IntPrefViewHolder";
    private final EditText editTextValue;

    public IntPreferenceViewHolder(View itemView, SharedPreferences sharedPreferences) {
        super(itemView);
        this.editTextValue = (EditText)itemView.findViewById(R.id.hsp_navigation_preference_value);
        this.editTextValue.setOnEditorActionListener((TextView.OnEditorActionListener)new EditorListener(sharedPreferences));
    }

    @Override
    @SuppressLint(value={"SetTextI18n"})
    public void bind(String preferenceKey, Integer preferenceValue) {
        super.bind(preferenceKey, preferenceValue);
        this.editTextValue.setText((CharSequence)preferenceValue.toString());
    }

    private class EditorListener
    extends SharedPreferenceEditorListener {
        EditorListener(SharedPreferences sharedPreferences) {
            super(sharedPreferences);
        }

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            try {
                int value = Integer.parseInt(v.getText().toString());
                if (value != this.sharedPreferences.getInt(IntPreferenceViewHolder.this.getKey(), 0)) {
                    this.sharedPreferences.edit().putInt(IntPreferenceViewHolder.this.getKey(), value).apply();
                }
            }
            catch (Exception e) {
                Log.e((String)IntPreferenceViewHolder.TAG, (String)"Unable to parse integer", (Throwable)e);
            }
            return true;
        }
    }
}

