/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.sharedpreferences.detail;

import android.content.Context;
import android.content.SharedPreferences;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.willowtreeapps.hyperion.sharedpreferences.R;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.BooleanPreferenceViewHolder;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.FloatPreferenceViewHolder;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.IntPreferenceViewHolder;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.LongPreferenceViewHolder;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.PreferenceViewHolder;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.StringPreferenceViewHolder;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.StringSetPreferenceViewHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SharedPreferencesDetailAdapter
extends RecyclerView.Adapter<PreferenceViewHolder> {
    private static final int VIEW_TYPE_INTEGER = 1;
    private static final int VIEW_TYPE_LONG = 2;
    private static final int VIEW_TYPE_FLOAT = 3;
    private static final int VIEW_TYPE_BOOLEAN = 4;
    private static final int VIEW_TYPE_STRING = 5;
    private static final int VIEW_TYPE_STRING_SET = 6;
    private final SharedPreferences sharedPreferences;

    SharedPreferencesDetailAdapter(SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    @NonNull
    public PreferenceViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        switch (viewType) {
            case 1: {
                return new IntPreferenceViewHolder(inflater.inflate(R.layout.hsp_navigation_preference_number_viewholder, parent, false), this.sharedPreferences);
            }
            case 2: {
                return new LongPreferenceViewHolder(inflater.inflate(R.layout.hsp_navigation_preference_number_viewholder, parent, false), this.sharedPreferences);
            }
            case 3: {
                return new FloatPreferenceViewHolder(inflater.inflate(R.layout.hsp_navigation_preference_number_viewholder, parent, false), this.sharedPreferences);
            }
            case 4: {
                return new BooleanPreferenceViewHolder(inflater.inflate(R.layout.hsp_navigation_preference_boolean_viewholder, parent, false), this.sharedPreferences);
            }
            case 5: {
                return new StringPreferenceViewHolder(inflater.inflate(R.layout.hsp_navigation_preference_string_viewholder, parent, false), this.sharedPreferences);
            }
            case 6: {
                return new StringSetPreferenceViewHolder(inflater.inflate(R.layout.hsp_navigation_preference_string_viewholder, parent, false));
            }
        }
        throw new RuntimeException("Unknown view type " + viewType);
    }

    public int getItemViewType(int position) {
        Object preferenceValue = this.getValue(position);
        if (this.isObjectOfClass(preferenceValue, Integer.class).booleanValue()) {
            return 1;
        }
        if (this.isObjectOfClass(preferenceValue, Long.class).booleanValue()) {
            return 2;
        }
        if (this.isObjectOfClass(preferenceValue, Float.class).booleanValue()) {
            return 3;
        }
        if (this.isObjectOfClass(preferenceValue, Boolean.class).booleanValue()) {
            return 4;
        }
        if (this.isObjectOfClass(preferenceValue, String.class).booleanValue()) {
            return 5;
        }
        if (this.isObjectOfClass(preferenceValue, Set.class).booleanValue()) {
            return 6;
        }
        throw new RuntimeException("Unknown preference type: " + preferenceValue.getClass().getSimpleName());
    }

    public void onBindViewHolder(@NonNull PreferenceViewHolder holder, int position) {
        String key = this.getKey(position);
        Object preferenceValue = this.getSharedPreferencesMap().get(key);
        holder.bind(key, preferenceValue);
    }

    public int getItemCount() {
        return this.getKeys().size();
    }

    private <T> T getValue(int position) {
        String key = this.getKey(position);
        return (T)this.getSharedPreferencesMap().get(key);
    }

    public void notifyKeyChanged(String key) {
        int index = this.getKeysSorted().indexOf(key);
        this.notifyItemChanged(index);
    }

    private String getKey(int position) {
        return this.getKeysSorted().get(position);
    }

    private Boolean isObjectOfClass(Object object, Class<?> clazz) {
        return clazz.isAssignableFrom(object.getClass());
    }

    private Map<String, ?> getSharedPreferencesMap() {
        return this.sharedPreferences.getAll();
    }

    private Set<String> getKeys() {
        return this.getSharedPreferencesMap().keySet();
    }

    private List<String> getKeysSorted() {
        ArrayList<String> sortedList = new ArrayList<String>(this.getKeys());
        Collections.sort(sortedList);
        return sortedList;
    }
}

