/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.sharedpreferences.list;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.RecyclerView;
import com.willowtreeapps.hyperion.plugin.v1.HyperionIgnore;
import com.willowtreeapps.hyperion.sharedpreferences.R;
import com.willowtreeapps.hyperion.sharedpreferences.list.SharedPreferencesListAdapter;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@HyperionIgnore
public class SharedPreferencesListActivity
extends AppCompatActivity {
    private static final String PREFS_DIRECTORY = "shared_prefs";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hsp_activity_shared_preferences_list);
        this.setSupportActionBar((Toolbar)this.findViewById(R.id.hsp_toolbar));
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        List<String> preferences = this.getPreferences();
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.hsp_prefs_recycler);
        recyclerView.setAdapter((RecyclerView.Adapter)new SharedPreferencesListAdapter(preferences));
    }

    public boolean onSupportNavigateUp() {
        this.onBackPressed();
        return true;
    }

    private List<String> getPreferences() {
        File prefsDirectory = new File(this.getApplicationInfo().dataDir, PREFS_DIRECTORY);
        if (prefsDirectory.exists() && prefsDirectory.isDirectory()) {
            String[] list = prefsDirectory.list();
            if (list == null) {
                return Collections.emptyList();
            }
            this.removeExtensions(list);
            return Arrays.asList(list);
        }
        return Collections.emptyList();
    }

    private void removeExtensions(String[] list) {
        for (int i = 0; i < list.length; ++i) {
            String item = list[i];
            list[i] = this.removeExtension(item);
        }
    }

    private String removeExtension(String str) {
        int index = str.lastIndexOf(46);
        if (index > 0) {
            return str.substring(0, index);
        }
        return str;
    }
}

