/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.willowtreeapps.hyperion.sharedpreferences.R;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.PreferenceViewHolder;
import com.willowtreeapps.hyperion.sharedpreferences.detail.viewholder.SharedPreferenceEditorListener;

public class LongPreferenceViewHolder
extends PreferenceViewHolder<Long> {
    private static final String TAG = "IntPrefViewHolder";
    private final EditText editTextValue;

    public LongPreferenceViewHolder(View itemView, SharedPreferences sharedPreferences) {
        super(itemView);
        this.editTextValue = (EditText)itemView.findViewById(R.id.hsp_navigation_preference_value);
        this.editTextValue.setOnEditorActionListener((TextView.OnEditorActionListener)new EditorListener(sharedPreferences));
    }

    @Override
    @SuppressLint(value={"SetTextI18n"})
    public void bind(String preferenceKey, Long preferenceValue) {
        super.bind(preferenceKey, preferenceValue);
        this.editTextValue.setText((CharSequence)preferenceValue.toString());
    }

    private class EditorListener
    extends SharedPreferenceEditorListener {
        EditorListener(SharedPreferences sharedPreferences) {
            super(sharedPreferences);
        }

        public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
            try {
                long value = Long.parseLong(v.getText().toString());
                if (value != this.sharedPreferences.getLong(LongPreferenceViewHolder.this.getKey(), 0L)) {
                    this.sharedPreferences.edit().putLong(LongPreferenceViewHolder.this.getKey(), value).apply();
                }
            }
            catch (Exception e) {
                Log.e((String)LongPreferenceViewHolder.TAG, (String)"Unable to parse integer", (Throwable)e);
            }
            return true;
        }
    }
}

