/*
 * Decompiled with CFR 0.152.
 */
package com.willowtreeapps.hyperion.sharedpreferences.list;

import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SearchView;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.RecyclerView;
import com.willowtreeapps.hyperion.plugin.v1.HyperionIgnore;
import com.willowtreeapps.hyperion.sharedpreferences.R;
import com.willowtreeapps.hyperion.sharedpreferences.list.SharedPreferencesListAdapter;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@HyperionIgnore
public class SharedPreferencesListActivity
extends AppCompatActivity {
    private static final String PREFS_DIRECTORY = "shared_prefs";
    private SharedPreferencesListAdapter mHspAdapter;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hsp_activity_shared_preferences_list);
        this.setSupportActionBar((Toolbar)this.findViewById(R.id.hsp_toolbar));
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        List<String> preferences = this.getPreferences();
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.hsp_prefs_recycler);
        this.mHspAdapter = new SharedPreferencesListAdapter(preferences);
        recyclerView.setAdapter((RecyclerView.Adapter)this.mHspAdapter);
    }

    public boolean onSupportNavigateUp() {
        this.onBackPressed();
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        super.onCreateOptionsMenu(menu2);
        this.getMenuInflater().inflate(R.menu.hsp_filter, menu2);
        MenuItem searchViewItem = menu2.findItem(R.id.menu_item_filter);
        SearchView searchView = (SearchView)searchViewItem.getActionView();
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String query) {
                if (SharedPreferencesListActivity.this.mHspAdapter != null) {
                    SharedPreferencesListActivity.this.mHspAdapter.filter(query);
                }
                return false;
            }

            public boolean onQueryTextChange(String newText) {
                if (SharedPreferencesListActivity.this.mHspAdapter != null) {
                    SharedPreferencesListActivity.this.mHspAdapter.filter(newText);
                }
                return false;
            }
        });
        return true;
    }

    private List<String> getPreferences() {
        File prefsDirectory = new File(this.getApplicationInfo().dataDir, PREFS_DIRECTORY);
        if (prefsDirectory.exists() && prefsDirectory.isDirectory()) {
            String[] list = prefsDirectory.list();
            if (list == null) {
                return Collections.emptyList();
            }
            this.removeExtensions(list);
            return Arrays.asList(list);
        }
        return Collections.emptyList();
    }

    private void removeExtensions(String[] list) {
        for (int i = 0; i < list.length; ++i) {
            String item = list[i];
            list[i] = this.removeExtension(item);
        }
    }

    private String removeExtension(String str) {
        int index = str.lastIndexOf(46);
        if (index > 0) {
            return str.substring(0, index);
        }
        return str;
    }
}

