@file:Suppress("ConflictingExtensionProperty")

package com.willowtreeapps.opentest4k

import java.nio.charset.Charset
import kotlin.reflect.KClass

actual typealias ValueWrapper = org.opentest4j.ValueWrapper

actual fun Any?.toValueWrapper(): ValueWrapper = org.opentest4j.ValueWrapper.create(this)
actual fun Any?.toValueWrapper(stringRepresentation: String?): ValueWrapper = org.opentest4j.ValueWrapper.create(this, stringRepresentation)
actual inline val ValueWrapper.value: Any? get() = throw NotImplementedError()
actual inline val ValueWrapper.valueType: KClass<*>? get() = type?.kotlin
actual inline val ValueWrapper.ephemeralValue: Any? get() = throw NotImplementedError()
actual inline val ValueWrapper.stringRepresentation: String get() = throw NotImplementedError()
actual inline val ValueWrapper.identityHashCode: Int get() = throw NotImplementedError()

actual typealias AssertionFailedError = org.opentest4j.AssertionFailedError

actual inline val AssertionFailedError.isExpectedDefined: Boolean get() = throw NotImplementedError()
actual inline val AssertionFailedError.isActualDefined: Boolean get() = throw NotImplementedError()
actual inline val AssertionFailedError.expected: ValueWrapper? get() = throw NotImplementedError()
actual inline val AssertionFailedError.actual: ValueWrapper? get() = throw NotImplementedError()

actual typealias MultipleFailuresError = org.opentest4j.MultipleFailuresError

actual inline val MultipleFailuresError.failures: List<Throwable> get() = throw NotImplementedError()

actual typealias IncompleteExecutionException = org.opentest4j.IncompleteExecutionException
actual typealias TestAbortedException = org.opentest4j.TestAbortedException
actual typealias TestSkippedException = org.opentest4j.TestSkippedException

actual typealias FileInfo = org.opentest4j.FileInfo
actual inline val FileInfo.path: String get() = throw NotImplementedError()
actual inline val FileInfo.contents: ByteArray get() = throw NotImplementedError()
@Suppress("NOTHING_TO_INLINE")
actual inline fun FileInfo.contentsAsString() = getContentsAsString(Charset.forName("UTF-8"))

internal actual fun Throwable.className() = this::class.java.name