/*
 * Decompiled with CFR 0.152.
 */
package com.windhc.cors.config;

import com.windhc.cors.config.CorsProperties;
import com.windhc.cors.filter.CorsFilter;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={CorsFilter.class})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={CorsProperties.class})
@ConditionalOnProperty(prefix="cors", name={"enabled"}, havingValue="true")
public class CorsAutoConfiguration {
    @Autowired
    private CorsProperties properties;

    @Bean
    public FilterRegistrationBean corsFilterChainRegistration() {
        if (this.properties.isAllowCredentials() && StringUtils.isEmpty((Object)this.properties.getAllowOrigin().trim())) {
            throw new IllegalStateException("Allow origin can not be null if allow credentials of CORS");
        }
        CorsFilter corsFilter = new CorsFilter();
        if (!StringUtils.isEmpty((Object)this.properties.getAllowOrigin().trim())) {
            corsFilter.setAllowOrigin(this.properties.getAllowOrigin());
        }
        corsFilter.setAllowHeaders(this.properties.getAllowHeaders());
        corsFilter.setAllowCredentials(this.properties.isAllowCredentials());
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)corsFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setOrder(Integer.MIN_VALUE);
        return registration;
    }
}

