/*
 * Decompiled with CFR 0.152.
 */
package com.windhc.cors.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class CorsFilter
extends OncePerRequestFilter {
    private static final String[] ALLOW_HEADERS = new String[]{"Content-Type", "Cache-Control", "Pragma", "Origin", "Cookie", "Link", "X-Total-Count", "*"};
    private String allowOrigin = "*";
    private String allowHeaders = "";
    private boolean allowCredentials = false;

    public void setAllowOrigin(String allowOrigin) {
        this.allowOrigin = allowOrigin;
    }

    public void setAllowHeaders(String allowHeaders) {
        this.allowHeaders = allowHeaders;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (CorsUtils.isCorsRequest((HttpServletRequest)request)) {
            response.setHeader("Access-Control-Allow-Origin", this.allowOrigin);
            response.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, PATCH, DELETE, HEAD, OPTIONS");
            response.setHeader("Access-Control-Max-Age", "3600");
            response.setHeader("Access-Control-Allow-Credentials", String.valueOf(this.allowCredentials));
            if (!StringUtils.isEmpty((Object)this.allowHeaders)) {
                response.setHeader("Access-Control-Allow-Headers", this.allowHeaders);
                response.setHeader("Access-Control-Expose-Headers", this.allowHeaders);
            }
            if (request.getMethod().equalsIgnoreCase("OPTIONS")) {
                response.setStatus(200);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

