/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.windowsazure.messaging.AppleRegistration;
import java.util.HashMap;
import java.util.Map;

public class AppleTemplateRegistration
extends AppleRegistration {
    private static final String APNS_TEMPLATE_REGISTRATION1 = "<?xml version=\"1.0\" encoding=\"utf-8\"?><entry xmlns=\"http://www.w3.org/2005/Atom\"><content type=\"application/xml\"><AppleTemplateRegistrationDescription xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://schemas.microsoft.com/netservices/2010/10/servicebus/connect\">";
    private static final String APNS_TEMPLATE_REGISTRATION2 = "<DeviceToken>";
    private static final String APNS_TEMPLATE_REGISTRATION3 = "</DeviceToken><BodyTemplate><![CDATA[";
    private static final String APNS_TEMPLATE_REGISTRATION4 = "]]></BodyTemplate>";
    private static final String APNS_TEMPLATE_REGISTRATION5 = "</AppleTemplateRegistrationDescription></content></entry>";
    private String bodyTemplate;
    private String expiry;
    private Map<String, String> headers = new HashMap<String, String>();

    public AppleTemplateRegistration() {
    }

    public AppleTemplateRegistration(String registrationId, String deviceToken, String bodyTemplate) {
        super(registrationId, deviceToken);
        this.bodyTemplate = bodyTemplate;
    }

    public AppleTemplateRegistration(String deviceToken, String bodyTemplate) {
        super(deviceToken);
        this.bodyTemplate = bodyTemplate;
    }

    public AppleTemplateRegistration(String deviceToken, String bodyTemplate, Map<String, String> headers) {
        super(deviceToken);
        this.bodyTemplate = bodyTemplate;
        this.headers = headers;
    }

    public String getBodyTemplate() {
        return this.bodyTemplate;
    }

    public void setBodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
    }

    public String getExpiry() {
        return this.expiry;
    }

    public void setExpiry(String expiry) {
        this.expiry = expiry;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bodyTemplate == null ? 0 : this.bodyTemplate.hashCode());
        result = 31 * result + (this.expiry == null ? 0 : this.expiry.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AppleTemplateRegistration other = (AppleTemplateRegistration)obj;
        if (this.bodyTemplate == null ? other.bodyTemplate != null : !this.bodyTemplate.equals(other.bodyTemplate)) {
            return false;
        }
        if (this.expiry == null ? other.expiry != null : !this.expiry.equals(other.expiry)) {
            return false;
        }
        return !(this.headers == null ? other.headers != null : !this.headers.equals(other.headers));
    }

    @Override
    public String getXml() {
        StringBuffer buf = new StringBuffer();
        buf.append(APNS_TEMPLATE_REGISTRATION1);
        buf.append(this.getTagsXml());
        buf.append(APNS_TEMPLATE_REGISTRATION2);
        buf.append(this.deviceToken);
        buf.append(APNS_TEMPLATE_REGISTRATION3);
        buf.append(this.bodyTemplate);
        buf.append(APNS_TEMPLATE_REGISTRATION4);
        buf.append(this.getExpiryXml());
        buf.append(this.getHeadersXml());
        buf.append(APNS_TEMPLATE_REGISTRATION5);
        return buf.toString();
    }

    private String getHeadersXml() {
        StringBuffer buf = new StringBuffer();
        if (!this.headers.isEmpty()) {
            buf.append("<ApnsHeaders>");
            for (String key : this.headers.keySet()) {
                buf.append("<ApnsHeader><Header>");
                buf.append(key).append("</Header><Value>");
                buf.append(this.headers.get(key)).append("</Value></ApnsHeader>");
            }
        }
        buf.append("</ApnsHeaders>");
        return buf.toString();
    }

    private String getExpiryXml() {
        if (this.expiry == null) {
            return "";
        }
        return "<Expiry>" + this.expiry + "</Expiry>";
    }
}

