/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.windowsazure.messaging.MpnsRegistration;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class MpnsTemplateRegistration
extends MpnsRegistration {
    private static final String MPNS_TEMPLATE_REGISTRATION1 = "<?xml version=\"1.0\" encoding=\"utf-8\"?><entry xmlns=\"http://www.w3.org/2005/Atom\"><content type=\"application/xml\"><MpnsTemplateRegistrationDescription xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://schemas.microsoft.com/netservices/2010/10/servicebus/connect\">";
    private static final String MPNS_TEMPLATE_REGISTRATION2 = "<ChannelUri>";
    private static final String MPNS_TEMPLATE_REGISTRATION3 = "</ChannelUri><BodyTemplate><![CDATA[";
    private static final String MPNS_TEMPLATE_REGISTRATION4 = "]]></BodyTemplate>";
    private static final String MPNS_TEMPLATE_REGISTRATION5 = "</MpnsTemplateRegistrationDescription></content></entry>";
    private String bodyTemplate;
    private Map<String, String> headers = new HashMap<String, String>();

    public MpnsTemplateRegistration() {
    }

    public MpnsTemplateRegistration(URI channelUri, String bodyTemplate, Map<String, String> headers) {
        super(channelUri);
        this.bodyTemplate = bodyTemplate;
        this.headers = headers;
    }

    public MpnsTemplateRegistration(URI channelUri, String bodyTemplate) {
        super(channelUri);
        this.bodyTemplate = bodyTemplate;
    }

    public String getBodyTemplate() {
        return this.bodyTemplate;
    }

    public void setBodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bodyTemplate == null ? 0 : this.bodyTemplate.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MpnsTemplateRegistration other = (MpnsTemplateRegistration)obj;
        if (this.bodyTemplate == null ? other.bodyTemplate != null : !this.bodyTemplate.equals(other.bodyTemplate)) {
            return false;
        }
        return !(this.headers == null ? other.headers != null : !this.headers.equals(other.headers));
    }

    @Override
    public String getXml() {
        StringBuffer buf = new StringBuffer();
        buf.append(MPNS_TEMPLATE_REGISTRATION1);
        buf.append(this.getTagsXml());
        buf.append(MPNS_TEMPLATE_REGISTRATION2);
        buf.append(this.channelUri.toString());
        buf.append(MPNS_TEMPLATE_REGISTRATION3);
        buf.append(this.bodyTemplate);
        buf.append(MPNS_TEMPLATE_REGISTRATION4);
        buf.append(this.getHeadersXml());
        buf.append(MPNS_TEMPLATE_REGISTRATION5);
        return buf.toString();
    }

    private String getHeadersXml() {
        StringBuffer buf = new StringBuffer();
        if (!this.headers.isEmpty()) {
            buf.append("<MpnsHeaders>");
            for (String key : this.headers.keySet()) {
                buf.append("<MpnsHeader><Header>");
                buf.append(key).append("</Header><Value>");
                buf.append(this.headers.get(key)).append("</Value></MpnsHeader>");
            }
            buf.append("</MpnsHeaders>");
        }
        return buf.toString();
    }
}

