/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.google.gson.GsonBuilder;
import com.windowsazure.messaging.CollectionResult;
import com.windowsazure.messaging.HttpClientManager;
import com.windowsazure.messaging.INotificationHub;
import com.windowsazure.messaging.Installation;
import com.windowsazure.messaging.Notification;
import com.windowsazure.messaging.NotificationHubJob;
import com.windowsazure.messaging.NotificationHubsException;
import com.windowsazure.messaging.NotificationOutcome;
import com.windowsazure.messaging.NotificationTelemetry;
import com.windowsazure.messaging.PartialUpdateOperation;
import com.windowsazure.messaging.Registration;
import com.windowsazure.messaging.SdkGlobalSettings;
import com.windowsazure.messaging.SyncCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class NotificationHub
implements INotificationHub {
    private static final String APIVERSION = "?api-version=2015-04";
    private static final String CONTENT_LOCATION_HEADER = "Location";
    private static final String TRACKING_ID_HEADER = "TrackingId";
    private String endpoint;
    private String hubPath;
    private String SasKeyName;
    private String SasKeyValue;

    public NotificationHub(String connectionString, String hubPath) {
        this.hubPath = hubPath;
        String[] parts = connectionString.split(";");
        if (parts.length != 3) {
            throw new RuntimeException("Error parsing connection string: " + connectionString);
        }
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].startsWith("Endpoint")) {
                this.endpoint = "https" + parts[i].substring(11);
                continue;
            }
            if (parts[i].startsWith("SharedAccessKeyName")) {
                this.SasKeyName = parts[i].substring(20);
                continue;
            }
            if (!parts[i].startsWith("SharedAccessKey")) continue;
            this.SasKeyValue = parts[i].substring(16);
        }
    }

    @Override
    public void createRegistrationAsync(Registration registration, final FutureCallback<Registration> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/registrations" + APIVERSION);
            final HttpPost post = new HttpPost(uri);
            post.setHeader("Authorization", this.generateSasToken(uri));
            StringEntity entity = new StringEntity(registration.getXml(), ContentType.APPLICATION_ATOM_XML);
            entity.setContentEncoding("utf-8");
            post.setEntity((HttpEntity)entity);
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)post, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed((Object)Registration.parse(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        post.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    post.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    post.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Registration createRegistration(Registration registration) throws NotificationHubsException {
        SyncCallback<Registration> callback = new SyncCallback<Registration>();
        this.createRegistrationAsync(registration, callback);
        return callback.getResult();
    }

    @Override
    public void createRegistrationIdAsync(final FutureCallback<String> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/registrationids" + APIVERSION);
            final HttpPost post = new HttpPost(uri);
            post.setHeader("Authorization", this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)post, (FutureCallback)new FutureCallback<HttpResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 201) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        String location = response.getFirstHeader(NotificationHub.CONTENT_LOCATION_HEADER).getValue();
                        Pattern extractId = Pattern.compile("(\\S+)/registrationids/([^?]+).*");
                        Matcher m = extractId.matcher(location);
                        m.matches();
                        String id = m.group(2);
                        callback.completed((Object)id);
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        post.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    post.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    post.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String createRegistrationId() throws NotificationHubsException {
        SyncCallback<String> callback = new SyncCallback<String>();
        this.createRegistrationIdAsync(callback);
        return callback.getResult();
    }

    @Override
    public void updateRegistrationAsync(Registration registration, final FutureCallback<Registration> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/registrations/" + registration.getRegistrationId() + APIVERSION);
            final HttpPut put = new HttpPut(uri);
            put.setHeader("Authorization", this.generateSasToken(uri));
            put.setHeader("If-Match", registration.getEtag() == null ? "*" : "W/\"" + registration.getEtag() + "\"");
            put.setEntity((HttpEntity)new StringEntity(registration.getXml(), ContentType.APPLICATION_ATOM_XML));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)put, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed((Object)Registration.parse(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        put.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    put.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    put.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Registration updateRegistration(Registration registration) throws NotificationHubsException {
        SyncCallback<Registration> callback = new SyncCallback<Registration>();
        this.updateRegistrationAsync(registration, callback);
        return callback.getResult();
    }

    @Override
    public void upsertRegistrationAsync(Registration registration, final FutureCallback<Registration> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/registrations/" + registration.getRegistrationId() + APIVERSION);
            final HttpPut put = new HttpPut(uri);
            put.setHeader("Authorization", this.generateSasToken(uri));
            put.setEntity((HttpEntity)new StringEntity(registration.getXml(), ContentType.APPLICATION_ATOM_XML));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)put, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed((Object)Registration.parse(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        put.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    put.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    put.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Registration upsertRegistration(Registration registration) throws NotificationHubsException {
        SyncCallback<Registration> callback = new SyncCallback<Registration>();
        this.upsertRegistrationAsync(registration, callback);
        return callback.getResult();
    }

    @Override
    public void deleteRegistrationAsync(Registration registration, FutureCallback<Object> callback) {
        this.deleteRegistrationAsync(registration.getRegistrationId(), callback);
    }

    @Override
    public void deleteRegistration(Registration registration) throws NotificationHubsException {
        SyncCallback<Object> callback = new SyncCallback<Object>();
        this.deleteRegistrationAsync(registration, callback);
        callback.getResult();
    }

    @Override
    public void deleteRegistrationAsync(String registrationId, final FutureCallback<Object> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/registrations/" + registrationId + APIVERSION);
            final HttpDelete delete = new HttpDelete(uri);
            delete.setHeader("Authorization", this.generateSasToken(uri));
            delete.setHeader("If-Match", "*");
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)delete, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200 && httpStatusCode != 404) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed(null);
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        delete.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    delete.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    delete.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteRegistration(String registrationId) throws NotificationHubsException {
        SyncCallback<Object> callback = new SyncCallback<Object>();
        this.deleteRegistrationAsync(registrationId, callback);
        callback.getResult();
    }

    @Override
    public void getRegistrationAsync(String registrationId, final FutureCallback<Registration> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/registrations/" + registrationId + APIVERSION);
            final HttpGet get = new HttpGet(uri);
            get.setHeader("Authorization", this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)get, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed((Object)Registration.parse(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        get.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    get.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    get.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Registration getRegistration(String registrationId) throws NotificationHubsException {
        SyncCallback<Registration> callback = new SyncCallback<Registration>();
        this.getRegistrationAsync(registrationId, callback);
        return callback.getResult();
    }

    @Override
    public void getRegistrationsAsync(int top, String continuationToken, FutureCallback<CollectionResult> callback) {
        String queryUri = this.endpoint + this.hubPath + "/registrations" + APIVERSION + this.getQueryString(top, continuationToken);
        this.retrieveRegistrationCollectionAsync(queryUri, callback);
    }

    @Override
    public CollectionResult getRegistrations(int top, String continuationToken) throws NotificationHubsException {
        SyncCallback<CollectionResult> callback = new SyncCallback<CollectionResult>();
        this.getRegistrationsAsync(top, continuationToken, callback);
        return callback.getResult();
    }

    @Override
    public CollectionResult getRegistrations() throws NotificationHubsException {
        return this.getRegistrations(0, null);
    }

    @Override
    public void getRegistrationsByTagAsync(String tag, int top, String continuationToken, FutureCallback<CollectionResult> callback) {
        String queryUri = this.endpoint + this.hubPath + "/tags/" + tag + "/registrations" + APIVERSION + this.getQueryString(top, continuationToken);
        this.retrieveRegistrationCollectionAsync(queryUri, callback);
    }

    @Override
    public CollectionResult getRegistrationsByTag(String tag, int top, String continuationToken) throws NotificationHubsException {
        SyncCallback<CollectionResult> callback = new SyncCallback<CollectionResult>();
        this.getRegistrationsByTagAsync(tag, top, continuationToken, callback);
        return callback.getResult();
    }

    @Override
    public void getRegistrationsByTagAsync(String tag, FutureCallback<CollectionResult> callback) {
        this.getRegistrationsByTagAsync(tag, 0, null, callback);
    }

    @Override
    public CollectionResult getRegistrationsByTag(String tag) throws NotificationHubsException {
        SyncCallback<CollectionResult> callback = new SyncCallback<CollectionResult>();
        this.getRegistrationsByTagAsync(tag, callback);
        return callback.getResult();
    }

    @Override
    public void getRegistrationsByChannelAsync(String channel, int top, String continuationToken, FutureCallback<CollectionResult> callback) {
        String queryUri = null;
        try {
            String channelQuery = URLEncoder.encode("ChannelUri eq '" + channel + "'", "UTF-8");
            queryUri = this.endpoint + this.hubPath + "/registrations" + APIVERSION + "&$filter=" + channelQuery + this.getQueryString(top, continuationToken);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.retrieveRegistrationCollectionAsync(queryUri, callback);
    }

    @Override
    public CollectionResult getRegistrationsByChannel(String channel, int top, String continuationToken) throws NotificationHubsException {
        SyncCallback<CollectionResult> callback = new SyncCallback<CollectionResult>();
        this.getRegistrationsByChannelAsync(channel, top, continuationToken, callback);
        return callback.getResult();
    }

    @Override
    public void getRegistrationsByChannelAsync(String channel, FutureCallback<CollectionResult> callback) {
        this.getRegistrationsByChannelAsync(channel, 0, null, callback);
    }

    @Override
    public CollectionResult getRegistrationsByChannel(String channel) throws NotificationHubsException {
        SyncCallback<CollectionResult> callback = new SyncCallback<CollectionResult>();
        this.getRegistrationsByChannelAsync(channel, callback);
        return callback.getResult();
    }

    private String getQueryString(int top, String continuationToken) {
        StringBuffer buf = new StringBuffer();
        if (top > 0) {
            buf.append("&$top=" + top);
        }
        if (continuationToken != null) {
            buf.append("&ContinuationToken=" + continuationToken);
        }
        return buf.toString();
    }

    private void retrieveRegistrationCollectionAsync(String queryUri, final FutureCallback<CollectionResult> callback) {
        try {
            URI uri = new URI(queryUri);
            final HttpGet get = new HttpGet(uri);
            get.setHeader("Authorization", this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)get, (FutureCallback)new FutureCallback<HttpResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        CollectionResult result = Registration.parseRegistrations(response.getEntity().getContent());
                        Header contTokenHeader = response.getFirstHeader("X-MS-ContinuationToken");
                        if (contTokenHeader != null) {
                            result.setContinuationToken(contTokenHeader.getValue());
                        }
                        callback.completed((Object)result);
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        get.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    get.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    get.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendNotificationAsync(Notification notification, FutureCallback<NotificationOutcome> callback) {
        this.scheduleNotificationAsync(notification, "", null, callback);
    }

    @Override
    public NotificationOutcome sendNotification(Notification notification) throws NotificationHubsException {
        SyncCallback<NotificationOutcome> callback = new SyncCallback<NotificationOutcome>();
        this.sendNotificationAsync(notification, callback);
        return callback.getResult();
    }

    @Override
    public void sendNotificationAsync(Notification notification, Set<String> tags, FutureCallback<NotificationOutcome> callback) {
        this.scheduleNotificationAsync(notification, tags, null, callback);
    }

    @Override
    public NotificationOutcome sendNotification(Notification notification, Set<String> tags) throws NotificationHubsException {
        SyncCallback<NotificationOutcome> callback = new SyncCallback<NotificationOutcome>();
        this.sendNotificationAsync(notification, tags, callback);
        return callback.getResult();
    }

    @Override
    public void sendNotificationAsync(Notification notification, String tagExpression, FutureCallback<NotificationOutcome> callback) {
        this.scheduleNotificationAsync(notification, tagExpression, null, callback);
    }

    @Override
    public NotificationOutcome sendNotification(Notification notification, String tagExpression) throws NotificationHubsException {
        SyncCallback<NotificationOutcome> callback = new SyncCallback<NotificationOutcome>();
        this.sendNotificationAsync(notification, tagExpression, callback);
        return callback.getResult();
    }

    @Override
    public void scheduleNotificationAsync(Notification notification, Date scheduledTime, FutureCallback<NotificationOutcome> callback) {
        this.scheduleNotificationAsync(notification, "", scheduledTime, callback);
    }

    @Override
    public NotificationOutcome scheduleNotification(Notification notification, Date scheduledTime) throws NotificationHubsException {
        SyncCallback<NotificationOutcome> callback = new SyncCallback<NotificationOutcome>();
        this.scheduleNotificationAsync(notification, scheduledTime, callback);
        return callback.getResult();
    }

    @Override
    public void scheduleNotificationAsync(Notification notification, Set<String> tags, Date scheduledTime, FutureCallback<NotificationOutcome> callback) {
        if (tags.isEmpty()) {
            throw new IllegalArgumentException("tags has to contain at least an element");
        }
        StringBuffer exp = new StringBuffer();
        Iterator<String> iterator = tags.iterator();
        while (iterator.hasNext()) {
            exp.append(iterator.next());
            if (!iterator.hasNext()) continue;
            exp.append(" || ");
        }
        this.scheduleNotificationAsync(notification, exp.toString(), scheduledTime, callback);
    }

    @Override
    public NotificationOutcome scheduleNotification(Notification notification, Set<String> tags, Date scheduledTime) throws NotificationHubsException {
        SyncCallback<NotificationOutcome> callback = new SyncCallback<NotificationOutcome>();
        this.scheduleNotificationAsync(notification, tags, scheduledTime, callback);
        return callback.getResult();
    }

    @Override
    public void scheduleNotificationAsync(Notification notification, String tagExpression, Date scheduledTime, final FutureCallback<NotificationOutcome> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + (scheduledTime == null ? "/messages" : "/schedulednotifications") + APIVERSION);
            final HttpPost post = new HttpPost(uri);
            final String trackingId = UUID.randomUUID().toString();
            post.setHeader("Authorization", this.generateSasToken(uri));
            post.setHeader(TRACKING_ID_HEADER, trackingId);
            if (scheduledTime != null) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                String scheduledTimeHeader = df.format(scheduledTime);
                post.setHeader("ServiceBusNotification-ScheduleTime", scheduledTimeHeader);
            }
            if (tagExpression != null && !"".equals(tagExpression)) {
                post.setHeader("ServiceBusNotification-Tags", tagExpression);
            }
            for (String header : notification.getHeaders().keySet()) {
                post.setHeader(header, notification.getHeaders().get(header));
            }
            post.setEntity((HttpEntity)new StringEntity(notification.getBody(), notification.getContentType()));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)post, (FutureCallback)new FutureCallback<HttpResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 201) {
                            String msg = "";
                            if (response.getEntity() != null && response.getEntity().getContent() != null) {
                                msg = IOUtils.toString((InputStream)response.getEntity().getContent());
                            }
                            callback.failed((Exception)new NotificationHubsException("Error: " + response.getStatusLine() + " body: " + msg, httpStatusCode));
                            return;
                        }
                        String notificationId = null;
                        Header locationHeader = response.getFirstHeader(NotificationHub.CONTENT_LOCATION_HEADER);
                        if (locationHeader != null) {
                            URI location = new URI(locationHeader.getValue());
                            String[] segments = location.getPath().split("/");
                            notificationId = segments[segments.length - 1];
                        }
                        callback.completed((Object)new NotificationOutcome(trackingId, notificationId));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        post.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    post.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    post.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NotificationOutcome scheduleNotification(Notification notification, String tagExpression, Date scheduledTime) throws NotificationHubsException {
        SyncCallback<NotificationOutcome> callback = new SyncCallback<NotificationOutcome>();
        this.scheduleNotificationAsync(notification, tagExpression, scheduledTime, callback);
        return callback.getResult();
    }

    @Override
    public void cancelScheduledNotification(String notificationId) throws NotificationHubsException {
        SyncCallback<Object> callback = new SyncCallback<Object>();
        this.cancelScheduledNotificationAsync(notificationId, callback);
        callback.getResult();
    }

    @Override
    public void cancelScheduledNotificationAsync(String notificationId, final FutureCallback<Object> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/schedulednotifications/" + notificationId + APIVERSION);
            final HttpDelete delete = new HttpDelete(uri);
            delete.setHeader("Authorization", this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)delete, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200 && httpStatusCode != 404) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed(null);
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        delete.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    delete.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    delete.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NotificationOutcome sendDirectNotification(Notification notification, String deviceHandle) throws NotificationHubsException {
        SyncCallback<NotificationOutcome> callback = new SyncCallback<NotificationOutcome>();
        this.sendDirectNotificationAsync(notification, deviceHandle, callback);
        return callback.getResult();
    }

    @Override
    public NotificationOutcome sendDirectNotification(Notification notification, List<String> deviceHandles) throws NotificationHubsException {
        SyncCallback<NotificationOutcome> callback = new SyncCallback<NotificationOutcome>();
        this.sendDirectNotificationAsync(notification, deviceHandles, callback);
        return callback.getResult();
    }

    @Override
    public void sendDirectNotificationAsync(Notification notification, String deviceHandle, final FutureCallback<NotificationOutcome> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/messages" + APIVERSION + "&direct");
            final HttpPost post = new HttpPost(uri);
            final String trackingId = UUID.randomUUID().toString();
            post.setHeader("ServiceBusNotification-DeviceHandle", deviceHandle);
            post.setHeader("Authorization", this.generateSasToken(uri));
            post.setHeader(TRACKING_ID_HEADER, trackingId);
            for (String header : notification.getHeaders().keySet()) {
                post.setHeader(header, notification.getHeaders().get(header));
            }
            post.setEntity((HttpEntity)new StringEntity(notification.getBody(), notification.getContentType()));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)post, (FutureCallback)new FutureCallback<HttpResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 201) {
                            String msg = "";
                            if (response.getEntity() != null && response.getEntity().getContent() != null) {
                                msg = IOUtils.toString((InputStream)response.getEntity().getContent());
                            }
                            callback.failed((Exception)new NotificationHubsException("Error: " + response.getStatusLine() + " body: " + msg, httpStatusCode));
                            return;
                        }
                        String notificationId = null;
                        Header locationHeader = response.getFirstHeader(NotificationHub.CONTENT_LOCATION_HEADER);
                        if (locationHeader != null) {
                            URI location = new URI(locationHeader.getValue());
                            String[] segments = location.getPath().split("/");
                            notificationId = segments[segments.length - 1];
                        }
                        callback.completed((Object)new NotificationOutcome(trackingId, notificationId));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        post.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    post.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    post.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendDirectNotificationAsync(Notification notification, List<String> deviceHandles, final FutureCallback<NotificationOutcome> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/messages/$batch" + APIVERSION + "&direct");
            final HttpPost post = new HttpPost(uri);
            final String trackingId = UUID.randomUUID().toString();
            post.setHeader("Authorization", this.generateSasToken(uri));
            post.setHeader(TRACKING_ID_HEADER, trackingId);
            for (String header : notification.getHeaders().keySet()) {
                post.setHeader(header, notification.getHeaders().get(header));
            }
            FormBodyPart notificationPart = FormBodyPartBuilder.create().setName("notification").addField("Content-Disposition", "inline; name=notification").setBody((ContentBody)new StringBody(notification.getBody(), notification.getContentType())).build();
            String deviceHandlesJson = new GsonBuilder().disableHtmlEscaping().create().toJson(deviceHandles);
            FormBodyPart devicesPart = FormBodyPartBuilder.create().setName("devices").addField("Content-Disposition", "inline; name=devices").setBody((ContentBody)new StringBody(deviceHandlesJson, ContentType.APPLICATION_JSON)).build();
            HttpEntity entity = MultipartEntityBuilder.create().addPart(notificationPart).addPart(devicesPart).build();
            post.setEntity(entity);
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)post, (FutureCallback)new FutureCallback<HttpResponse>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 201) {
                            String msg = "";
                            if (response.getEntity() != null && response.getEntity().getContent() != null) {
                                msg = IOUtils.toString((InputStream)response.getEntity().getContent());
                            }
                            callback.failed((Exception)new NotificationHubsException("Error: " + response.getStatusLine() + " body: " + msg, httpStatusCode));
                            return;
                        }
                        String notificationId = null;
                        Header locationHeader = response.getFirstHeader(NotificationHub.CONTENT_LOCATION_HEADER);
                        if (locationHeader != null) {
                            URI location = new URI(locationHeader.getValue());
                            String[] segments = location.getPath().split("/");
                            notificationId = segments[segments.length - 1];
                        }
                        callback.completed((Object)new NotificationOutcome(trackingId, notificationId));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        post.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    post.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    post.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NotificationTelemetry getNotificationTelemetry(String notificationId) throws NotificationHubsException {
        SyncCallback<NotificationTelemetry> callback = new SyncCallback<NotificationTelemetry>();
        this.getNotificationTelemetryAsync(notificationId, callback);
        return callback.getResult();
    }

    @Override
    public void getNotificationTelemetryAsync(String notificationId, final FutureCallback<NotificationTelemetry> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/messages/" + notificationId + APIVERSION);
            final HttpGet get = new HttpGet(uri);
            get.setHeader("Authorization", this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)get, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed((Object)NotificationTelemetry.parseOne(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        get.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    get.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    get.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createOrUpdateInstallationAsync(Installation installation, final FutureCallback<Object> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/installations/" + installation.getInstallationId() + APIVERSION);
            final HttpPut put = new HttpPut(uri);
            put.setHeader("Authorization", this.generateSasToken(uri));
            StringEntity entity = new StringEntity(installation.toJson(), ContentType.APPLICATION_JSON);
            entity.setContentEncoding("utf-8");
            put.setEntity((HttpEntity)entity);
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)put, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed(null);
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        put.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    put.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    put.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createOrUpdateInstallation(Installation installation) throws NotificationHubsException {
        SyncCallback<Object> callback = new SyncCallback<Object>();
        this.createOrUpdateInstallationAsync(installation, callback);
        callback.getResult();
    }

    @Override
    public void patchInstallationAsync(String installationId, FutureCallback<Object> callback, PartialUpdateOperation ... operations) {
        this.patchInstallationInternalAsync(installationId, PartialUpdateOperation.toJson(operations), callback);
    }

    @Override
    public void patchInstallation(String installationId, PartialUpdateOperation ... operations) throws NotificationHubsException {
        SyncCallback<Object> callback = new SyncCallback<Object>();
        this.patchInstallationAsync(installationId, callback, operations);
        callback.getResult();
    }

    @Override
    public void patchInstallationAsync(String installationId, List<PartialUpdateOperation> operations, FutureCallback<Object> callback) {
        this.patchInstallationInternalAsync(installationId, PartialUpdateOperation.toJson(operations), callback);
    }

    @Override
    public void patchInstallation(String installationId, List<PartialUpdateOperation> operations) throws NotificationHubsException {
        SyncCallback<Object> callback = new SyncCallback<Object>();
        this.patchInstallationAsync(installationId, operations, callback);
        callback.getResult();
    }

    private void patchInstallationInternalAsync(String installationId, String operationsJson, final FutureCallback<Object> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/installations/" + installationId + APIVERSION);
            final HttpPatch patch = new HttpPatch(uri);
            patch.setHeader("Authorization", this.generateSasToken(uri));
            StringEntity entity = new StringEntity(operationsJson, ContentType.APPLICATION_JSON);
            entity.setContentEncoding("utf-8");
            patch.setEntity((HttpEntity)entity);
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)patch, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed(null);
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        patch.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    patch.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    patch.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteInstallationAsync(String installationId, final FutureCallback<Object> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/installations/" + installationId + APIVERSION);
            final HttpDelete delete = new HttpDelete(uri);
            delete.setHeader("Authorization", this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)delete, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 204) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed(null);
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        delete.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    delete.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    delete.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteInstallation(String installationId) throws NotificationHubsException {
        SyncCallback<Object> callback = new SyncCallback<Object>();
        this.deleteInstallationAsync(installationId, callback);
        callback.getResult();
    }

    @Override
    public void getInstallationAsync(String installationId, final FutureCallback<Installation> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/installations/" + installationId + APIVERSION);
            final HttpGet get = new HttpGet(uri);
            get.setHeader("Authorization", this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)get, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed((Object)Installation.fromJson(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        get.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    get.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    get.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Installation getInstallation(String installationId) throws NotificationHubsException {
        SyncCallback<Installation> callback = new SyncCallback<Installation>();
        this.getInstallationAsync(installationId, callback);
        return callback.getResult();
    }

    @Override
    public void submitNotificationHubJobAsync(NotificationHubJob job, final FutureCallback<NotificationHubJob> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/jobs" + APIVERSION);
            final HttpPost post = new HttpPost(uri);
            post.setHeader("Authorization", this.generateSasToken(uri));
            StringEntity entity = new StringEntity(job.getXml(), ContentType.APPLICATION_ATOM_XML);
            entity.setContentEncoding("utf-8");
            post.setEntity((HttpEntity)entity);
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)post, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 201) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed((Object)NotificationHubJob.parseOne(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        post.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    post.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    post.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NotificationHubJob submitNotificationHubJob(NotificationHubJob job) throws NotificationHubsException {
        SyncCallback<NotificationHubJob> callback = new SyncCallback<NotificationHubJob>();
        this.submitNotificationHubJobAsync(job, callback);
        return callback.getResult();
    }

    @Override
    public void getNotificationHubJobAsync(String jobId, final FutureCallback<NotificationHubJob> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/jobs/" + jobId + APIVERSION);
            final HttpGet get = new HttpGet(uri);
            get.setHeader("Authorization", this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)get, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed((Object)NotificationHubJob.parseOne(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        get.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    get.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    get.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NotificationHubJob getNotificationHubJob(String jobId) throws NotificationHubsException {
        SyncCallback<NotificationHubJob> callback = new SyncCallback<NotificationHubJob>();
        this.getNotificationHubJobAsync(jobId, callback);
        return callback.getResult();
    }

    @Override
    public void getAllNotificationHubJobsAsync(final FutureCallback<List<NotificationHubJob>> callback) {
        try {
            URI uri = new URI(this.endpoint + this.hubPath + "/jobs" + APIVERSION);
            final HttpGet get = new HttpGet(uri);
            get.setHeader("Authorization", this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)get, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)new NotificationHubsException(NotificationHub.this.getErrorString(response), httpStatusCode));
                            return;
                        }
                        callback.completed(NotificationHubJob.parseCollection(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        get.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    get.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    get.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<NotificationHubJob> getAllNotificationHubJobs() throws NotificationHubsException {
        SyncCallback<List<NotificationHubJob>> callback = new SyncCallback<List<NotificationHubJob>>();
        this.getAllNotificationHubJobsAsync(callback);
        return callback.getResult();
    }

    private String getErrorString(HttpResponse response) throws IllegalStateException, IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)response.getEntity().getContent(), (Writer)writer, (String)"UTF-8");
        String body = writer.toString();
        return "Error: " + response.getStatusLine() + " - " + body;
    }

    private String generateSasToken(URI uri) {
        try {
            String targetUri = URLEncoder.encode(uri.toString().toLowerCase(), "UTF-8").toLowerCase();
            long expiresOnDate = System.currentTimeMillis();
            long expires = (expiresOnDate += (long)(SdkGlobalSettings.getAuthorizationTokenExpirationInMinutes() * 60 * 1000)) / 1000L;
            String toSign = targetUri + "\n" + expires;
            byte[] keyBytes = this.SasKeyValue.getBytes("UTF-8");
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(toSign.getBytes("UTF-8"));
            String signature = URLEncoder.encode(Base64.encodeBase64String((byte[])rawHmac), "UTF-8");
            String token = "SharedAccessSignature sr=" + targetUri + "&sig=" + signature + "&se=" + expires + "&skn=" + this.SasKeyName;
            return token;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

