/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.windowsazure.messaging.NotificationStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.digester3.Digester;
import org.xml.sax.SAXException;

public class NotificationTelemetry {
    private String notificationId;
    private String location;
    private NotificationStatus notificationStatus;
    private Date enqueueTime;
    private Date startTime;
    private Date endTime;
    private String notificationBody;
    private String targetPlatforms;
    private Map<String, Integer> apnsOutcomeCounts;
    private Map<String, Integer> mpnsOutcomeCounts;
    private Map<String, Integer> wnsOutcomeCounts;
    private Map<String, Integer> gcmOutcomeCounts;
    private Map<String, Integer> admOutcomeCounts;
    private Map<String, Integer> baiduOutcomeCounts;
    private String pnsErrorDetailsUri;
    private static final ThreadLocal<Digester> parser = new ThreadLocal<Digester>(){

        @Override
        protected Digester initialValue() {
            Digester instance = new Digester();
            NotificationTelemetry.setupParser(instance);
            return instance;
        }
    };

    public static NotificationTelemetry parseOne(InputStream content) throws IOException, SAXException {
        return (NotificationTelemetry)parser.get().parse(content);
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(String notificationId) {
        this.notificationId = notificationId;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public NotificationStatus getNotificationStatus() {
        return this.notificationStatus;
    }

    public void setNotificationStatusFromString(String status) {
        this.notificationStatus = Enum.valueOf(NotificationStatus.class, status);
    }

    public void setNotificationStatus(NotificationStatus notificationStatus) {
        this.notificationStatus = notificationStatus;
    }

    public Date getEnqueueTime() {
        return this.enqueueTime;
    }

    public void setEnqueueTimeFromString(String enqueueTime) {
        this.enqueueTime = DatatypeConverter.parseDateTime((String)enqueueTime).getTime();
    }

    public void setEnqueueTime(Date enqueueTime) {
        this.enqueueTime = enqueueTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTimeFromString(String startTime) {
        this.startTime = DatatypeConverter.parseDateTime((String)startTime).getTime();
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTimeFromString(String endTime) {
        this.endTime = DatatypeConverter.parseDateTime((String)endTime).getTime();
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getNotificationBody() {
        return this.notificationBody;
    }

    public void setNotificationBody(String notificationBody) {
        this.notificationBody = notificationBody;
    }

    public String getTargetPlatforms() {
        return this.targetPlatforms;
    }

    public void setTargetPlatforms(String targetPlatforms) {
        this.targetPlatforms = targetPlatforms;
    }

    public Map<String, Integer> getApnsOutcomeCounts() {
        return this.apnsOutcomeCounts;
    }

    public void setApnsOutcomeCounts(Map<String, Integer> apnsOutcomeCounts) {
        this.apnsOutcomeCounts = apnsOutcomeCounts;
    }

    public Map<String, Integer> getMpnsOutcomeCounts() {
        return this.mpnsOutcomeCounts;
    }

    public void setMpnsOutcomeCounts(Map<String, Integer> mpnsOutcomeCounts) {
        this.mpnsOutcomeCounts = mpnsOutcomeCounts;
    }

    public Map<String, Integer> getWnsOutcomeCounts() {
        return this.wnsOutcomeCounts;
    }

    public void setWnsOutcomeCounts(Map<String, Integer> wnsOutcomeCounts) {
        this.wnsOutcomeCounts = wnsOutcomeCounts;
    }

    public Map<String, Integer> getGcmOutcomeCounts() {
        return this.gcmOutcomeCounts;
    }

    public void setGcmOutcomeCounts(Map<String, Integer> gcmOutcomeCounts) {
        this.gcmOutcomeCounts = gcmOutcomeCounts;
    }

    public Map<String, Integer> getBaiduOutcomeCounts() {
        return this.baiduOutcomeCounts;
    }

    public void setBaiduOutcomeCounts(Map<String, Integer> baiduOutcomeCounts) {
        this.baiduOutcomeCounts = baiduOutcomeCounts;
    }

    public Map<String, Integer> getAdmOutcomeCounts() {
        return this.admOutcomeCounts;
    }

    public void setAdmOutcomeCounts(Map<String, Integer> admOutcomeCounts) {
        this.admOutcomeCounts = admOutcomeCounts;
    }

    public String getPnsErrorDetailsUri() {
        return this.pnsErrorDetailsUri;
    }

    public void setPnsErrorDetailsUri(String pnsErrorDetailsUri) {
        this.pnsErrorDetailsUri = pnsErrorDetailsUri;
    }

    private static void setupParser(Digester digester) {
        digester.addObjectCreate("*/NotificationDetails", NotificationTelemetry.class);
        digester.addCallMethod("*/NotificationId", "setNotificationId", 1);
        digester.addCallParam("*/NotificationId", 0);
        digester.addCallMethod("*/Location", "setLocation", 1);
        digester.addCallParam("*/Location", 0);
        digester.addCallMethod("*/State", "setNotificationStatusFromString", 1);
        digester.addCallParam("*/State", 0);
        digester.addCallMethod("*/EnqueueTime", "setEnqueueTimeFromString", 1);
        digester.addCallParam("*/EnqueueTime", 0);
        digester.addCallMethod("*/StartTime", "setStartTimeFromString", 1);
        digester.addCallParam("*/StartTime", 0);
        digester.addCallMethod("*/EndTime", "setEndTimeFromString", 1);
        digester.addCallParam("*/EndTime", 0);
        digester.addCallMethod("*/NotificationBody", "setNotificationBody", 1);
        digester.addCallParam("*/NotificationBody", 0);
        digester.addCallMethod("*/TargetPlatforms", "setTargetPlatforms", 1);
        digester.addCallParam("*/TargetPlatforms", 0);
        digester.addCallMethod("*/PnsErrorDetailsUri", "setPnsErrorDetailsUri", 1);
        digester.addCallParam("*/PnsErrorDetailsUri", 0);
        digester.addObjectCreate("*/ApnsOutcomeCounts", HashMap.class);
        digester.addCallMethod("*/Outcome", "put", 2, new Class[]{String.class, Integer.class});
        digester.addCallParam("*/Name", 0);
        digester.addCallParam("*/Count", 1);
        digester.addSetNext("*/ApnsOutcomeCounts", "setApnsOutcomeCounts", Map.class.getName());
        digester.addObjectCreate("*/MpnsOutcomeCounts", HashMap.class);
        digester.addCallMethod("*/Outcome", "put", 2, new Class[]{String.class, Integer.class});
        digester.addCallParam("*/Name", 0);
        digester.addCallParam("*/Count", 1);
        digester.addSetNext("*/MpnsOutcomeCounts", "setMpnsOutcomeCounts", Map.class.getName());
        digester.addObjectCreate("*/WnsOutcomeCounts", HashMap.class);
        digester.addCallMethod("*/Outcome", "put", 2, new Class[]{String.class, Integer.class});
        digester.addCallParam("*/Name", 0);
        digester.addCallParam("*/Count", 1);
        digester.addSetNext("*/WnsOutcomeCounts", "setWnsOutcomeCounts", Map.class.getName());
        digester.addObjectCreate("*/GcmOutcomeCounts", HashMap.class);
        digester.addCallMethod("*/Outcome", "put", 2, new Class[]{String.class, Integer.class});
        digester.addCallParam("*/Name", 0);
        digester.addCallParam("*/Count", 1);
        digester.addSetNext("*/GcmOutcomeCounts", "setGcmOutcomeCounts", Map.class.getName());
        digester.addObjectCreate("*/AdmOutcomeCounts", HashMap.class);
        digester.addCallMethod("*/Outcome", "put", 2, new Class[]{String.class, Integer.class});
        digester.addCallParam("*/Name", 0);
        digester.addCallParam("*/Count", 1);
        digester.addSetNext("*/AdmOutcomeCounts", "setAdmOutcomeCounts", Map.class.getName());
        digester.addObjectCreate("*/BaiduOutcomeCounts", HashMap.class);
        digester.addCallMethod("*/Outcome", "put", 2, new Class[]{String.class, Integer.class});
        digester.addCallParam("*/Name", 0);
        digester.addCallParam("*/Count", 1);
        digester.addSetNext("*/BaiduOutcomeCounts", "setBaiduOutcomeCounts", Map.class.getName());
    }
}

