/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.windowsazure.messaging.NotificationHubsException;
import java.util.concurrent.CountDownLatch;
import org.apache.http.concurrent.FutureCallback;

public class SyncCallback<T>
implements FutureCallback<T> {
    private T result;
    private RuntimeException runtimeException;
    private NotificationHubsException nhException;
    private CountDownLatch waitLatch = new CountDownLatch(1);

    public T getResult() throws NotificationHubsException {
        try {
            this.waitLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.runtimeException != null) {
            throw this.runtimeException;
        }
        if (this.nhException != null) {
            throw this.nhException;
        }
        return this.result;
    }

    public void completed(T result) {
        this.result = result;
        this.waitLatch.countDown();
    }

    public void failed(Exception ex) {
        if (ex instanceof NotificationHubsException) {
            this.nhException = (NotificationHubsException)ex;
        } else {
            this.runtimeException = new RuntimeException(ex);
        }
        this.waitLatch.countDown();
    }

    public void cancelled() {
        this.runtimeException = new RuntimeException("Operation was cancelled.");
        this.waitLatch.countDown();
    }
}

