/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.windowsazure.messaging.Registration;
import java.net.URI;
import java.net.URISyntaxException;

public class WindowsRegistration
extends Registration {
    private static final String WNS_NATIVE_REGISTRATION1 = "<?xml version=\"1.0\" encoding=\"utf-8\"?><entry xmlns=\"http://www.w3.org/2005/Atom\"><content type=\"application/xml\"><WindowsRegistrationDescription xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://schemas.microsoft.com/netservices/2010/10/servicebus/connect\">";
    private static final String WNS_NATIVE_REGISTRATION2 = "<ChannelUri>";
    private static final String WNS_NATIVE_REGISTRATION3 = "</ChannelUri></WindowsRegistrationDescription></content></entry>";
    protected URI channelUri;

    public WindowsRegistration() {
    }

    public WindowsRegistration(URI channelUri) {
        this.channelUri = channelUri;
    }

    public WindowsRegistration(String registrationId, URI channelUri) {
        super(registrationId);
        this.channelUri = channelUri;
    }

    public URI getChannelUri() {
        return this.channelUri;
    }

    public void setChannelUri(String channelUri) {
        try {
            this.channelUri = new URI(channelUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(channelUri);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.channelUri == null ? 0 : this.channelUri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindowsRegistration other = (WindowsRegistration)obj;
        return !(this.channelUri == null ? other.channelUri != null : !this.channelUri.equals(other.channelUri));
    }

    @Override
    public String getXml() {
        StringBuffer buf = new StringBuffer();
        buf.append(WNS_NATIVE_REGISTRATION1);
        buf.append(this.getTagsXml());
        buf.append(WNS_NATIVE_REGISTRATION2);
        buf.append(this.channelUri.toString());
        buf.append(WNS_NATIVE_REGISTRATION3);
        return buf.toString();
    }
}

