/*
 * Decompiled with CFR 0.152.
 */
package com.winnerlook.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.winnerlook.model.AiDialog;
import com.winnerlook.model.AiGetDialogListRequest;
import com.winnerlook.model.AiNotifyReply;
import com.winnerlook.model.AiNotifyRequest;
import com.winnerlook.model.ApiPage;
import com.winnerlook.model.CommonResponse;
import com.winnerlook.model.Header;
import com.winnerlook.service.okhttp.OkHttpService;
import com.winnerlook.util.MD5Util;
import com.winnerlook.util.SdkConfigUtil;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class AiNotifySender {
    public static String getUrl(String urlName, String requestUrl, String accountId, String token, long time) throws Exception {
        Properties prop = SdkConfigUtil.getPropertyInfo();
        String url = (String)prop.get(urlName);
        String sig = AiNotifySender.getSig(accountId, token, time);
        url = url + requestUrl + "/" + accountId + "/" + sig;
        return url;
    }

    private static String getSig(String accountId, String token, Long time) {
        return MD5Util.getMD5(accountId + token + time);
    }

    public static CommonResponse<AiNotifyReply> aiNotifyRequest(AiNotifyRequest request, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)accountId) || StringUtils.isBlank((CharSequence)token)) {
            CommonResponse<AiNotifyReply> response = new CommonResponse<AiNotifyReply>();
            response.setCode("-1");
            response.setMessage("\u65e0\u6548\u7684\u8d26\u53f7\u4fe1\u606f");
            return response;
        }
        CommonResponse result = new CommonResponse();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)request);
        String path = AiNotifySender.getUrl("AI_NOTIFY_URL_HTTPS", "aiNotifyRequest", accountId, token, time);
        String headerStr = header.getHeader();
        try {
            String response = OkHttpService.doPost(path, headerStr, requestBody);
            result = (CommonResponse)JSON.parseObject((String)response, (TypeReference)new TypeReference<CommonResponse<AiNotifyReply>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            result.setCode("-2");
            result.setMessage("Service Unavailable");
            e.printStackTrace();
        }
        return result;
    }

    public static ApiPage<AiDialog> aiGetDialogListRequest(AiGetDialogListRequest request, String accountId, String token) throws Exception {
        if (StringUtils.isBlank((CharSequence)accountId) || StringUtils.isBlank((CharSequence)token)) {
            ApiPage<AiDialog> response = new ApiPage<AiDialog>();
            response.setCode("-1");
            response.setMessage("\u65e0\u6548\u7684\u8d26\u53f7\u4fe1\u606f");
            return response;
        }
        long time = System.currentTimeMillis();
        ApiPage result = new ApiPage();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)request);
        String path = AiNotifySender.getUrl("AI_NOTIFY_URL_HTTPS", "aiGetDialogListRequest", accountId, token, time);
        String headerStr = header.getHeader();
        try {
            String response = OkHttpService.doPost(path, headerStr, requestBody);
            result = (ApiPage)JSON.parseObject((String)response, (TypeReference)new TypeReference<ApiPage<AiDialog>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            result.setCode("-2");
            result.setMessage("Service Unavailable");
            e.printStackTrace();
        }
        return result;
    }
}

