/*
 * Decompiled with CFR 0.152.
 */
package com.winnerlook.service;

import com.alibaba.fastjson.JSON;
import com.winnerlook.model.Header;
import com.winnerlook.model.MmsSendRequest;
import com.winnerlook.model.MmsSendResponse;
import com.winnerlook.service.okhttp.OkHttpService;
import com.winnerlook.util.MD5Util;
import com.winnerlook.util.SdkConfigUtil;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class MmsSender {
    public static MmsSendResponse httpSendMms(MmsSendRequest sendRequest, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)sendRequest);
        String url = MmsSender.getUrl("MMS_SEND_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        MmsSendResponse response = null;
        if (StringUtils.isNotBlank((CharSequence)result)) {
            response = (MmsSendResponse)JSON.parseObject((String)result, MmsSendResponse.class);
        }
        return response;
    }

    public static MmsSendResponse httpsSendMms(MmsSendRequest sendRequest, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)sendRequest);
        String path = MmsSender.getUrl("MMS_SEND_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        MmsSendResponse response = null;
        if (StringUtils.isNotBlank((CharSequence)result)) {
            response = (MmsSendResponse)JSON.parseObject((String)result, MmsSendResponse.class);
        }
        return response;
    }

    public static String getUrl(String urlName, String accountId, String token, long time) throws Exception {
        Properties prop = SdkConfigUtil.getPropertyInfo();
        if (prop == null) {
            throw new Exception("prop is null");
        }
        String url = (String)prop.get(urlName);
        String sig = MmsSender.getSig(accountId, token, time);
        url = url + "/" + accountId + "/" + sig;
        return url;
    }

    private static String getSig(String accountId, String token, Long time) {
        return MD5Util.getMD5(accountId + token + time);
    }
}

