/*
 * Decompiled with CFR 0.152.
 */
package com.winnerlook.service;

import com.alibaba.fastjson.JSON;
import com.winnerlook.model.Header;
import com.winnerlook.model.VoiceNotifyBody;
import com.winnerlook.model.VoiceResponseResult;
import com.winnerlook.service.okhttp.OkHttpService;
import com.winnerlook.util.MD5Util;
import com.winnerlook.util.SdkConfigUtil;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class NotifySender {
    private static String getSig(String accountId, String token, Long time) {
        return MD5Util.getMD5(accountId + token + time);
    }

    public static String getUrl(String urlName, String accountId, String token, long time) throws Exception {
        Properties prop = SdkConfigUtil.getPropertyInfo();
        if (prop == null) {
            throw new Exception("prop is null");
        }
        String url = (String)prop.get(urlName);
        String sig = NotifySender.getSig(accountId, token, time);
        url = url + "/" + accountId + "/" + sig;
        return url;
    }

    public static VoiceResponseResult httpSendInteractNotify(VoiceNotifyBody voiceNotifyBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)voiceNotifyBody);
        String url = NotifySender.getUrl("INTERACT_NOTIFY_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpSubmitTemplateFile(File file, String content, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String url = NotifySender.getUrl("VOICENOTIFY_FILESUBMIT_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doUpload(url, header.getHeader(), file, content);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsSendInteractNotify(VoiceNotifyBody voiceNotifyBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)voiceNotifyBody);
        String path = NotifySender.getUrl("INTERACT_NOTIFY_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }
}

