/*
 * Decompiled with CFR 0.152.
 */
package com.winnerlook.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.winnerlook.model.AxGroupBindRequest;
import com.winnerlook.model.AxGroupUpCreateRequest;
import com.winnerlook.model.BatchCallResponse;
import com.winnerlook.model.BathwayWhiteListBody;
import com.winnerlook.model.BindNumberBody;
import com.winnerlook.model.CommonResponse;
import com.winnerlook.model.Header;
import com.winnerlook.model.PrivacyAxbTransfer;
import com.winnerlook.model.PrivacyBindBodyAx;
import com.winnerlook.model.PrivacyBindBodyAxb;
import com.winnerlook.model.PrivacyBindBodyXyb;
import com.winnerlook.model.PrivacyQueryRelationBody;
import com.winnerlook.model.PrivacyUnbindBody;
import com.winnerlook.model.PrivacyUnbindRelationBody;
import com.winnerlook.model.RelationResponse;
import com.winnerlook.model.RelationsResponse;
import com.winnerlook.model.TwoWayCallBody;
import com.winnerlook.model.TwoWayPrivacyCallBody;
import com.winnerlook.model.TwoWayPrivacyCallResult;
import com.winnerlook.model.VoiceNotifyBody;
import com.winnerlook.model.VoiceResponseResult;
import com.winnerlook.model.VoiceVerifyBody;
import com.winnerlook.service.okhttp.OkHttpService;
import com.winnerlook.util.MD5Util;
import com.winnerlook.util.SdkConfigUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class VoiceSender {
    public static VoiceResponseResult httpSendVoiceNotify(VoiceNotifyBody voiceNotifyBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)voiceNotifyBody);
        String url = VoiceSender.getUrl("VOICENOTIFY_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static BatchCallResponse httpSendCancelBatchVoiceNotify(String accountId, String token, String taskId) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String url = VoiceSender.getUrl("BATCH_NOTIFY_URL_HTTP", accountId, token, time);
        url = url + "/" + taskId;
        String result = OkHttpService.doDelete(url, header.getHeader());
        BatchCallResponse notifyResp = new BatchCallResponse();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (BatchCallResponse)JSON.parseObject((String)result, BatchCallResponse.class);
        }
        return notifyResp;
    }

    public static BatchCallResponse httpSendBatchVoiceNotify(VoiceNotifyBody voiceNotifyBody, String accountId, String token, InputStream inputStream, List<String> extraNumbers) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)voiceNotifyBody);
        String url = VoiceSender.getUrl("BATCH_NOTIFY_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPostInputStream(url, header.getHeader(), body, inputStream, "numberFile", JSON.toJSONString(extraNumbers));
        BatchCallResponse notifyResp = new BatchCallResponse();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (BatchCallResponse)JSON.parseObject((String)result, BatchCallResponse.class);
        }
        return notifyResp;
    }

    public static BatchCallResponse httpSendBatchVoiceNotify(VoiceNotifyBody voiceNotifyBody, String accountId, String token, File numberFile, List<String> extraNumbers) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)voiceNotifyBody);
        String url = VoiceSender.getUrl("BATCH_NOTIFY_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPostFile(url, header.getHeader(), body, numberFile, "numberFile");
        BatchCallResponse notifyResp = new BatchCallResponse();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (BatchCallResponse)JSON.parseObject((String)result, BatchCallResponse.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsSendVoiceNotify(VoiceNotifyBody voiceNotifyBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)voiceNotifyBody);
        String path = VoiceSender.getUrl("VOICENOTIFY_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsSendBatchVoiceNotify(VoiceNotifyBody voiceNotifyBody, String accountId, String token, File numberFile) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)voiceNotifyBody);
        String path = VoiceSender.getUrl("BATCH_NOTIFY_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPostFile(path, headerStr, requestBody, numberFile, "numberFile");
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpSendVoiceVerify(VoiceVerifyBody voiceVerityBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)voiceVerityBody);
        String url = VoiceSender.getUrl("VOICEVERITY_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpUpcreateAxgroup(AxGroupUpCreateRequest upCreateRequest, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)upCreateRequest);
        String url = VoiceSender.getUrl("PRIVACY_AXG_GROUPCREATE_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpAxgBind(AxGroupBindRequest bindRequest, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)bindRequest);
        String url = VoiceSender.getUrl("PRIVACY_AXG_BIND_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpAxgUnbind(PrivacyUnbindBody unbindBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)unbindBody);
        String url = VoiceSender.getUrl("PRIVACY_AXG_UNBIND_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpPrivacyBindAx(PrivacyBindBodyAx bindBodyAx, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)bindBodyAx);
        String url = VoiceSender.getUrl("PRIVACY_AX_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpPrivacyBindAxb(PrivacyBindBodyAxb bindBodyAxb, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)bindBodyAxb);
        String url = VoiceSender.getUrl("PRIVACY_AXB_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpPrivacyBindXyb(PrivacyBindBodyXyb bindBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)bindBody);
        String url = VoiceSender.getUrl("PRIVACY_XYB_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpAxbTransfer(PrivacyAxbTransfer transfer, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)transfer);
        String url = VoiceSender.getUrl("PRIVACY_AXB_TRANSFER_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpPrivacyUnbind(PrivacyUnbindBody unbindBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)unbindBody);
        String url = VoiceSender.getUrl("PRIVACY_UNBIND_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsPrivacyBindAx(PrivacyBindBodyAx bindBodyAx, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)bindBodyAx);
        String url = VoiceSender.getUrl("PRIVACY_AX_URL_HTTPS", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsAxbTransfer(PrivacyAxbTransfer transfer, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)transfer);
        String url = VoiceSender.getUrl("PRIVACY_AXB_TRANSFER_URL_HTTPS", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsPrivacyBindAxb(PrivacyBindBodyAxb bindBodyAxb, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)bindBodyAxb);
        String url = VoiceSender.getUrl("PRIVACY_AXB_URL_HTTPS", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsPrivacyBindXyb(PrivacyBindBodyXyb bindBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)bindBody);
        String url = VoiceSender.getUrl("PRIVACY_XYB_URL_HTTPS", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsPrivacyUnbind(PrivacyUnbindBody unbindBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)unbindBody);
        String url = VoiceSender.getUrl("PRIVACY_UNBIND_URL_HTTPS", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsSendVoiceVerify(VoiceVerifyBody voiceVerityBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)voiceVerityBody);
        String path = VoiceSender.getUrl("VOICEVERITY_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpSendTwoWayCall(TwoWayCallBody twoWayCallbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)twoWayCallbody);
        String url = VoiceSender.getUrl("TWOWAYCALL_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpSendBothwayCall(TwoWayCallBody twoWayCallbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)twoWayCallbody);
        String url = VoiceSender.getUrl("TWOWAYCALL_DT_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpBothwayGetVcode(BathwayWhiteListBody whiteListbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)whiteListbody);
        String url = VoiceSender.getUrl("TWOWAYCALL_DT_GETVCODE_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpBothwayCheckVcode(BathwayWhiteListBody whiteListbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)whiteListbody);
        String url = VoiceSender.getUrl("TWOWAYCALL_DT_CHECKVCODE_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpSendBothwayHCall(TwoWayCallBody twoWayCallbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)twoWayCallbody);
        String url = VoiceSender.getUrl("TWOWAYCALL_HC_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpBothwayHGetVcode(BathwayWhiteListBody whiteListbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)whiteListbody);
        String url = VoiceSender.getUrl("TWOWAYCALL_HC_GETVCODE_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpBothwayHCheckVcode(BathwayWhiteListBody whiteListbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)whiteListbody);
        String url = VoiceSender.getUrl("TWOWAYCALL_HC_CHECKVCODE_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpSendBindNumber(BindNumberBody bindNumberBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)bindNumberBody);
        String url = VoiceSender.getUrl("BINDNUMBER_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsSendBindNumber(BindNumberBody bindNumberBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)bindNumberBody);
        String path = VoiceSender.getUrl("BINDNUMBER_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsSendTwoWayCall(TwoWayCallBody twoWayCallbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)twoWayCallbody);
        String path = VoiceSender.getUrl("TWOWAYCALL_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsSendBothwayCall(TwoWayCallBody twoWayCallbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)twoWayCallbody);
        String path = VoiceSender.getUrl("TWOWAYCALL_DT_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsBothwayGetVcode(BathwayWhiteListBody whiteListbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)whiteListbody);
        String path = VoiceSender.getUrl("TWOWAYCALL_DT_GETVCODE_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsBothwayCheckVcode(BathwayWhiteListBody whiteListbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)whiteListbody);
        String path = VoiceSender.getUrl("TWOWAYCALL_DT_CHECKVCODE_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsSendBothwayHCall(TwoWayCallBody twoWayCallbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)twoWayCallbody);
        String path = VoiceSender.getUrl("TWOWAYCALL_HC_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsBothwayHGetVcode(BathwayWhiteListBody whiteListbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)whiteListbody);
        String path = VoiceSender.getUrl("TWOWAYCALL_HC_GETVCODE_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static VoiceResponseResult httpsBothwayHCheckVcode(BathwayWhiteListBody whiteListbody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)whiteListbody);
        String path = VoiceSender.getUrl("TWOWAYCALL_HC_CHECKVCODE_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        VoiceResponseResult notifyResp = new VoiceResponseResult();
        if (result != null) {
            notifyResp = (VoiceResponseResult)JSON.parseObject((String)result, VoiceResponseResult.class);
        }
        return notifyResp;
    }

    public static RelationResponse httpPrivacyQueryRelation(PrivacyQueryRelationBody queryBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)queryBody);
        String url = VoiceSender.getUrl("PRIVACY_QUERY_RELATION_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        RelationResponse relationResponse = new RelationResponse();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            relationResponse = (RelationResponse)JSON.parseObject((String)result, RelationResponse.class);
        }
        return relationResponse;
    }

    public static RelationResponse httpsPrivacyQueryRelation(PrivacyQueryRelationBody queryBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)queryBody);
        String path = VoiceSender.getUrl("PRIVACY_QUERY_RELATION_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        RelationResponse relationResponse = new RelationResponse();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            relationResponse = (RelationResponse)JSON.parseObject((String)result, RelationResponse.class);
        }
        return relationResponse;
    }

    public static RelationsResponse httpPrivacyQueryRelationPublic(PrivacyQueryRelationBody queryBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)queryBody);
        String url = VoiceSender.getUrl("PRIVACY_QUERY_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        RelationsResponse relationResponse = new RelationsResponse();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            relationResponse = (RelationsResponse)JSON.parseObject((String)result, RelationsResponse.class);
        }
        return relationResponse;
    }

    public static RelationsResponse httpsPrivacyQueryRelationPublic(PrivacyQueryRelationBody queryBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)queryBody);
        String path = VoiceSender.getUrl("PRIVACY_QUERY_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        RelationsResponse relationsResponse = new RelationsResponse();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            relationsResponse = (RelationsResponse)JSON.parseObject((String)result, RelationsResponse.class);
        }
        return relationsResponse;
    }

    public static VoiceResponseResult httpPrivacyUnbindRelation(PrivacyUnbindRelationBody queryBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String body = JSON.toJSONString((Object)queryBody);
        String url = VoiceSender.getUrl("PRIVACY_UNBIND_SUBID_URL_HTTP", accountId, token, time);
        String result = OkHttpService.doPost(url, header.getHeader(), body);
        RelationResponse relationResponse = new RelationResponse();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            relationResponse = (RelationResponse)JSON.parseObject((String)result, RelationResponse.class);
        }
        return relationResponse;
    }

    public static VoiceResponseResult httpsPrivacyUnbindRelation(PrivacyUnbindRelationBody queryBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)queryBody);
        String path = VoiceSender.getUrl("PRIVACY_UNBIND_SUBID_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        String result = OkHttpService.doPost(path, headerStr, requestBody);
        RelationResponse relationResponse = new RelationResponse();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            relationResponse = (RelationResponse)JSON.parseObject((String)result, RelationResponse.class);
        }
        return relationResponse;
    }

    public static CommonResponse<TwoWayPrivacyCallResult> httpSendTwoWayPrivacyCall(TwoWayPrivacyCallBody callBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        CommonResponse result = new CommonResponse();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)callBody);
        String path = VoiceSender.getUrl("TWOWAYCALL_PRIVACY_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        try {
            String response = OkHttpService.doPost(path, headerStr, requestBody);
            result = (CommonResponse)JSON.parseObject((String)response, (TypeReference)new TypeReference<CommonResponse<TwoWayPrivacyCallResult>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            result.setCode("-2");
            result.setMessage("Service Unavailable");
            e.printStackTrace();
        }
        return result;
    }

    public static CommonResponse<TwoWayPrivacyCallResult> httpsSendTwoWayPrivacyCall(TwoWayPrivacyCallBody callBody, String accountId, String token) throws Exception {
        long time = System.currentTimeMillis();
        CommonResponse result = new CommonResponse();
        Header header = new Header(accountId, time);
        String requestBody = JSON.toJSONString((Object)callBody);
        String path = VoiceSender.getUrl("TWOWAYCALL_PRIVACY_URL_HTTPS", accountId, token, time);
        String headerStr = header.getHeader();
        try {
            String response = OkHttpService.doPost(path, headerStr, requestBody);
            result = (CommonResponse)JSON.parseObject((String)response, (TypeReference)new TypeReference<CommonResponse<TwoWayPrivacyCallResult>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            result.setCode("-2");
            result.setMessage("Service Unavailable");
            e.printStackTrace();
        }
        return result;
    }

    public static String getUrl(String urlName, String accountId, String token, long time) throws Exception {
        Properties prop = SdkConfigUtil.getPropertyInfo();
        if (prop == null) {
            throw new Exception("prop is null");
        }
        String url = (String)prop.get(urlName);
        String sig = VoiceSender.getSig(accountId, token, time);
        url = url + "/" + accountId + "/" + sig;
        return url;
    }

    private static String getSig(String accountId, String token, Long time) {
        return MD5Util.getMD5(accountId + token + time);
    }
}

