/*
 * Decompiled with CFR 0.152.
 */
package com.winnerlook.service.okhttp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpService {
    private OkHttpClient okHttpClient = OkHttpService.createFakeHttpsClient(10000, 10000);

    public static OkHttpService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static OkHttpClient createFakeHttpsClient(int readTimeOut, int connectTimeOut) {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            builder.readTimeout((long)readTimeOut, TimeUnit.MILLISECONDS);
            builder.connectTimeout((long)connectTimeOut, TimeUnit.MILLISECONDS);
            return builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String doPost(String url, String header, String body) throws Exception {
        OkHttpClient client = SingletonHolder.INSTANCE.okHttpClient;
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        requestBuilder.addHeader("Content-Type", "application/json; charset=utf-8");
        requestBuilder.addHeader("Authorization", header);
        RequestBody requestBody = RequestBody.create(null, (String)body);
        requestBuilder.post(requestBody);
        Request request = requestBuilder.build();
        Response response = client.newCall(request).execute();
        if (response == null || response.body() == null) {
            return null;
        }
        return response.body().string();
    }

    public static String doUpload(String url, String header, File file, String content) throws Exception {
        OkHttpClient client = SingletonHolder.INSTANCE.okHttpClient;
        String result = "";
        MediaType mediaType = MediaType.parse((String)"application/octet-stream");
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("content", content).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)mediaType, (File)file)).build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).header("Authorization", header).build();
        Response response = client.newCall(request).execute();
        result = response.body().string();
        return result;
    }

    public static String doDelete(String url, String header) throws Exception {
        OkHttpClient client = SingletonHolder.INSTANCE.okHttpClient;
        String resultString = "";
        Request request = new Request.Builder().url(url).delete().header("Authorization", header).build();
        Response response = client.newCall(request).execute();
        resultString = response.body().string();
        return resultString;
    }

    public static String doPostInputStream(String url, String header, String body, InputStream inputStream, String fileName, String extraNumbers) throws Exception {
        OkHttpClient client = SingletonHolder.INSTANCE.okHttpClient;
        String resultString = "";
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("params", body).addFormDataPart("extraNumbers", extraNumbers).addFormDataPart(fileName, fileName, RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])OkHttpService.readInputStream(inputStream))).build();
        Request request = new Request.Builder().url(url).header("Authorization", header).post((RequestBody)requestBody).build();
        Response response = client.newCall(request).execute();
        resultString = response.body().string();
        return resultString;
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        return outputStream.toByteArray();
    }

    public static String doPostFile(String url, String header, String body, File file, String fileName) throws Exception {
        OkHttpClient client = SingletonHolder.INSTANCE.okHttpClient;
        String result = "";
        MediaType mediaType = MediaType.parse((String)"application/octet-stream");
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("params", body).addFormDataPart(fileName, file.getName(), RequestBody.create((MediaType)mediaType, (File)file)).build();
        Request request = new Request.Builder().url(url).header("Authorization", header).post((RequestBody)requestBody).build();
        Response response = client.newCall(request).execute();
        result = response.body().string();
        return result;
    }

    private static class SingletonHolder {
        private static final OkHttpService INSTANCE = new OkHttpService();

        private SingletonHolder() {
        }
    }
}

