/*
 * Decompiled with CFR 0.152.
 */
package com.wire.cryptobox;

import com.wire.cryptobox.CryptoException;
import com.wire.cryptobox.CryptoSession;
import com.wire.cryptobox.PreKey;
import com.wire.cryptobox.SessionMessage;
import java.util.HashMap;

public final class CryptoBox {
    public static final int MAX_PREKEY_ID = 65534;
    private static final Object OPEN_LOCK;
    private long ptr;
    private final Object lock = new Object();
    private final HashMap<String, CryptoSession> sessions = new HashMap();

    private CryptoBox(long l) {
        this.ptr = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoBox open(String string) throws CryptoException {
        Object object = OPEN_LOCK;
        synchronized (object) {
            return CryptoBox.jniOpen(string);
        }
    }

    public static CryptoBox openWith(String string, byte[] byArray, IdentityMode identityMode) throws CryptoException {
        Object object = OPEN_LOCK;
        synchronized (object) {
            switch (identityMode) {
                case COMPLETE: {
                    return CryptoBox.jniOpenWith(string, byArray, 0);
                }
                case PUBLIC: {
                    return CryptoBox.jniOpenWith(string, byArray, 1);
                }
            }
            throw new IllegalStateException("Unexpected IdentityMode");
        }
    }

    public static byte[] getFingerprintFromPrekey(PreKey preKey) throws CryptoException {
        return CryptoBox.jniGetFingerprintFromPrekey(preKey.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] copyIdentity() throws CryptoException {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            return CryptoBox.jniCopyIdentity(this.ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getLocalFingerprint() throws CryptoException {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            return CryptoBox.jniGetLocalFingerprint(this.ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreKey newLastPreKey() throws CryptoException {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            return CryptoBox.jniNewLastPreKey(this.ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreKey[] newPreKeys(int n, int n2) throws CryptoException {
        if (n < 0 || n > 65534) {
            throw new IllegalArgumentException("start must be >= 0 and <= 65534");
        }
        if (n2 < 1 || n2 > 65534) {
            throw new IllegalArgumentException("num must be >= 1 and <= 65534");
        }
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            return CryptoBox.jniNewPreKeys(this.ptr, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoSession initSessionFromPreKey(String string, PreKey preKey) throws CryptoException {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            CryptoSession cryptoSession = this.sessions.get(string);
            if (cryptoSession != null) {
                return cryptoSession;
            }
            cryptoSession = CryptoBox.jniInitSessionFromPreKey(this.ptr, string, preKey.data);
            this.sessions.put(cryptoSession.id, cryptoSession);
            return cryptoSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionMessage initSessionFromMessage(String string, byte[] byArray) throws CryptoException {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            CryptoSession cryptoSession = this.sessions.get(string);
            if (cryptoSession != null) {
                return new SessionMessage(cryptoSession, cryptoSession.decrypt(byArray));
            }
            SessionMessage sessionMessage = CryptoBox.jniInitSessionFromMessage(this.ptr, string, byArray);
            this.sessions.put(sessionMessage.getSession().id, sessionMessage.getSession());
            return sessionMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoSession getSession(String string) throws CryptoException {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            CryptoSession cryptoSession = this.sessions.get(string);
            if (cryptoSession == null) {
                cryptoSession = CryptoBox.jniLoadSession(this.ptr, string);
                this.sessions.put(string, cryptoSession);
            }
            return cryptoSession;
        }
    }

    public CryptoSession tryGetSession(String string) throws CryptoException {
        try {
            return this.getSession(string);
        }
        catch (CryptoException cryptoException) {
            if (cryptoException.code == CryptoException.Code.SESSION_NOT_FOUND) {
                return null;
            }
            throw cryptoException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(CryptoSession cryptoSession) {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            this.sessions.remove(cryptoSession.id);
            cryptoSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllSessions() {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            for (CryptoSession cryptoSession : this.sessions.values()) {
                cryptoSession.close();
            }
            this.sessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSession(String string) throws CryptoException {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            CryptoSession cryptoSession = this.sessions.get(string);
            if (cryptoSession != null) {
                this.sessions.remove(string);
                cryptoSession.close();
            }
            CryptoBox.jniDeleteSession(this.ptr, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.closeAllSessions();
            CryptoBox.jniClose(this.ptr);
            this.ptr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.ptr == 0L;
        }
    }

    private void errorIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Invalid operation on a closed CryptoBox.");
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private static native CryptoBox jniOpen(String var0) throws CryptoException;

    private static native CryptoBox jniOpenWith(String var0, byte[] var1, int var2) throws CryptoException;

    private static native byte[] jniGetFingerprintFromPrekey(byte[] var0) throws CryptoException;

    private static native PreKey jniNewLastPreKey(long var0) throws CryptoException;

    private static native PreKey[] jniNewPreKeys(long var0, int var2, int var3) throws CryptoException;

    private static native byte[] jniGetLocalFingerprint(long var0) throws CryptoException;

    private static native CryptoSession jniInitSessionFromPreKey(long var0, String var2, byte[] var3) throws CryptoException;

    private static native SessionMessage jniInitSessionFromMessage(long var0, String var2, byte[] var3) throws CryptoException;

    private static native CryptoSession jniLoadSession(long var0, String var2) throws CryptoException;

    private static native void jniDeleteSession(long var0, String var2) throws CryptoException;

    private static native byte[] jniCopyIdentity(long var0) throws CryptoException;

    private static native void jniClose(long var0);

    static {
        String string = System.getProperty("os.name").toLowerCase().contains("win") ? "lib" : "";
        System.loadLibrary(string + "sodium");
        System.loadLibrary("cryptobox");
        System.loadLibrary("cryptobox-jni");
        OPEN_LOCK = new Object();
    }

    public static enum IdentityMode {
        COMPLETE,
        PUBLIC;

    }
}

