/*
 * Decompiled with CFR 0.152.
 */
package com.wire.cryptobox;

public final class CryptoException
extends Exception {
    public final Code code;

    private CryptoException(int n) {
        this(CryptoException.fromNativeCode(n));
    }

    public CryptoException(Code code) {
        super(code.toString());
        this.code = code;
    }

    private static Code fromNativeCode(int n) {
        switch (n) {
            case 1: {
                return Code.STORAGE_ERROR;
            }
            case 2: {
                return Code.SESSION_NOT_FOUND;
            }
            case 3: {
                return Code.DECODE_ERROR;
            }
            case 4: {
                return Code.REMOTE_IDENTITY_CHANGED;
            }
            case 5: {
                return Code.INVALID_SIGNATURE;
            }
            case 6: {
                return Code.INVALID_MESSAGE;
            }
            case 7: {
                return Code.DUPLICATE_MESSAGE;
            }
            case 8: {
                return Code.TOO_DISTANT_FUTURE;
            }
            case 9: {
                return Code.OUTDATED_MESSAGE;
            }
            case 10: {
                return Code.INVALID_STRING;
            }
            case 11: {
                return Code.INVALID_STRING;
            }
            case 13: {
                return Code.IDENTITY_ERROR;
            }
            case 14: {
                return Code.PREKEY_NOT_FOUND;
            }
            case 15: {
                return Code.PANIC;
            }
            case 16: {
                return Code.INIT_ERROR;
            }
            case 17: {
                return Code.DEGENERATED_KEY;
            }
        }
        return Code.UNKNOWN_ERROR;
    }

    public static enum Code {
        SESSION_NOT_FOUND,
        REMOTE_IDENTITY_CHANGED,
        INVALID_SIGNATURE,
        INVALID_MESSAGE,
        DUPLICATE_MESSAGE,
        TOO_DISTANT_FUTURE,
        OUTDATED_MESSAGE,
        DECODE_ERROR,
        STORAGE_ERROR,
        IDENTITY_ERROR,
        PREKEY_NOT_FOUND,
        PANIC,
        INIT_ERROR,
        DEGENERATED_KEY,
        INVALID_STRING,
        UNKNOWN_ERROR;

    }
}

