/*
 * Decompiled with CFR 0.152.
 */
package com.wire.cryptobox;

import com.wire.cryptobox.CryptoException;

public final class CryptoSession {
    private final long boxPtr;
    private long ptr;
    private final Object lock = new Object();
    public final String id;

    private CryptoSession(long l, long l2, String string) {
        this.boxPtr = l;
        this.ptr = l2;
        this.id = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws CryptoException {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            try {
                CryptoSession.jniSave(this.boxPtr, this.ptr);
            }
            catch (CryptoException cryptoException) {
                if (cryptoException.code == CryptoException.Code.PANIC) {
                    this.close();
                }
                throw cryptoException;
            }
        }
    }

    public byte[] encrypt(byte[] byArray) throws CryptoException {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            try {
                return CryptoSession.jniEncrypt(this.ptr, byArray);
            }
            catch (CryptoException cryptoException) {
                if (cryptoException.code == CryptoException.Code.PANIC) {
                    this.close();
                }
                throw cryptoException;
            }
        }
    }

    public byte[] decrypt(byte[] byArray) throws CryptoException {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            try {
                return CryptoSession.jniDecrypt(this.ptr, byArray);
            }
            catch (CryptoException cryptoException) {
                if (cryptoException.code == CryptoException.Code.PANIC) {
                    this.close();
                }
                throw cryptoException;
            }
        }
    }

    public byte[] getRemoteFingerprint() throws CryptoException {
        Object object = this.lock;
        synchronized (object) {
            this.errorIfClosed();
            try {
                return CryptoSession.jniGetRemoteFingerprint(this.ptr);
            }
            catch (CryptoException cryptoException) {
                if (cryptoException.code == CryptoException.Code.PANIC) {
                    this.close();
                }
                throw cryptoException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            CryptoSession.jniClose(this.ptr);
            this.ptr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.ptr == 0L;
        }
    }

    private void errorIfClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Invalid operation on a closed CryptoSession.");
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private static native void jniSave(long var0, long var2) throws CryptoException;

    private static native byte[] jniEncrypt(long var0, byte[] var2) throws CryptoException;

    private static native byte[] jniDecrypt(long var0, byte[] var2) throws CryptoException;

    private static native byte[] jniGetRemoteFingerprint(long var0) throws CryptoException;

    private static native void jniClose(long var0);
}

