/*
 * Decompiled with CFR 0.152.
 */
package com.wix.detox.espresso.action;

import android.view.MotionEvent;
import androidx.test.espresso.UiController;
import androidx.test.espresso.action.Tapper;
import com.wix.detox.common.DetoxLog;
import com.wix.detox.common.collect.PairsIterator;
import com.wix.detox.common.proxy.CallInfo;
import com.wix.detox.espresso.UiControllerSpy;
import com.wix.detox.espresso.action.common.DetoxViewConfigurations;
import com.wix.detox.espresso.action.common.TapEvents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BK\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J&\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J6\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/wix/detox/espresso/action/DetoxMultiTap;", "Landroidx/test/espresso/action/Tapper;", "times", "", "interTapsDelayMs", "", "coolDownTimeMs", "longTapMinTimeMs", "tapEvents", "Lcom/wix/detox/espresso/action/common/TapEvents;", "uiControllerCallSpy", "Lcom/wix/detox/espresso/UiControllerSpy;", "log", "Lcom/wix/detox/common/DetoxLog;", "(IJJJLcom/wix/detox/espresso/action/common/TapEvents;Lcom/wix/detox/espresso/UiControllerSpy;Lcom/wix/detox/common/DetoxLog;)V", "generateEventSequences", "", "Landroid/view/MotionEvent;", "coordinates", "", "precision", "injectEvents", "", "uiController", "Landroidx/test/espresso/UiController;", "eventSequence", "sendTap", "Landroidx/test/espresso/action/Tapper$Status;", "inputDevice", "buttonState", "verifyInjectionPeriods", "", "verifyTapEventTimes", "upEvent", "Lcom/wix/detox/common/proxy/CallInfo;", "downEvent", "detox_coreNativeRelease"})
public class DetoxMultiTap
implements Tapper {
    private final int times;
    private final long interTapsDelayMs;
    private final long coolDownTimeMs;
    private final long longTapMinTimeMs;
    private final TapEvents tapEvents;
    private final UiControllerSpy uiControllerCallSpy;
    private final DetoxLog log;

    @NotNull
    public Tapper.Status sendTap(@Nullable UiController uiController, @Nullable float[] coordinates, @Nullable float[] precision) {
        return this.sendTap(uiController, coordinates, precision, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Tapper.Status sendTap(@Nullable UiController uiController, @Nullable float[] coordinates, @Nullable float[] precision, int inputDevice, int buttonState) {
        if (uiController == null) {
            Intrinsics.throwNpe();
        }
        if (coordinates == null) {
            Intrinsics.throwNpe();
        }
        if (precision == null) {
            Intrinsics.throwNpe();
        }
        List<MotionEvent> eventSequence = null;
        try {
            eventSequence = this.generateEventSequences(coordinates, precision);
            if (!this.injectEvents(uiController, eventSequence)) {
                Tapper.Status status = Tapper.Status.FAILURE;
                return status;
            }
            this.verifyInjectionPeriods();
            uiController.loopMainThreadForAtLeast(this.coolDownTimeMs);
            Tapper.Status status = Tapper.Status.SUCCESS;
            return status;
        }
        finally {
            List<MotionEvent> list = eventSequence;
            if (list != null) {
                Iterable $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    MotionEvent it = (MotionEvent)element$iv;
                    boolean bl = false;
                    it.recycle();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<MotionEvent> generateEventSequences(float[] coordinates, float[] precision) {
        List eventSequence = new ArrayList();
        Long downTimestamp = null;
        int n = 1;
        int n2 = this.times;
        if (n <= n2) {
            while (true) {
                void i;
                List<MotionEvent> tapEvents = this.tapEvents.createEventsSeq(coordinates, precision, downTimestamp);
                eventSequence.addAll((Collection)tapEvents);
                downTimestamp = ((MotionEvent)CollectionsKt.last(tapEvents)).getEventTime() + this.interTapsDelayMs;
                if (i == n2) break;
                ++i;
            }
        }
        return eventSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean injectEvents(UiController uiController, List<MotionEvent> eventSequence) {
        try {
            this.uiControllerCallSpy.start();
            if (!uiController.injectMotionEventSequence((Iterable)eventSequence)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.uiControllerCallSpy.stop();
        }
        return true;
    }

    private final void verifyInjectionPeriods() {
        Iterator $receiver$iv;
        Iterator iterator;
        Iterator<CallInfo> rawIterator = this.uiControllerCallSpy.eventInjectionsIterator();
        Iterator iterator2 = iterator = ($receiver$iv = (Iterator)new PairsIterator<CallInfo>(rawIterator));
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Object object = it.getFirst();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            CallInfo callInfo = (CallInfo)object;
            Object object2 = it.getSecond();
            if (object2 == null) {
                Intrinsics.throwNpe();
            }
            this.verifyTapEventTimes(callInfo, (CallInfo)object2);
        }
    }

    private final void verifyTapEventTimes(CallInfo upEvent, CallInfo downEvent) {
        long delta;
        Long l = upEvent.minus(downEvent);
        if (l == null) {
            Intrinsics.throwNpe();
        }
        if ((delta = l.longValue()) >= this.longTapMinTimeMs) {
            this.log.warn("Detox", "Tap handled too slowly, and turned into a long-tap!");
        }
    }

    @JvmOverloads
    public DetoxMultiTap(int times, long interTapsDelayMs, long coolDownTimeMs, long longTapMinTimeMs, @NotNull TapEvents tapEvents, @NotNull UiControllerSpy uiControllerCallSpy, @NotNull DetoxLog log) {
        Intrinsics.checkParameterIsNotNull((Object)tapEvents, (String)"tapEvents");
        Intrinsics.checkParameterIsNotNull((Object)uiControllerCallSpy, (String)"uiControllerCallSpy");
        Intrinsics.checkParameterIsNotNull((Object)log, (String)"log");
        this.times = times;
        this.interTapsDelayMs = interTapsDelayMs;
        this.coolDownTimeMs = coolDownTimeMs;
        this.longTapMinTimeMs = longTapMinTimeMs;
        this.tapEvents = tapEvents;
        this.uiControllerCallSpy = uiControllerCallSpy;
        this.log = log;
    }

    @JvmOverloads
    public /* synthetic */ DetoxMultiTap(int n, long l, long l2, long l3, TapEvents tapEvents, UiControllerSpy uiControllerSpy, DetoxLog detoxLog, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            l = DetoxViewConfigurations.INSTANCE.getDoubleTapMinTime();
        }
        if ((n2 & 4) != 0) {
            l2 = DetoxViewConfigurations.INSTANCE.getPostTapCoolDownTime();
        }
        if ((n2 & 8) != 0) {
            l3 = DetoxViewConfigurations.INSTANCE.getLongTapMinTime();
        }
        if ((n2 & 0x10) != 0) {
            tapEvents = new TapEvents(null, 1, null);
        }
        if ((n2 & 0x20) != 0) {
            uiControllerSpy = UiControllerSpy.Companion.getInstance();
        }
        if ((n2 & 0x40) != 0) {
            detoxLog = DetoxLog.Companion.getInstance$detox_coreNativeRelease();
        }
        this(n, l, l2, l3, tapEvents, uiControllerSpy, detoxLog);
    }

    @JvmOverloads
    public DetoxMultiTap(int times, long interTapsDelayMs, long coolDownTimeMs, long longTapMinTimeMs, @NotNull TapEvents tapEvents, @NotNull UiControllerSpy uiControllerCallSpy) {
        this(times, interTapsDelayMs, coolDownTimeMs, longTapMinTimeMs, tapEvents, uiControllerCallSpy, null, 64, null);
    }

    @JvmOverloads
    public DetoxMultiTap(int times, long interTapsDelayMs, long coolDownTimeMs, long longTapMinTimeMs, @NotNull TapEvents tapEvents) {
        this(times, interTapsDelayMs, coolDownTimeMs, longTapMinTimeMs, tapEvents, null, null, 96, null);
    }

    @JvmOverloads
    public DetoxMultiTap(int times, long interTapsDelayMs, long coolDownTimeMs, long longTapMinTimeMs) {
        this(times, interTapsDelayMs, coolDownTimeMs, longTapMinTimeMs, null, null, null, 112, null);
    }

    @JvmOverloads
    public DetoxMultiTap(int times, long interTapsDelayMs, long coolDownTimeMs) {
        this(times, interTapsDelayMs, coolDownTimeMs, 0L, null, null, null, 120, null);
    }

    @JvmOverloads
    public DetoxMultiTap(int times, long interTapsDelayMs) {
        this(times, interTapsDelayMs, 0L, 0L, null, null, null, 124, null);
    }

    @JvmOverloads
    public DetoxMultiTap(int times) {
        this(times, 0L, 0L, 0L, null, null, null, 126, null);
    }
}

