/*
 * Decompiled with CFR 0.152.
 */
package com.genymotion.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.RemoteException;
import com.genymotion.api.GenymotionException;
import com.genymotion.api.GenymotionManager;
import com.genymotion.genyd.IGenydService;

public class Battery {
    private final Object mLock = new Object();
    private final IGenydService genyd;

    private int getStatusToBatteryManagerValue(Status status) {
        switch (status) {
            case CHARGING: {
                return 2;
            }
            case DISCHARGING: {
                return 3;
            }
            case NOTCHARGING: {
                return 4;
            }
            case FULL: {
                return 5;
            }
        }
        return 4;
    }

    private Status getStatusFromBatteryManagerValue(int status) {
        switch (status) {
            case 2: {
                return Status.CHARGING;
            }
            case 3: {
                return Status.DISCHARGING;
            }
            case 4: {
                return Status.NOTCHARGING;
            }
            case 5: {
                return Status.FULL;
            }
        }
        return Status.NOTCHARGING;
    }

    Battery(IGenydService genyd) {
        this.genyd = genyd;
    }

    public Battery setLevel(int level) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Battery.setLevel(int)");
        try {
            this.genyd.setBatteryLevel(level);
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        Intent targetBatteryStatus = new Intent();
        targetBatteryStatus.putExtra("level", level);
        targetBatteryStatus.putExtra("scale", 100);
        this.waitForTargetPowerState(targetBatteryStatus);
        return this;
    }

    public Mode getMode() {
        Mode mode;
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Battery.getMode()");
        try {
            mode = Mode.values()[this.genyd.getBatteryMode()];
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        return mode;
    }

    public Battery setMode(Mode mode) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Battery.setMode(com.genymotion.api.Battery$Mode)");
        try {
            this.genyd.setBatteryMode(mode.getValue());
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        return this;
    }

    public Battery setStatus(Status status) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Battery.setStatus(com.genymotion.api.Battery$Status)");
        try {
            this.genyd.setBatteryStatus(status.getValue());
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        Intent targetBatteryStatus = new Intent();
        targetBatteryStatus.putExtra("status", this.getStatusToBatteryManagerValue(status));
        this.waitForTargetPowerState(targetBatteryStatus);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTargetPowerState(final Intent target) {
        BroadcastReceiver listener = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                int targetScale;
                int targetLevel;
                double targetBatteryPct;
                int scale;
                int level;
                double batteryPct;
                int status = intent.getIntExtra("status", -1);
                int targetStatus = target.getIntExtra("status", -1);
                if (target.hasExtra("status") && status != targetStatus) {
                    return;
                }
                if (target.hasExtra("level") && target.hasExtra("scale") && Math.abs((batteryPct = (double)(level = intent.getIntExtra("level", -1)) / (double)(scale = intent.getIntExtra("scale", -1))) - (targetBatteryPct = (double)(targetLevel = target.getIntExtra("level", -1)) / (double)(targetScale = target.getIntExtra("scale", -1)))) >= 0.001) {
                    return;
                }
                Object object = Battery.this.mLock;
                synchronized (object) {
                    Battery.this.mLock.notify();
                }
            }
        };
        HandlerThread handlerThread = new HandlerThread("waitForTargetLocation");
        handlerThread.start();
        Looper looper = handlerThread.getLooper();
        Handler handler = new Handler(looper);
        Context ctx = GenymotionManager.genymotionManager.context;
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        ctx.registerReceiver(listener, filter, null, handler);
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.wait(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ctx.unregisterReceiver(listener);
        if (Build.VERSION.SDK_INT >= 18) {
            handlerThread.quitSafely();
        } else {
            handlerThread.quit();
        }
    }

    public static enum Status {
        CHARGING(0),
        DISCHARGING(1),
        NOTCHARGING(2),
        FULL(3);

        private final int value;

        private Status(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Mode {
        HOST(0),
        MANUAL(1);

        private final int value;

        private Mode(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }
}

