/*
 * Decompiled with CFR 0.152.
 */
package com.genymotion.api;

import android.os.RemoteException;
import com.genymotion.api.GenymotionException;
import com.genymotion.api.GenymotionManager;
import com.genymotion.genyd.IGenydService;

public class DiskIO {
    private final IGenydService genyd;

    DiskIO(IGenydService genyd) {
        this.genyd = genyd;
    }

    public int getReadRateLimit() {
        GenymotionManager.checkApi("2.11", "com.genymotion.api.DiskIO.getReadRateLimit()");
        try {
            int byterate = this.genyd.getDiskIOMaxReadByteRate();
            return byterate / 1024;
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
    }

    public DiskIO setReadRateLimit(int byterate) {
        GenymotionManager.checkApi("2.11", "com.genymotion.api.DiskIO.setReadRateLimit(int)");
        if (byterate < 0) {
            throw new GenymotionException("Invalid value. Positive value expected");
        }
        try {
            this.genyd.diskIOClearCache();
            this.genyd.setDiskIOMaxReadByteRate(byterate * 1024);
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        return this;
    }

    public DiskIO clearCache() {
        GenymotionManager.checkApi("2.11", "com.genymotion.api.DiskIO.clearCache()");
        try {
            this.genyd.diskIOClearCache();
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        return this;
    }
}

