/*
 * Decompiled with CFR 0.152.
 */
package com.genymotion.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import com.genymotion.api.GenymotionManager;
import com.genymotion.genyd.IGenydService;
import java.lang.reflect.Method;

public final class GenydBinder {
    static final String TAG = "GenydBinder";
    static final int BIND_TIMEOUT = 2000;
    static IGenydService genyd = null;
    static Object lock = new Object();
    private static ServiceConnection genydConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            genyd = IGenydService.Stub.asInterface(service);
            Log.i((String)GenydBinder.TAG, (String)"Bound to Genyd Service.");
            Object object = lock;
            synchronized (object) {
                lock.notifyAll();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            genyd = null;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IGenydService bind(Context context) {
        if (genyd != null) {
            return genyd;
        }
        String version = GenydBinder.getGenymotionVersion();
        if (GenymotionManager.compareVersion(version, "2.15") < 0) {
            genyd = (IGenydService)context.getSystemService("Genyd");
            return genyd;
        }
        Intent intent = new Intent();
        intent.setClassName("com.genymotion.genyd", "com.genymotion.genyd.GenydService");
        context.bindService(intent, genydConnection, 1);
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait(2000L);
            }
        }
        catch (InterruptedException e) {
            Log.e((String)TAG, (String)"Interrupted while waiting for Genyd service binding");
        }
        return genyd;
    }

    private GenydBinder() {
    }

    static String getGenymotionVersion() {
        String version = "";
        try {
            Method getProperty;
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            if (systemProperties != null && (getProperty = systemProperties.getDeclaredMethod("get", String.class)) != null) {
                version = (String)getProperty.invoke(null, "ro.genymotion.version");
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        return version;
    }
}

