/*
 * Decompiled with CFR 0.152.
 */
package com.genymotion.api;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import com.genymotion.api.Battery;
import com.genymotion.api.DiskIO;
import com.genymotion.api.GenydBinder;
import com.genymotion.api.GenymotionException;
import com.genymotion.api.Gps;
import com.genymotion.api.Id;
import com.genymotion.api.MethodUnavailableException;
import com.genymotion.api.Network;
import com.genymotion.api.NotGenymotionDeviceException;
import com.genymotion.api.Orientation;
import com.genymotion.api.Radio;
import com.genymotion.genyd.IGenydService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class GenymotionManager {
    static final String TAG = "GenymotionApi";
    static final int TIMEOUT = 10000;
    static GenymotionManager genymotionManager = null;
    Context context = null;
    private static Battery battery = null;
    private static Gps gps = null;
    private static Id id = null;
    private static Orientation orientation = null;
    private static Radio radio = null;
    private static Network network = null;
    private static DiskIO diskIO = null;
    private String version;
    private IGenydService genyd = null;

    private GenymotionManager(Context pContext) {
        if (!GenymotionManager.isGenymotionDevice()) {
            throw new NotGenymotionDeviceException();
        }
        if (pContext != null) {
            this.context = pContext;
            this.genyd = GenydBinder.bind(this.context);
            if (this.genyd == null) {
                throw new GenymotionException("This version of Genymotion is not compatible with the Genymotion API. Please upgrade your Genymotion Device.");
            }
        } else {
            throw new GenymotionException("You must provide a valid Android Context.");
        }
        GenymotionManager.checkToken(this.genyd);
    }

    public static GenymotionManager getGenymotionManager(Context context) throws GenymotionException {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.GenymotionManager.getGenymotionManager(android.content.Context)");
        if (genymotionManager == null) {
            genymotionManager = context.getApplicationContext() != null ? new GenymotionManager(context.getApplicationContext()) : new GenymotionManager(context);
            GenymotionManager.genymotionManager.version = GenymotionManager.getGenymotionVersion();
        }
        return genymotionManager;
    }

    public Battery getBattery() {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.GenymotionManager.getBattery()");
        if (battery == null) {
            battery = new Battery(this.genyd);
        }
        return battery;
    }

    public Gps getGps() {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.GenymotionManager.getGps()");
        if (gps == null) {
            gps = new Gps(this.genyd);
        }
        return gps;
    }

    public Id getId() {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.GenymotionManager.getId()");
        if (id == null) {
            id = new Id(this.genyd);
        }
        return id;
    }

    public Orientation getOrientation() {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.GenymotionManager.getOrientation()");
        if (orientation == null) {
            orientation = new Orientation(this.genyd);
        }
        return orientation;
    }

    public Radio getRadio() {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.GenymotionManager.getRadio()");
        if (radio == null) {
            radio = new Radio(this.genyd);
        }
        return radio;
    }

    static void checkApi(String apk, String methodSign) {
        if (genymotionManager == null) {
            return;
        }
        if (GenymotionManager.compareVersion(apk, GenymotionManager.genymotionManager.version) > 0) {
            throw new MethodUnavailableException(methodSign + " doesn't exists on this version of Genymotion: " + GenymotionManager.genymotionManager.version + ". You need at least the version: " + apk);
        }
    }

    public Network getNetwork() {
        GenymotionManager.checkApi("2.3", "com.genymotion.api.GenymotionManager.getNetwork()");
        if (network == null) {
            network = new Network(this.genyd);
        }
        return network;
    }

    public DiskIO getDiskIO() {
        GenymotionManager.checkApi("2.11", "com.genymotion.api.GenymotionManager.getDiskIO()");
        if (diskIO == null) {
            diskIO = new DiskIO(this.genyd);
        }
        return diskIO;
    }

    public static boolean isGenymotionDevice() {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.GenymotionManager.isGenymotionDevice()");
        return !GenymotionManager.getGenymotionVersion().isEmpty();
    }

    static int compareVersion(String v1, String v2) {
        String[] vals1 = v1.split("\\.");
        String[] vals2 = v2.split("\\.");
        int m = Math.max(vals1.length, vals2.length);
        for (int i = 0; i < m; ++i) {
            int d2;
            int d1 = i < vals1.length ? Integer.valueOf(vals1[i]) : 0;
            int diff = Integer.signum(d1 - (d2 = i < vals2.length ? Integer.valueOf(vals2[i]) : 0));
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    static void checkToken(IGenydService service) {
        int token;
        try {
            token = service.getTokenValidity();
        }
        catch (RemoteException e) {
            throw new GenymotionException(e.getMessage(), e.getCause());
        }
        String pleaseRestart = " Please run Genymotion and connect to Genymotion Cloud to force a license check.";
        switch (TokenValidity.values()[token]) {
            case Valid: {
                break;
            }
            case TokenExpired: {
                throw new GenymotionException("License activation has expired." + pleaseRestart);
            }
            case LicenseExpired: {
                throw new GenymotionException("Last license check reported that license has expired." + pleaseRestart);
            }
            case EmptyToken: {
                throw new GenymotionException("License has not been verified using Genymotion Cloud." + pleaseRestart);
            }
            case Unknown: {
                throw new GenymotionException("Unable to connect to Genymotion via Genymotion API.");
            }
            case TokenNotSet: {
                throw new GenymotionException("This software requires a valid Genymotion license.");
            }
            default: {
                throw new GenymotionException("License cannot be verified because check data are invalid." + pleaseRestart);
            }
        }
    }

    static String getGenymotionVersion() {
        String version = "";
        try {
            Method getProperty;
            Class<?> systemProperties = Class.forName("android.os.SystemProperties");
            if (systemProperties != null && (getProperty = systemProperties.getDeclaredMethod("get", String.class)) != null) {
                version = (String)getProperty.invoke(null, "ro.genymotion.version");
            }
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        return version;
    }

    static enum TokenValidity {
        Unknown,
        Valid,
        NoSignature,
        InvalidSignature,
        InvalidData,
        InvalidUuid,
        TokenExpired,
        LicenseExpired,
        EmptyToken,
        TokenNotSet;

    }
}

