/*
 * Decompiled with CFR 0.152.
 */
package com.genymotion.api;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.os.HandlerThread;
import android.os.RemoteException;
import com.genymotion.api.GenymotionException;
import com.genymotion.api.GenymotionManager;
import com.genymotion.api.LocationParams;
import com.genymotion.genyd.IGenydService;

public class Gps {
    private final Object locationLock = new Object();
    private final IGenydService genyd;

    Gps(IGenydService genyd) {
        this.genyd = genyd;
    }

    public Gps setAccuracy(float accuracy) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Gps.setAccuracy(float)");
        return this.setLocation(new LocationParams.Builder().setAccuracy(accuracy).build());
    }

    public Gps setAltitude(double altitude) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Gps.setAltitude(double)");
        return this.setLocation(new LocationParams.Builder().setAltitude(altitude).build());
    }

    public Gps setBearing(float bearing) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Gps.setBearing(float)");
        return this.setLocation(new LocationParams.Builder().setBearing(bearing).build());
    }

    public Gps setLatitude(double latitude) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Gps.setLatitude(double)");
        return this.setLocation(new LocationParams.Builder().setLatitude(latitude).build());
    }

    public Gps setLongitude(double longitude) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Gps.setLongitude(double)");
        return this.setLocation(new LocationParams.Builder().setLongitude(longitude).build());
    }

    public Gps setLocation(LocationParams locationParams) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Gps.setLocation(com.genymotion.api.LocationParams)");
        try {
            if (locationParams.hasAccuracy()) {
                this.genyd.setGpsAccuracy(locationParams.accuracy.floatValue());
            }
            if (locationParams.hasAltitude()) {
                this.genyd.setGpsAltitude(locationParams.altitude);
            }
            if (locationParams.hasBearing()) {
                this.genyd.setGpsBearing(locationParams.bearing.floatValue());
            }
            if (locationParams.hasLatitude()) {
                this.genyd.setGpsLatitude(locationParams.latitude);
            }
            if (locationParams.hasLongitude()) {
                this.genyd.setGpsLongitude(locationParams.longitude);
            }
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        this.waitForTargetLocation(locationParams);
        return this;
    }

    public Status getStatus() {
        Status res;
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Gps.getStatus()");
        try {
            res = this.genyd.getGpsStatus() ? Status.ENABLED : Status.DISABLED;
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        return res;
    }

    public Gps setStatus(Status status) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Gps.setStatus(com.genymotion.api.Gps$Status)");
        try {
            this.genyd.setGpsStatus(status == Status.ENABLED);
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        return this;
    }

    private static boolean nearlyEqual(double a, double b) {
        return Math.abs(a - b) < 0.001;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTargetLocation(final LocationParams locationParams) {
        Context ctx = GenymotionManager.genymotionManager.context;
        LocationManager locMan = (LocationManager)ctx.getSystemService("location");
        LocationListener locListener = new LocationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onLocationChanged(Location lastLocation) {
                if (locationParams.hasLatitude() && !Gps.nearlyEqual(locationParams.latitude, lastLocation.getLatitude())) {
                    return;
                }
                if (locationParams.hasLongitude() && !Gps.nearlyEqual(locationParams.longitude, lastLocation.getLongitude())) {
                    return;
                }
                if (!(!locationParams.hasAccuracy() || lastLocation.hasAccuracy() && Gps.nearlyEqual(locationParams.accuracy.floatValue(), lastLocation.getAccuracy()))) {
                    return;
                }
                if (!(!locationParams.hasBearing() || lastLocation.hasBearing() && Gps.nearlyEqual(locationParams.bearing.floatValue(), lastLocation.getBearing()))) {
                    return;
                }
                if (!(!locationParams.hasAltitude() || lastLocation.hasAltitude() && Gps.nearlyEqual(locationParams.altitude, lastLocation.getAltitude()))) {
                    return;
                }
                Object object = Gps.this.locationLock;
                synchronized (object) {
                    Gps.this.locationLock.notify();
                }
            }

            public void onStatusChanged(String s, int i, Bundle bundle) {
            }

            public void onProviderEnabled(String s) {
            }

            public void onProviderDisabled(String s) {
            }
        };
        HandlerThread handlerThread = new HandlerThread("waitForTargetLocation");
        handlerThread.start();
        locMan.requestLocationUpdates("gps", 0L, 0.0f, locListener, handlerThread.getLooper());
        try {
            Object object = this.locationLock;
            synchronized (object) {
                this.locationLock.wait(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        locMan.removeUpdates(locListener);
        if (Build.VERSION.SDK_INT >= 18) {
            handlerThread.quitSafely();
        } else {
            handlerThread.quit();
        }
    }

    public static enum Status {
        ENABLED,
        DISABLED;

    }
}

