/*
 * Decompiled with CFR 0.152.
 */
package com.genymotion.api;

import android.content.ContentResolver;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.RemoteException;
import android.provider.Settings;
import com.genymotion.api.GenymotionException;
import com.genymotion.api.GenymotionManager;
import com.genymotion.genyd.IGenydService;

public class Id {
    private final IGenydService genyd;
    private final Object mLock = new Object();

    Id(IGenydService genyd) {
        this.genyd = genyd;
    }

    public Id setAndroidId(String id) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Id.setAndroidId(java.lang.String)");
        if (id.length() > 16 || !id.matches("^[\\da-fA-F]+$")) {
            throw new IllegalArgumentException("Android ID should be less than 16 hex chars long");
        }
        try {
            this.genyd.setAndroidId(id);
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        this.waitForTargetId(id);
        return this;
    }

    public Id setRandomAndroidId() {
        String id;
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Id.setRandomAndroidId()");
        try {
            this.genyd.setRandomAndroidId();
            id = this.genyd.getAndroidId();
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        this.waitForTargetId(id);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTargetId(final String targetId) {
        HandlerThread handlerThread = new HandlerThread("waitForTargetId");
        handlerThread.start();
        Looper looper = handlerThread.getLooper();
        final Handler handler = new Handler(looper);
        Runnable runCheckId = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String currentAndroidId = Settings.Secure.getString((ContentResolver)GenymotionManager.genymotionManager.context.getContentResolver(), (String)"android_id");
                if (!currentAndroidId.equals(targetId)) {
                    handler.postDelayed((Runnable)this, 100L);
                    return;
                }
                Object object = Id.this.mLock;
                synchronized (object) {
                    Id.this.mLock.notify();
                }
            }
        };
        handler.postDelayed(runCheckId, 100L);
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.wait(10000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (Build.VERSION.SDK_INT >= 18) {
            handlerThread.quitSafely();
        } else {
            handlerThread.quit();
        }
    }
}

