/*
 * Decompiled with CFR 0.152.
 */
package com.genymotion.api;

import com.genymotion.api.GenymotionException;
import com.genymotion.api.GenymotionManager;

public class LocationParams {
    public final Float accuracy;
    public final Double altitude;
    public final Float bearing;
    public final Double latitude;
    public final Double longitude;

    boolean hasAccuracy() {
        return this.accuracy != null;
    }

    boolean hasAltitude() {
        return this.altitude != null;
    }

    boolean hasBearing() {
        return this.bearing != null;
    }

    boolean hasLatitude() {
        return this.latitude != null;
    }

    boolean hasLongitude() {
        return this.longitude != null;
    }

    private LocationParams(Float accuracy, Double altitude, Float bearing, Double latitude, Double longitude) {
        this.accuracy = accuracy;
        this.altitude = altitude;
        this.bearing = bearing;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public static class Builder {
        private Float accuracy;
        private Double altitude;
        private Float bearing;
        private Double latitude;
        private Double longitude;

        public Builder setAccuracy(float accuracy) {
            GenymotionManager.checkApi("2.2", "com.genymotion.api.LocationParams$Builder.setAccuracy(float)");
            Builder.checkAccuracy(accuracy);
            this.accuracy = Float.valueOf(accuracy);
            return this;
        }

        public Builder setAltitude(double altitude) {
            GenymotionManager.checkApi("2.2", "com.genymotion.api.LocationParams$Builder.setAltitude(double)");
            Builder.checkAltitude(altitude);
            this.altitude = altitude;
            return this;
        }

        public Builder setBearing(float bearing) {
            GenymotionManager.checkApi("2.2", "com.genymotion.api.LocationParams$Builder.setBearing(float)");
            Builder.checkBearing(bearing);
            this.bearing = Float.valueOf(bearing);
            return this;
        }

        public Builder setLatitude(double latitude) {
            GenymotionManager.checkApi("2.2", "com.genymotion.api.LocationParams$Builder.setLatitude(double)");
            Builder.checkLatitude(latitude);
            this.latitude = latitude;
            return this;
        }

        public Builder setLongitude(double longitude) {
            GenymotionManager.checkApi("2.2", "com.genymotion.api.LocationParams$Builder.setLongitude(double)");
            Builder.checkLongitude(longitude);
            this.longitude = longitude;
            return this;
        }

        public LocationParams build() {
            GenymotionManager.checkApi("2.2", "com.genymotion.api.LocationParams$Builder.build()");
            return new LocationParams(this.accuracy, this.altitude, this.bearing, this.latitude, this.longitude);
        }

        private static void checkAccuracy(float accuracy) {
            if (accuracy < 0.0f || accuracy > 200.0f) {
                throw new GenymotionException("Invalid value. The expected range is 0 to 200");
            }
        }

        private static void checkAltitude(double altitude) {
            if (altitude < -10000.0 || altitude > 10000.0) {
                throw new GenymotionException("Invalid Value. The expected range is -1000 to 1000");
            }
        }

        private static void checkBearing(float bearing) {
            if (bearing < 0.0f || bearing >= 360.0f) {
                throw new GenymotionException("Invalid value. The expected range is 0 to 360");
            }
        }

        private static void checkLatitude(double latitude) {
            if (latitude < -90.0 || latitude > 90.0) {
                throw new GenymotionException("Invalid value. The expected range is 0 to 90");
            }
        }

        private static void checkLongitude(double longitude) {
            if (longitude < -180.0 || longitude > 180.0) {
                throw new GenymotionException("Invalid value. The expected range is -180 to 180");
            }
        }
    }
}

