/*
 * Decompiled with CFR 0.152.
 */
package com.genymotion.api;

import android.os.RemoteException;
import com.genymotion.api.GenymotionException;
import com.genymotion.api.GenymotionManager;
import com.genymotion.genyd.IGenydService;

public class Network {
    private final IGenydService genyd;

    Network(IGenydService genyd) {
        this.genyd = genyd;
    }

    public Profile getProfile() {
        Profile res;
        GenymotionManager.checkApi("2.3", "com.genymotion.api.Network.getProfile()");
        try {
            res = Profile.values()[this.genyd.getNetworkProfile()];
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        return res;
    }

    public Network setProfile(Profile profile) {
        GenymotionManager.checkApi("2.3", "com.genymotion.api.Network.setProfile(com.genymotion.api.Network$Profile)");
        try {
            this.genyd.setNetworkProfile(profile.getValue());
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        return this;
    }

    public static enum Profile {
        NONE(0),
        NO_DATA(1),
        GPRS(2),
        EDGE(3),
        THREE_G(4),
        FOUR_G(5),
        FOUR_G_BAD_DNS(6),
        FOUR_G_BAD_NETWORK(7),
        WIFI(8);

        private final int value;

        private Profile(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

