/*
 * Decompiled with CFR 0.152.
 */
package com.genymotion.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.RemoteException;
import android.telephony.SmsMessage;
import android.telephony.TelephonyManager;
import com.genymotion.api.GenymotionException;
import com.genymotion.api.GenymotionManager;
import com.genymotion.genyd.IGenydService;

public class Radio {
    private static final int TIMEOUT = 3000;
    private final IGenydService genyd;
    private final Object mLock = new Object();

    Radio(IGenydService genyd) {
        this.genyd = genyd;
    }

    public Radio setDeviceId(String id) {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Radio.setDeviceId(java.lang.String)");
        if (id.length() > 15 || !id.matches("^[a-zA-Z0-9_\\.\\-]*$")) {
            throw new GenymotionException("Device ID must be at most 15 characters and contains only alphanumeric characters, dots, dashes and underscores");
        }
        try {
            this.genyd.setDeviceId(id);
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        return this;
    }

    public Radio setRandomDeviceId() {
        GenymotionManager.checkApi("2.2", "com.genymotion.api.Radio.setRandomDeviceId()");
        try {
            this.genyd.setRandomDeviceId();
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Radio call(final String number) {
        GenymotionManager.checkApi("2.4", "com.genymotion.api.Radio.call(java.lang.String)");
        BroadcastReceiver phoneCallReceivedReciever = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                Bundle extras = intent.getExtras();
                if (extras == null) {
                    return;
                }
                if (TelephonyManager.EXTRA_STATE_RINGING.equals(extras.getString("state")) && number.equals(extras.getString("incoming_number"))) {
                    Object object = Radio.this.mLock;
                    synchronized (object) {
                        Radio.this.mLock.notify();
                    }
                }
            }
        };
        HandlerThread handlerThread = new HandlerThread("waitForCall");
        handlerThread.start();
        Looper looper = handlerThread.getLooper();
        Handler handler = new Handler(looper);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PHONE_STATE");
        filter.setPriority(-1000);
        GenymotionManager.genymotionManager.context.registerReceiver(phoneCallReceivedReciever, filter, null, handler);
        try {
            this.genyd.basebandCall(number);
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.wait(3000L);
            }
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (Build.VERSION.SDK_INT >= 18) {
                handlerThread.quitSafely();
            } else {
                handlerThread.quit();
            }
            GenymotionManager.genymotionManager.context.unregisterReceiver(phoneCallReceivedReciever);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Radio endCall(String number) {
        GenymotionManager.checkApi("2.4", "com.genymotion.api.Radio.endCall(java.lang.String)");
        BroadcastReceiver phoneCallReceivedReciever = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                Bundle extras = intent.getExtras();
                if (extras == null) {
                    return;
                }
                if (TelephonyManager.EXTRA_STATE_IDLE.equals(extras.getString("state"))) {
                    Object object = Radio.this.mLock;
                    synchronized (object) {
                        Radio.this.mLock.notify();
                    }
                }
            }
        };
        HandlerThread handlerThread = new HandlerThread("waitForCall");
        handlerThread.start();
        Looper looper = handlerThread.getLooper();
        Handler handler = new Handler(looper);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PHONE_STATE");
        filter.setPriority(-1000);
        GenymotionManager.genymotionManager.context.registerReceiver(phoneCallReceivedReciever, filter, null, handler);
        try {
            this.genyd.basebandEndCall(number);
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.wait(3000L);
            }
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (Build.VERSION.SDK_INT >= 18) {
                handlerThread.quitSafely();
            } else {
                handlerThread.quit();
            }
            GenymotionManager.genymotionManager.context.unregisterReceiver(phoneCallReceivedReciever);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Radio sendSms(String number, final String message) {
        GenymotionManager.checkApi("2.4", "com.genymotion.api.Radio.sendSms(java.lang.String,java.lang.String)");
        BroadcastReceiver smsReceivedReciever = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReceive(Context context, Intent intent) {
                Object[] rawMessages;
                Bundle extras = intent.getExtras();
                if (extras == null) {
                    return;
                }
                for (Object rawMessage : rawMessages = (Object[])extras.get("pdus")) {
                    SmsMessage sms = SmsMessage.createFromPdu((byte[])((byte[])rawMessage));
                    if (!sms.getMessageBody().equals(message)) continue;
                    Object object = Radio.this.mLock;
                    synchronized (object) {
                        Radio.this.mLock.notify();
                    }
                }
            }
        };
        HandlerThread handlerThread = new HandlerThread("waitForSms");
        handlerThread.start();
        Looper looper = handlerThread.getLooper();
        Handler handler = new Handler(looper);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.provider.Telephony.SMS_RECEIVED");
        filter.setPriority(-1000);
        GenymotionManager.genymotionManager.context.registerReceiver(smsReceivedReciever, filter, null, handler);
        try {
            this.genyd.basebandSms(number, message);
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.wait(3000L);
            }
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (Build.VERSION.SDK_INT >= 18) {
                handlerThread.quitSafely();
            } else {
                handlerThread.quit();
            }
            GenymotionManager.genymotionManager.context.unregisterReceiver(smsReceivedReciever);
        }
        return this;
    }

    public Radio command(String command) {
        GenymotionManager.checkApi("2.4", "com.genymotion.api.Radio.command(java.lang.String)");
        try {
            this.genyd.basebandCommand(command);
        }
        catch (RemoteException e) {
            throw new GenymotionException("Unable to communicate with Genymotion", e);
        }
        return this;
    }
}

