/*
 * Decompiled with CFR 0.152.
 */
package com.genymotion.genyd;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;

public class NetworkProfile
implements Parcelable {
    public static final String MODULE_NAME = "network_profile";
    public static final String ENABLE_ACTION = "enable";
    public static final String DISABLE_ACTION = "disable";
    private static final String TAG = "NetworkProfile";
    private static final String SET_ACTION = "set";
    private static final String STATE_ACTION = "state";
    private static final String WIFI_MODULE = "wifi";
    private static final String PARAM_DOWNRATE = "down_rate";
    private static final String PARAM_UPRATE = "up_rate";
    private static final String PARAM_DOWNDELAY = "down_delay";
    private static final String PARAM_UPDELAY = "up_delay";
    private static final String PARAM_DOWNPACKETLOSS = "down_pkt_loss";
    private static final String PARAM_UPPACKETLOSS = "up_pkt_loss";
    private static final String PARAM_DNSDELAY = "dns_delay";
    public static final NetworkProfile[] AVAILABLE_PROFILES = new NetworkProfile[]{new NetworkProfile(Name.NONE, -1, -1, 0, 0, 0.0f, 0.0f, 0, "disable"), new NetworkProfile(Name.NO_DATA, 0, 0, 0, 0, 100.0f, 100.0f, 0, "enable"), new NetworkProfile(Name.GPRS, 40, 40, 500, 500, 0.01f, 0.01f, 100, "enable"), new NetworkProfile(Name.EDGE, 240, 200, 400, 400, 0.01f, 0.01f, 800, "enable"), new NetworkProfile(Name.THREE_G, 7200, 1500, 100, 100, 0.01f, 0.01f, 200, "enable"), new NetworkProfile(Name.FOUR_G, 17900, 5500, 50, 50, 0.01f, 0.01f, 100, "enable"), new NetworkProfile(Name.FOUR_G_BAD_DNS, 17900, 5500, 50, 50, 0.01f, 0.01f, 3000, "enable"), new NetworkProfile(Name.FOUR_G_BAD_NETWORK, 17900, 5500, 50, 50, 10.0f, 10.0f, 100, "enable"), new NetworkProfile(Name.WIFI, 40000, 33000, 0, 0, 0.0f, 0.0f, 0, "enable")};
    public Name name = Name.INVALID;
    public int downBandwidthKbps = -1;
    public int upBandwidthKbps = -1;
    public int downDelayMs = -1;
    public int upDelayMs = -1;
    public float downPacketLossPercent = -1.0f;
    public float upPacketLossPercent = -1.0f;
    public int dnsDelayMs = -1;
    public String action = "";
    public static final Parcelable.Creator<NetworkProfile> CREATOR = new Parcelable.Creator<NetworkProfile>(){

        public NetworkProfile createFromParcel(Parcel source) {
            NetworkProfile profile = new NetworkProfile();
            profile.name = Name.fromValue(source.readInt());
            profile.downBandwidthKbps = source.readInt();
            profile.upBandwidthKbps = source.readInt();
            profile.downDelayMs = source.readInt();
            profile.upDelayMs = source.readInt();
            profile.downPacketLossPercent = source.readFloat();
            profile.upPacketLossPercent = source.readFloat();
            profile.dnsDelayMs = source.readInt();
            profile.action = source.readString();
            return profile;
        }

        public NetworkProfile[] newArray(int size) {
            return new NetworkProfile[size];
        }
    };

    public NetworkProfile() {
    }

    private NetworkProfile(Name name, int downBandwidthKbps, int upBandwidthKbps, int downDelayMs, int upDelayMs, float downPacketLossPercent, float upPacketLossPercent, int dnsDelayMs, String action) {
        this.name = name;
        this.downBandwidthKbps = downBandwidthKbps;
        this.upBandwidthKbps = upBandwidthKbps;
        this.downDelayMs = downDelayMs;
        this.upDelayMs = upDelayMs;
        this.downPacketLossPercent = downPacketLossPercent;
        this.upPacketLossPercent = upPacketLossPercent;
        this.dnsDelayMs = dnsDelayMs;
        this.action = action;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.name.getValue());
        dest.writeInt(this.downBandwidthKbps);
        dest.writeInt(this.upBandwidthKbps);
        dest.writeInt(this.downDelayMs);
        dest.writeInt(this.upDelayMs);
        dest.writeFloat(this.downPacketLossPercent);
        dest.writeFloat(this.upPacketLossPercent);
        dest.writeInt(this.dnsDelayMs);
        dest.writeString(this.action);
    }

    public String[] forgeSetMessages() {
        ArrayList<String> messagesList = new ArrayList<String>();
        String enabledString = "";
        if (this.downBandwidthKbps > -1) {
            messagesList.add("set wifi down_rate " + this.downBandwidthKbps);
            enabledString = enabledString + "down_rate:";
        }
        if (this.upBandwidthKbps > -1) {
            messagesList.add("set wifi up_rate " + this.upBandwidthKbps);
            enabledString = enabledString + "up_rate:";
        }
        if (this.downDelayMs > 0) {
            messagesList.add("set wifi down_delay " + this.downDelayMs);
            enabledString = enabledString + "down_delay:";
        }
        if (this.upDelayMs > 0) {
            messagesList.add("set wifi up_delay " + this.upDelayMs);
            enabledString = enabledString + "up_delay:";
        }
        if (this.downPacketLossPercent > 0.0f) {
            messagesList.add("set wifi down_pkt_loss " + this.downPacketLossPercent);
            enabledString = enabledString + "down_pkt_loss:";
        }
        if (this.upPacketLossPercent > 0.0f) {
            messagesList.add("set wifi up_pkt_loss " + this.upPacketLossPercent);
            enabledString = enabledString + "up_pkt_loss:";
        }
        if (this.dnsDelayMs > 0) {
            messagesList.add("set wifi dns_delay " + this.dnsDelayMs);
            enabledString = enabledString + "dns_delay:";
        }
        messagesList.add("disable wifi all");
        if (enabledString.length() > 0) {
            enabledString = enabledString.substring(0, enabledString.length() - 1);
            Log.d((String)TAG, (String)("enabling: " + enabledString));
            messagesList.add("enable wifi " + enabledString);
        }
        return messagesList.toArray(new String[messagesList.size()]);
    }

    private void setParameter(String name, boolean enabled, String value) {
        try {
            if (PARAM_UPRATE.equalsIgnoreCase(name)) {
                this.upBandwidthKbps = enabled ? Integer.parseInt(value) : -1;
            } else if (PARAM_DOWNRATE.equalsIgnoreCase(name)) {
                this.downBandwidthKbps = enabled ? Integer.parseInt(value) : -1;
            } else if (PARAM_UPDELAY.equalsIgnoreCase(name)) {
                this.upDelayMs = enabled ? Integer.parseInt(value) : 0;
            } else if (PARAM_DOWNDELAY.equalsIgnoreCase(name)) {
                this.downDelayMs = enabled ? Integer.parseInt(value) : 0;
            } else if (PARAM_UPPACKETLOSS.equalsIgnoreCase(name)) {
                this.upPacketLossPercent = enabled ? Float.parseFloat(value) : 0.0f;
            } else if (PARAM_DOWNPACKETLOSS.equalsIgnoreCase(name)) {
                this.downPacketLossPercent = enabled ? Float.parseFloat(value) : 0.0f;
            } else if (PARAM_DNSDELAY.equalsIgnoreCase(name)) {
                this.dnsDelayMs = enabled ? Integer.parseInt(value) : 0;
            }
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("Wrong float/integer value for " + name + ". Value: " + value));
        }
    }

    public boolean isValid() {
        return this.name != Name.INVALID && (this.action.equals(ENABLE_ACTION) || this.action.equals(DISABLE_ACTION));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkProfile other = (NetworkProfile)obj;
        return this.action == other.action && this.downBandwidthKbps == other.downBandwidthKbps && this.upBandwidthKbps == other.upBandwidthKbps && this.downDelayMs == other.downDelayMs && this.upDelayMs == other.upDelayMs && NetworkProfile.nearlyEqual(this.downPacketLossPercent, other.downPacketLossPercent) && NetworkProfile.nearlyEqual(this.upPacketLossPercent, other.upPacketLossPercent) && this.dnsDelayMs == other.dnsDelayMs;
    }

    public static NetworkProfile parseMessage(String message) {
        if (!message.startsWith("network_profile state wifi")) {
            return null;
        }
        String[] elements = message.split(" ");
        if (elements.length < 9) {
            return null;
        }
        NetworkProfile profile = new NetworkProfile();
        profile.action = DISABLE_ACTION;
        for (int i = 3; i < elements.length; ++i) {
            String[] parameterInfo = elements[i].split(":");
            if (parameterInfo.length < 3) continue;
            profile.setParameter(parameterInfo[0], parameterInfo[1].equalsIgnoreCase(Status.ENABLED.toString()), parameterInfo[2]);
            if (!parameterInfo[1].equalsIgnoreCase(Status.ENABLED.toString())) continue;
            profile.action = ENABLE_ACTION;
        }
        for (NetworkProfile availableProfile : AVAILABLE_PROFILES) {
            if (!profile.equals(availableProfile)) continue;
            profile.name = availableProfile.name;
            break;
        }
        if (profile.name == Name.INVALID) {
            profile.name = Name.CUSTOM;
        }
        return profile;
    }

    public static String forgeGetMessage() {
        return "notify wifi";
    }

    private static boolean nearlyEqual(double a, double b) {
        return Math.abs(a - b) < 0.001;
    }

    public static enum Name {
        NONE(0),
        NO_DATA(1),
        GPRS(2),
        EDGE(3),
        THREE_G(4),
        FOUR_G(5),
        FOUR_G_BAD_DNS(6),
        FOUR_G_BAD_NETWORK(7),
        WIFI(8),
        INVALID(9),
        CUSTOM(10);

        private final int value;

        private Name(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        private static Name fromValue(int value) {
            for (Name name : Name.values()) {
                if (name.getValue() != value) continue;
                return name;
            }
            throw new IllegalArgumentException(value + " is not a valid network Profile name.");
        }
    }

    public static enum Status {
        ENABLED,
        DISABLED;

    }
}

