/*
 * Decompiled with CFR 0.152.
 */
package com.wix.detox.espresso;

import android.app.Instrumentation;
import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import androidx.test.platform.app.InstrumentationRegistry;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nH\u0002J\b\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\n \u000b*\u0004\u0018\u00010\u000f0\u000fH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/wix/detox/espresso/DeviceDisplay;", "", "()V", "convertDpiToPx", "", "dip", "", "convertPxToDpi", "pixel", "getAppContext", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "getDensity", "", "getDisplayMetrics", "Landroid/util/DisplayMetrics;", "getScreenSizeInPX", "", "detox_coreNativeRelease"})
public final class DeviceDisplay {
    public static final DeviceDisplay INSTANCE;

    @JvmStatic
    public static final float getDensity() {
        return DeviceDisplay.INSTANCE.getDisplayMetrics().density;
    }

    @JvmStatic
    public static final int convertDpiToPx(double dip) {
        return (int)(dip * (double)DeviceDisplay.getDensity() + (double)0.5f);
    }

    @JvmStatic
    public static final int convertPxToDpi(int pixel) {
        return (int)(((float)pixel - 0.5f) / DeviceDisplay.getDensity());
    }

    @JvmStatic
    @Nullable
    public static final float[] getScreenSizeInPX() {
        DisplayMetrics metrics = INSTANCE.getDisplayMetrics();
        return new float[]{metrics.widthPixels, metrics.heightPixels};
    }

    private final DisplayMetrics getDisplayMetrics() {
        Context context = this.getAppContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"getAppContext()");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"getAppContext().resources");
        return resources.getDisplayMetrics();
    }

    private final Context getAppContext() {
        Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)instrumentation, (String)"InstrumentationRegistry.getInstrumentation()");
        Context context = instrumentation.getTargetContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"InstrumentationRegistry.\u2026mentation().targetContext");
        return context.getApplicationContext();
    }

    private DeviceDisplay() {
    }

    static {
        DeviceDisplay deviceDisplay;
        INSTANCE = deviceDisplay = new DeviceDisplay();
    }
}

