/*
 * Decompiled with CFR 0.152.
 */
package com.wix.detox.espresso.action;

import android.view.View;
import android.view.ViewGroup;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import com.facebook.react.views.scroll.ReactHorizontalScrollView;
import com.facebook.react.views.scroll.ReactScrollView;
import com.wix.detox.espresso.action.ScrollToIndexActionKt;
import com.wix.detox.espresso.scroll.ScrollEdgeException;
import com.wix.detox.espresso.scroll.ScrollHelper;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.AnyOf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/wix/detox/espresso/action/ScrollToIndexAction;", "Landroidx/test/espresso/ViewAction;", "index", "", "(I)V", "getConstraints", "Lorg/hamcrest/Matcher;", "Landroid/view/View;", "getDescription", "", "perform", "", "uiController", "Landroidx/test/espresso/UiController;", "view", "detox_coreNativeRelease"})
public final class ScrollToIndexAction
implements ViewAction {
    private final int index;

    @NotNull
    public Matcher<View> getConstraints() {
        AnyOf anyOf = Matchers.anyOf((Matcher)Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(View.class), (Matcher)Matchers.instanceOf(ReactScrollView.class)), (Matcher)Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(View.class), (Matcher)Matchers.instanceOf(ReactHorizontalScrollView.class)));
        Intrinsics.checkExpressionValueIsNotNull((Object)anyOf, (String)"Matchers.anyOf(\n        \u2026)\n            )\n        )");
        return (Matcher)anyOf;
    }

    @NotNull
    public String getDescription() {
        return "scrollToIndex";
    }

    public void perform(@Nullable UiController uiController, @Nullable View view) {
        if (this.index < 0) {
            return;
        }
        float offsetPercent = 0.4f;
        View view2 = view;
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup reactScrollView = (ViewGroup)view2;
        View view3 = reactScrollView.getChildAt(0);
        if (view3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup internalContainer = (ViewGroup)view3;
        int childCount = internalContainer.getChildCount();
        if (this.index >= childCount) {
            return;
        }
        boolean isHorizontalScrollView = ScrollToIndexActionKt.access$getIsHorizontalScrollView(reactScrollView);
        int targetPosition = ScrollToIndexActionKt.access$getTargetPosition(isHorizontalScrollView, internalContainer, this.index);
        int currentPosition = ScrollToIndexActionKt.access$getCurrentPosition(isHorizontalScrollView, reactScrollView);
        int jumpSize = ScrollToIndexActionKt.access$getTargetDimension(isHorizontalScrollView, internalContainer, this.index);
        int scrollDirection = ScrollToIndexActionKt.access$getScrollDirection(isHorizontalScrollView, currentPosition, targetPosition);
        while (Math.abs(currentPosition - targetPosition) >= jumpSize) {
            int n;
            try {
                ScrollHelper.perform(uiController, view, scrollDirection, jumpSize, Float.valueOf(offsetPercent), Float.valueOf(offsetPercent));
                n = ScrollToIndexActionKt.access$getCurrentPosition(isHorizontalScrollView, reactScrollView);
            }
            catch (ScrollEdgeException e) {
                return;
            }
            currentPosition = n;
        }
        return;
    }

    public ScrollToIndexAction(int index) {
        this.index = index;
    }
}

