/*
 * Decompiled with CFR 0.152.
 */
package com.wix.detox.espresso.scroll;

import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.test.espresso.UiController;
import com.wix.detox.espresso.action.common.MotionEvents;
import com.wix.detox.espresso.scroll.DetoxSwiper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/wix/detox/espresso/scroll/FlinglessSwiper;", "Lcom/wix/detox/espresso/scroll/DetoxSwiper;", "expectedMotions", "", "uiController", "Landroidx/test/espresso/UiController;", "viewConfig", "Landroid/view/ViewConfiguration;", "motionEvents", "Lcom/wix/detox/espresso/action/common/MotionEvents;", "(ILandroidx/test/espresso/UiController;Landroid/view/ViewConfiguration;Lcom/wix/detox/espresso/action/common/MotionEvents;)V", "downEvent", "Landroid/view/MotionEvent;", "events", "", "fastEventsCountLimit", "", "motionsCount", "pixelsPerSecond", "assertNotStarted", "", "assertStarted", "calcEventTime", "", "targetX", "targetY", "finishAt", "releaseX", "releaseY", "moveTo", "", "startAt", "touchX", "touchY", "Companion", "detox_coreNativeRelease"})
public final class FlinglessSwiper
implements DetoxSwiper {
    private final float pixelsPerSecond;
    private final float fastEventsCountLimit;
    private MotionEvent downEvent;
    private List<MotionEvent> events;
    private int motionsCount;
    private final UiController uiController;
    private final MotionEvents motionEvents;
    private static final float VELOCITY_SAFETY_RATIO = 0.99f;
    private static final float FAST_EVENTS_RATIO = 0.75f;
    public static final Companion Companion = new Companion(null);

    @Override
    public void startAt(float touchX, float touchY) {
        this.assertNotStarted();
        MotionEvent motionEvent = this.downEvent = MotionEvents.obtainDownEvent$default(this.motionEvents, touchX, touchY, null, 4, null);
        if (motionEvent == null) {
            Intrinsics.throwNpe();
        }
        this.events.add(motionEvent);
    }

    @Override
    public boolean moveTo(float targetX, float targetY) {
        this.assertStarted();
        MotionEvent motionEvent = this.downEvent;
        if (motionEvent == null) {
            Intrinsics.throwNpe();
        }
        MotionEvent moveEvent = this.motionEvents.obtainMoveEvent(motionEvent, this.calcEventTime(targetX, targetY), targetX, targetY);
        this.events.add(moveEvent);
        int n = this.motionsCount;
        this.motionsCount = n + 1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishAt(float releaseX, float releaseY) {
        this.assertStarted();
        try {
            MotionEvent motionEvent = this.downEvent;
            if (motionEvent == null) {
                Intrinsics.throwNpe();
            }
            MotionEvent upEvent = this.motionEvents.obtainUpEvent(motionEvent, this.calcEventTime(releaseX, releaseY), releaseX, releaseY);
            this.events.add(upEvent);
            this.uiController.injectMotionEventSequence((Iterable)this.events);
        }
        finally {
            Iterable $this$forEach$iv = this.events;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MotionEvent event = (MotionEvent)element$iv;
                boolean bl = false;
                event.recycle();
            }
            this.downEvent = null;
            this.motionsCount = 0;
        }
    }

    private final long calcEventTime(float targetX, float targetY) {
        MotionEvent lastEvent = (MotionEvent)CollectionsKt.last(this.events);
        int dt = 10;
        if ((float)this.motionsCount >= this.fastEventsCountLimit) {
            float dx = Math.abs(targetX - lastEvent.getX());
            float dy = Math.abs(targetY - lastEvent.getY());
            int dtX = (int)(dx / this.pixelsPerSecond * (float)1000);
            int dtY = (int)(dy / this.pixelsPerSecond * (float)1000);
            dt = Math.max(dtX, dtY);
        }
        return lastEvent.getEventTime() + (long)Math.max(dt, 10);
    }

    private final void assertStarted() {
        if (this.downEvent == null) {
            throw (Throwable)new IllegalStateException("Swiper not initialized - did you forget to call startAt()?");
        }
    }

    private final void assertNotStarted() {
        if (this.downEvent != null) {
            throw (Throwable)new IllegalStateException("Swiper already started");
        }
    }

    @JvmOverloads
    public FlinglessSwiper(int expectedMotions, @NotNull UiController uiController, @NotNull ViewConfiguration viewConfig, @NotNull MotionEvents motionEvents) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)uiController, (String)"uiController");
        Intrinsics.checkParameterIsNotNull((Object)viewConfig, (String)"viewConfig");
        Intrinsics.checkParameterIsNotNull((Object)motionEvents, (String)"motionEvents");
        this.uiController = uiController;
        this.motionEvents = motionEvents;
        this.pixelsPerSecond = (float)viewConfig.getScaledMinimumFlingVelocity() * 0.99f;
        this.fastEventsCountLimit = (float)expectedMotions * 0.75f;
        FlinglessSwiper flinglessSwiper = this;
        boolean bl = false;
        flinglessSwiper.events = list = (List)new ArrayList();
    }

    public /* synthetic */ FlinglessSwiper(int n, UiController uiController, ViewConfiguration viewConfiguration, MotionEvents motionEvents, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            motionEvents = new MotionEvents();
        }
        this(n, uiController, viewConfiguration, motionEvents);
    }

    @JvmOverloads
    public FlinglessSwiper(int expectedMotions, @NotNull UiController uiController, @NotNull ViewConfiguration viewConfig) {
        this(expectedMotions, uiController, viewConfig, null, 8, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/wix/detox/espresso/scroll/FlinglessSwiper$Companion;", "", "()V", "FAST_EVENTS_RATIO", "", "VELOCITY_SAFETY_RATIO", "detox_coreNativeRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

