/*
 * Decompiled with CFR 0.152.
 */
package com.wix.detox.espresso.scroll;

import android.content.Context;
import android.graphics.Point;
import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.test.espresso.UiController;
import androidx.test.platform.app.InstrumentationRegistry;
import com.wix.detox.espresso.DeviceDisplay;
import com.wix.detox.espresso.scroll.DetoxSwipe;
import com.wix.detox.espresso.scroll.FlinglessSwiper;
import com.wix.detox.espresso.scroll.ScrollEdgeException;
import com.wix.detox.espresso.scroll.ScrollProbes;
import com.wix.detox.espresso.scroll.ScrollableProbe;

public class ScrollHelper {
    private static final String LOG_TAG = "DetoxScrollHelper";
    private static final int SCROLL_MOTIONS = 70;
    private static final int MAX_FLING_WAITS = 3;
    private static final double DEFAULT_DEADZONE_PERCENT = 0.05;
    private static final double SCROLL_RANGE_SAFE_PERCENT = 0.9;
    private static ViewConfiguration viewConfiguration = null;

    private ScrollHelper() {
    }

    public static void perform(UiController uiController, View view, int direction, double amountInDP, Float startOffsetPercentX, Float startOffsetPercentY) throws ScrollEdgeException {
        int amountInPx = DeviceDisplay.convertDpiToPx(amountInDP);
        int safeScrollableRangePx = ScrollHelper.getViewSafeScrollableRangePix(view, direction);
        int times = amountInPx / safeScrollableRangePx;
        int remainder = amountInPx % safeScrollableRangePx;
        Log.d((String)LOG_TAG, (String)("prescroll amountDP=" + amountInDP + " amountPx=" + amountInPx + " scrollableRangePx=" + safeScrollableRangePx + " times=" + times + " remainder=" + remainder));
        for (int i = 0; i < times; ++i) {
            ScrollHelper.scrollOnce(uiController, view, direction, safeScrollableRangePx, startOffsetPercentX, startOffsetPercentY);
        }
        ScrollHelper.scrollOnce(uiController, view, direction, remainder, startOffsetPercentX, startOffsetPercentY);
    }

    public static void performOnce(UiController uiController, View view, int direction) throws ScrollEdgeException {
        int scrollableRangePx = ScrollHelper.getViewSafeScrollableRangePix(view, direction);
        ScrollHelper.scrollOnce(uiController, view, direction, scrollableRangePx, null, null);
    }

    private static void scrollOnce(UiController uiController, View view, int direction, int userAmountPx, Float startOffsetPercentX, Float startOffsetPercentY) throws ScrollEdgeException {
        ScrollableProbe scrollableProbe = ScrollProbes.getScrollableProbe(view, direction);
        if (scrollableProbe.atScrollingEdge()) {
            throw new ScrollEdgeException("View is already at the scrolling edge");
        }
        Point downPoint = ScrollHelper.getScrollStartPoint(view, direction, startOffsetPercentX, startOffsetPercentY);
        Point upPoint = ScrollHelper.getScrollEndPoint(downPoint, direction, userAmountPx, startOffsetPercentX, startOffsetPercentY);
        Log.d((String)LOG_TAG, (String)("scroll " + downPoint + " --> " + upPoint));
        ScrollHelper.doScroll(view.getContext(), uiController, downPoint.x, downPoint.y, upPoint.x, upPoint.y);
        ScrollHelper.waitForFlingToFinish(view, uiController);
    }

    private static void doScroll(Context context, UiController uiController, int downX, int downY, int upX, int upY) {
        FlinglessSwiper swiper = new FlinglessSwiper(70, uiController, ViewConfiguration.get((Context)context));
        DetoxSwipe swipe = new DetoxSwipe(downX, downY, upX, upY, 70, swiper);
        swipe.perform();
    }

    private static void waitForFlingToFinish(View view, UiController uiController) {
        int startX;
        int startY;
        int waitTimeMS = 100;
        int iteration = 0;
        do {
            startY = view.getScrollY();
            startX = view.getScrollX();
            uiController.loopMainThreadForAtLeast((long)waitTimeMS);
            waitTimeMS = 10;
        } while ((view.getScrollY() != startY || view.getScrollX() != startX) && ++iteration < 3);
        if (iteration > 1) {
            Log.w((String)LOG_TAG, (String)("Detected a possibly overly-running fling! (#iterations=" + iteration + ")"));
        }
    }

    private static int getViewSafeScrollableRangePix(View view, int direction) {
        int range;
        float[] screenSize = DeviceDisplay.getScreenSizeInPX();
        int[] pos = new int[2];
        view.getLocationInWindow(pos);
        switch (direction) {
            case 1: {
                range = (int)((double)(screenSize[0] - (float)pos[0]) * 0.9);
                break;
            }
            case 2: {
                range = (int)((double)(pos[0] + view.getWidth()) * 0.9);
                break;
            }
            case 3: {
                range = (int)((double)(screenSize[1] - (float)pos[1]) * 0.9);
                break;
            }
            default: {
                range = (int)((double)(pos[1] + view.getHeight()) * 0.9);
            }
        }
        return range;
    }

    private static Point getScrollStartPoint(View view, int direction, Float startOffsetPercentX, Float startOffsetPercentY) {
        int safetyOffsetY;
        int safetyOffsetX;
        float offsetFactorY;
        float offsetFactorX;
        int safetyOffset = DeviceDisplay.convertDpiToPx(1.0);
        Point point = ScrollHelper.getGlobalViewLocation(view);
        switch (direction) {
            case 2: {
                offsetFactorX = startOffsetPercentX != null ? startOffsetPercentX.floatValue() : 1.0f;
                offsetFactorY = startOffsetPercentY != null ? startOffsetPercentY.floatValue() : 0.5f;
                safetyOffsetX = startOffsetPercentX != null ? 0 : -safetyOffset;
                safetyOffsetY = 0;
                break;
            }
            case 1: {
                offsetFactorX = startOffsetPercentX != null ? startOffsetPercentX.floatValue() : 0.0f;
                offsetFactorY = startOffsetPercentY != null ? startOffsetPercentY.floatValue() : 0.5f;
                safetyOffsetX = startOffsetPercentX != null ? 0 : safetyOffset;
                safetyOffsetY = 0;
                break;
            }
            case 4: {
                offsetFactorX = startOffsetPercentX != null ? startOffsetPercentX.floatValue() : 0.5f;
                offsetFactorY = startOffsetPercentY != null ? startOffsetPercentY.floatValue() : 1.0f;
                safetyOffsetX = 0;
                safetyOffsetY = startOffsetPercentY != null ? 0 : -safetyOffset;
                break;
            }
            case 3: {
                offsetFactorX = startOffsetPercentX != null ? startOffsetPercentX.floatValue() : 0.5f;
                offsetFactorY = startOffsetPercentY != null ? startOffsetPercentY.floatValue() : 0.0f;
                safetyOffsetX = 0;
                safetyOffsetY = startOffsetPercentY != null ? 0 : safetyOffset;
                break;
            }
            default: {
                throw new RuntimeException("Scroll direction can go from 1 to 4");
            }
        }
        int offsetX = (int)((float)view.getWidth() * offsetFactorX) + safetyOffsetX;
        int offsetY = (int)((float)view.getHeight() * offsetFactorY) + safetyOffsetY;
        point.offset(offsetX, offsetY);
        return point;
    }

    private static Point getScrollEndPoint(Point startPoint, int direction, int userAmountPx, Float startOffsetPercentX, Float startOffsetPercentY) {
        int amountY;
        int amountX;
        int safetyOffset = DeviceDisplay.convertDpiToPx(1.0);
        int safetyOffsetX = startOffsetPercentX != null ? safetyOffset : 0;
        int safetyOffsetY = startOffsetPercentY != null ? safetyOffset : 0;
        int touchToScrollSlopPx = ScrollHelper.getViewConfiguration().getScaledTouchSlop();
        int amountPx = userAmountPx + touchToScrollSlopPx;
        Point point = new Point(startPoint);
        switch (direction) {
            case 2: {
                amountX = -amountPx - safetyOffsetX;
                amountY = 0;
                break;
            }
            case 1: {
                amountX = amountPx + safetyOffsetX;
                amountY = 0;
                break;
            }
            case 4: {
                amountX = 0;
                amountY = -amountPx - safetyOffsetY;
                break;
            }
            case 3: {
                amountX = 0;
                amountY = amountPx + safetyOffsetY;
                break;
            }
            default: {
                throw new RuntimeException("Scroll direction can go from 1 to 4");
            }
        }
        point.offset(amountX, amountY);
        return point;
    }

    private static Point getGlobalViewLocation(View view) {
        int[] pos = new int[2];
        view.getLocationInWindow(pos);
        return new Point(pos[0], pos[1]);
    }

    private static ViewConfiguration getViewConfiguration() {
        if (viewConfiguration == null) {
            Context applicationContext = InstrumentationRegistry.getInstrumentation().getTargetContext().getApplicationContext();
            viewConfiguration = ViewConfiguration.get((Context)applicationContext);
        }
        return viewConfiguration;
    }
}

