/*
 * Decompiled with CFR 0.152.
 */
package com.wix.detox.espresso.utils;

import com.wix.detox.espresso.utils.Vector2DKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\b\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\u0000J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u0018\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0018\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00032\b\b\u0002\u0010\u001e\u001a\u00020\u0003J\u0018\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006&"}, d2={"Lcom/wix/detox/espresso/utils/Vector2D;", "", "x", "", "y", "(DD)V", "getX", "()D", "getY", "add", "other", "component1", "component2", "copy", "equals", "", "hashCode", "", "normalize", "rotate", "fromDirection", "toDirection", "scale", "vector", "amountX", "amountY", "toString", "", "trimMax", "xMax", "yMax", "trimMin", "xMin", "yMin", "withX", "value", "withY", "Companion", "detox_coreNativeRelease"})
public final class Vector2D {
    private final double x;
    private final double y;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Vector2D add(@NotNull Vector2D other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Vector2D(this.x + other.x, this.y + other.y);
    }

    @NotNull
    public final Vector2D normalize() {
        return new Vector2D(Vector2DKt.access$normalize(this.x), Vector2DKt.access$normalize(this.y));
    }

    @NotNull
    public final Vector2D rotate(int fromDirection, int toDirection) {
        Vector2D vector2D;
        switch (Vector2DKt.access$angleBetween(fromDirection, toDirection)) {
            case 90: {
                vector2D = new Vector2D(this.y, -this.x);
                break;
            }
            case 180: {
                vector2D = new Vector2D(-this.x, -this.y);
                break;
            }
            case 270: {
                vector2D = new Vector2D(-this.y, this.x);
                break;
            }
            default: {
                vector2D = new Vector2D(this.x, this.y);
            }
        }
        return vector2D;
    }

    @NotNull
    public final Vector2D scale(double amountX, double amountY) {
        return new Vector2D(this.x * amountX, this.y * amountY);
    }

    public static /* synthetic */ Vector2D scale$default(Vector2D vector2D, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return vector2D.scale(d, d2);
    }

    @NotNull
    public final Vector2D scale(@NotNull Vector2D vector) {
        Intrinsics.checkParameterIsNotNull((Object)vector, (String)"vector");
        return this.scale(vector.x, vector.y);
    }

    @NotNull
    public final Vector2D trimMax(double xMax, double yMax) {
        double d;
        double d2 = this.x;
        boolean bl = false;
        double d3 = Math.max(d2, xMax);
        d2 = this.y;
        bl = false;
        double d4 = d = Math.max(d2, yMax);
        double d5 = d3;
        return new Vector2D(d5, d4);
    }

    public static /* synthetic */ Vector2D trimMax$default(Vector2D vector2D, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return vector2D.trimMax(d, d2);
    }

    @NotNull
    public final Vector2D trimMin(double xMin, double yMin) {
        double d;
        double d2 = this.x;
        boolean bl = false;
        double d3 = Math.min(d2, xMin);
        d2 = this.y;
        bl = false;
        double d4 = d = Math.min(d2, yMin);
        double d5 = d3;
        return new Vector2D(d5, d4);
    }

    public static /* synthetic */ Vector2D trimMin$default(Vector2D vector2D, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = d;
        }
        return vector2D.trimMin(d, d2);
    }

    @NotNull
    public final Vector2D withX(double value) {
        return new Vector2D(value, this.y);
    }

    @NotNull
    public final Vector2D withY(double value) {
        return new Vector2D(this.x, value);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final Vector2D copy(double x, double y) {
        return new Vector2D(x, y);
    }

    public static /* synthetic */ Vector2D copy$default(Vector2D vector2D, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector2D.x;
        }
        if ((n & 2) != 0) {
            d2 = vector2D.y;
        }
        return vector2D.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Vector2D(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        return (int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vector2D)) break block3;
                Vector2D vector2D = (Vector2D)object;
                if (Double.compare(this.x, vector2D.x) != 0 || Double.compare(this.y, vector2D.y) != 0) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lcom/wix/detox/espresso/utils/Vector2D$Companion;", "", "()V", "from", "Lcom/wix/detox/espresso/utils/Vector2D;", "arr", "", "x", "", "y", "detox_coreNativeRelease"})
    public static final class Companion {
        @NotNull
        public final Vector2D from(@NotNull float[] arr) {
            Intrinsics.checkParameterIsNotNull((Object)arr, (String)"arr");
            return new Vector2D(arr[0], arr[1]);
        }

        @NotNull
        public final Vector2D from(int x, int y) {
            return new Vector2D(x, y);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

