/*
 * Decompiled with CFR 0.152.
 */
package quix.athena;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.athena.model.AmazonAthenaException;
import com.amazonaws.services.athena.model.GetQueryResultsResult;
import com.amazonaws.services.athena.model.QueryExecution;
import com.amazonaws.services.athena.model.QueryExecutionState;
import com.amazonaws.services.athena.model.ResultSet;
import com.amazonaws.services.athena.model.Row;
import com.amazonaws.services.athena.model.StartQueryExecutionResult;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import monix.eval.Task;
import monix.eval.Task$;
import quix.api.v1.execute.Batch;
import quix.api.v1.execute.Batch$;
import quix.api.v1.execute.BatchColumn;
import quix.api.v2.execute.Builder;
import quix.api.v2.execute.Executor;
import quix.api.v2.execute.SubQuery;
import quix.athena.AthenaClient;
import quix.athena.AthenaConfig;
import quix.athena.AthenaQueryExecutor$;
import quix.core.utils.TaskOps;
import quix.core.utils.TaskOps$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u000e\u001d\u0001\u0005B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005}!A1\t\u0001BC\u0002\u0013\u0005A\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003F\u0011!q\u0005A!b\u0001\n\u0003!\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000bA\u0003A\u0011A)\t\u000bY\u0003A\u0011A,\t\u0013\u0005%\u0001!%A\u0005\u0002\u0005-\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bB\u0011\"!\u001b\u0001#\u0003%\t!a\u001b\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAY\u0001\u0011\u0005\u00111\u0017\u0005\n\u0003\u0003\u0004\u0011\u0013!C\u0001\u0003\u0007Daa\u000b\u0001\u0005\u0002\u0005\u001d\u0007bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0003K\u0004A\u0011AAt\u000f\u001d\t\u0019\u0010\bE\u0001\u0003k4aa\u0007\u000f\t\u0002\u0005]\bB\u0002)\u0017\t\u0003\tI\u0010C\u0004\u0002|Z!\t!!@\t\u0013\t%a#%A\u0005\u0002\u0005-\u0001\"\u0003B\u0006-E\u0005I\u0011AA\u0006\u0005M\tE\u000f[3oCF+XM]=Fq\u0016\u001cW\u000f^8s\u0015\tib$\u0001\u0004bi\",g.\u0019\u0006\u0002?\u0005!\u0011/^5y\u0007\u0001\u0019B\u0001\u0001\u0012)eA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0019\u000e\u0003)R!a\u000b\u0017\u0002\u000f\u0015DXmY;uK*\u0011QFL\u0001\u0003mJR!a\f\u0010\u0002\u0007\u0005\u0004\u0018.\u0003\u00022U\tAQ\t_3dkR|'\u000f\u0005\u00024u5\tAG\u0003\u00026m\u0005a1oY1mC2|wmZ5oO*\u0011q\u0007O\u0001\tif\u0004Xm]1gK*\t\u0011(A\u0002d_6L!a\u000f\u001b\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007G2LWM\u001c;\u0016\u0003y\u0002\"a\u0010!\u000e\u0003qI!!\u0011\u000f\u0003\u0019\u0005#\b.\u001a8b\u00072LWM\u001c;\u0002\u000f\rd\u0017.\u001a8uA\u0005\u0019\u0012N\\5uS\u0006d\u0017\t\u001a<b]\u000e,G)\u001a7bsV\tQ\t\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006AA-\u001e:bi&|gN\u0003\u0002KI\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u00051;%A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0015S:LG/[1m\u0003\u00124\u0018M\\2f\t\u0016d\u0017-\u001f\u0011\u0002\u001f5\f\u00070\u00113wC:\u001cW\rR3mCf\f\u0001#\\1y\u0003\u00124\u0018M\\2f\t\u0016d\u0017-\u001f\u0011\u0002\rqJg.\u001b;?)\u0011\u00116\u000bV+\u0011\u0005}\u0002\u0001\"\u0002\u001f\b\u0001\u0004q\u0004bB\"\b!\u0003\u0005\r!\u0012\u0005\b\u001d\u001e\u0001\n\u00111\u0001F\u0003!9\u0018-\u001b;M_>\u0004HC\u0002-lqv\f)\u0001E\u0002Z=\u0002l\u0011A\u0017\u0006\u00037r\u000bA!\u001a<bY*\tQ,A\u0003n_:L\u00070\u0003\u0002`5\n!A+Y:l!\t\t\u0017.D\u0001c\u0015\t\u0019G-A\u0003n_\u0012,GN\u0003\u0002\u001eK*\u0011amZ\u0001\tg\u0016\u0014h/[2fg*\u0011\u0001\u000eO\u0001\nC6\f'p\u001c8boNL!A\u001b2\u0003'E+XM]=Fq\u0016\u001cW\u000f^5p]N#\u0018\r^3\t\u000b1D\u0001\u0019A7\u0002\u000fE,XM]=JIB\u0011a.\u001e\b\u0003_N\u0004\"\u0001\u001d\u0013\u000e\u0003ET!A\u001d\u0011\u0002\rq\u0012xn\u001c;?\u0013\t!H%\u0001\u0004Qe\u0016$WMZ\u0005\u0003m^\u0014aa\u0015;sS:<'B\u0001;%\u0011\u0015I\b\u00021\u0001{\u0003-\t7\r^5wKF+XM]=\u0011\u0005%Z\u0018B\u0001?+\u0005!\u0019VOY)vKJL\b\"\u0002@\t\u0001\u0004y\u0018a\u00022vS2$WM\u001d\t\u0004S\u0005\u0005\u0011bAA\u0002U\t9!)^5mI\u0016\u0014\b\u0002CA\u0004\u0011A\u0005\t\u0019A#\u0002\u000b\u0011,G.Y=\u0002%]\f\u0017\u000e\u001e'p_B$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001bQ3!RA\bW\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u0013Ut7\r[3dW\u0016$'bAA\u000eI\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0011Q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u00043sC&t'+Z:vYR\u001cHCCA\u0013\u0003[\ty#a\r\u00026A!\u0011LXA\u0014!\u0011\u0019\u0013\u0011F7\n\u0007\u0005-BE\u0001\u0004PaRLwN\u001c\u0005\u0006Y*\u0001\r!\u001c\u0005\b\u0003cQ\u0001\u0019AA\u0014\u0003%qW\r\u001f;U_.,g\u000eC\u0003\u007f\u0015\u0001\u0007q\u0010\u0003\u0004\u00028)\u0001\rA_\u0001\u0006cV,'/_\u0001\u0010M\u0016$8\r\u001b$jeN$()\u0019;dQRA\u0011QEA\u001f\u0003\u007f\t\t\u0005C\u0003m\u0017\u0001\u0007Q\u000eC\u0003\u007f\u0017\u0001\u0007q\u0010\u0003\u0004\u00028-\u0001\rA_\u0001\n[\u0006\\WMQ1uG\"$b!a\u0012\u0002V\u0005}\u0003\u0003BA%\u0003#j!!a\u0013\u000b\u0007-\niEC\u0002\u0002P9\n!A^\u0019\n\t\u0005M\u00131\n\u0002\u0006\u0005\u0006$8\r\u001b\u0005\b\u0003/b\u0001\u0019AA-\u0003\u0019\u0011Xm];miB\u0019\u0011-a\u0017\n\u0007\u0005u#MA\u000bHKR\fV/\u001a:z%\u0016\u001cX\u000f\u001c;t%\u0016\u001cX\u000f\u001c;\t\u0013\u0005\u0005D\u0002%AA\u0002\u0005\r\u0014aB5t\r&\u00148\u000f\u001e\t\u0004G\u0005\u0015\u0014bAA4I\t9!i\\8mK\u0006t\u0017aE7bW\u0016\u0014\u0015\r^2iI\u0011,g-Y;mi\u0012\u0012TCAA7U\u0011\t\u0019'a\u0004\u0002\u0015\r|G.^7ogJ{w\u000f\u0006\u0005\u0002d\u0005M\u0014QPAD\u0011\u001d\t)H\u0004a\u0001\u0003o\n1A]8x!\r\t\u0017\u0011P\u0005\u0004\u0003w\u0012'a\u0001*po\"9\u0011q\u0010\bA\u0002\u0005\u0005\u0015!B5oI\u0016D\bcA\u0012\u0002\u0004&\u0019\u0011Q\u0011\u0013\u0003\u0007%sG\u000fC\u0004\u0002\n:\u0001\r!a#\u0002\u00195\f\u0017PY3D_2,XN\\:\u0011\u000b\r\nI#!$\u0011\r\u0005=\u0015\u0011TAP\u001d\u0011\t\t*!&\u000f\u0007A\f\u0019*C\u0001&\u0013\r\t9\nJ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY*!(\u0003\t1K7\u000f\u001e\u0006\u0004\u0003/#\u0003\u0003BA%\u0003CKA!a)\u0002L\tY!)\u0019;dQ\u000e{G.^7o\u0003\u001d\u0019wN\u001c<feR$RAIAU\u0003[Ca!a+\u0010\u0001\u0004i\u0017\u0001\u00033bi\u0006$\u0018\u0010]3\t\r\u0005=v\u00021\u0001n\u0003\u0015!\u0017\r^;n\u0003\u001d\tGM^1oG\u0016$\"\"!.\u00028\u0006e\u00161XA_!\u0011If,!\u0017\t\u000by\u0004\u0002\u0019A@\t\u000b1\u0004\u0002\u0019A7\t\r\u0005]\u0002\u00031\u0001{\u0011%\ty\f\u0005I\u0001\u0002\u0004\t9#A\u0003u_.,g.A\tbIZ\fgnY3%I\u00164\u0017-\u001e7uIQ*\"!!2+\t\u0005\u001d\u0012q\u0002\u000b\u0007\u0003\u0013\f\t.a5\u0011\tes\u00161\u001a\t\u0004G\u00055\u0017bAAhI\t!QK\\5u\u0011\u0019\t9D\u0005a\u0001u\")aP\u0005a\u0001\u007f\u0006Q\u0011N\\5u\u00072LWM\u001c;\u0015\r\u0005e\u0017\u0011]Ar!\u0011If,a7\u0011\u0007\u0005\fi.C\u0002\u0002`\n\u0014\u0011d\u0015;beR\fV/\u001a:z\u000bb,7-\u001e;j_:\u0014Vm];mi\"1\u0011qG\nA\u0002iDQA`\nA\u0002}\f\u0001C]3xe&$X-\u0012=dKB$\u0018n\u001c8\u0015\t\u0005%\u0018q\u001e\t\u0005\u0003\u001f\u000bY/\u0003\u0003\u0002n\u0006u%!C#yG\u0016\u0004H/[8o\u0011\u001d\t\t\u0010\u0006a\u0001\u0003S\f\u0011!Z\u0001\u0014\u0003RDWM\\1Rk\u0016\u0014\u00180\u0012=fGV$xN\u001d\t\u0003\u007fY\u0019\"A\u0006\u0012\u0015\u0005\u0005U\u0018!B1qa2LHc\u0001*\u0002\u0000\"9!\u0011\u0001\rA\u0002\t\r\u0011AB2p]\u001aLw\rE\u0002@\u0005\u000bI1Aa\u0002\u001d\u00051\tE\u000f[3oC\u000e{gNZ5h\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\u0002")
public class AthenaQueryExecutor
implements Executor,
LazyLogging {
    private final AthenaClient client;
    private final FiniteDuration initialAdvanceDelay;
    private final FiniteDuration maxAdvanceDelay;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static FiniteDuration $lessinit$greater$default$3() {
        return AthenaQueryExecutor$.MODULE$.$lessinit$greater$default$3();
    }

    public static FiniteDuration $lessinit$greater$default$2() {
        return AthenaQueryExecutor$.MODULE$.$lessinit$greater$default$2();
    }

    public static AthenaQueryExecutor apply(AthenaConfig athenaConfig) {
        return AthenaQueryExecutor$.MODULE$.apply(athenaConfig);
    }

    private Logger logger$lzycompute() {
        AthenaQueryExecutor athenaQueryExecutor = this;
        synchronized (athenaQueryExecutor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public AthenaClient client() {
        return this.client;
    }

    public FiniteDuration initialAdvanceDelay() {
        return this.initialAdvanceDelay;
    }

    public FiniteDuration maxAdvanceDelay() {
        return this.maxAdvanceDelay;
    }

    public Task<QueryExecutionState> waitLoop(String queryId, SubQuery activeQuery, Builder builder, FiniteDuration delay) {
        Set runningStatuses = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QueryExecutionState[]{QueryExecutionState.RUNNING, QueryExecutionState.QUEUED}))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Set$.MODULE$.canBuildFrom());
        Set failed = (Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new QueryExecutionState[]{QueryExecutionState.FAILED, QueryExecutionState.CANCELLED}))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), Set$.MODULE$.canBuildFrom());
        return this.client().get(queryId).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getQueryExecution()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Task task;
            QueryExecution queryExecution = x0$1;
            if (runningStatuses.contains((Object)queryExecution.getStatus().getState()) && !BoxesRunTime.unboxToBoolean((Object)activeQuery.canceled().get())) {
                task = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("method=waitLoop event=not-finished query-id={} user={} status={} delay={}", new Object[]{queryId, activeQuery.user().email(), queryExecution.getStatus().getState(), delay});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }).flatMap((Function1 & Serializable & scala.Serializable)_2 -> builder.addSubQuery(queryId, new Batch((Seq)List$.MODULE$.empty(), Batch$.MODULE$.apply$default$2(), Batch$.MODULE$.apply$default$3(), Batch$.MODULE$.apply$default$4())).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.waitLoop(queryId, activeQuery, builder, this.maxAdvanceDelay().min(delay.$times(2L))).delayExecution(delay).map((Function1 & Serializable & scala.Serializable)status -> status)));
            } else if (failed.contains((Object)queryExecution.getStatus().getState())) {
                task = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("method=waitLoop event=failed query-id={} user={} delay={} status={} canceled={}", new Object[]{queryId, activeQuery.user().email(), delay, queryExecution.getStatus().getState(), activeQuery.canceled().get()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }).flatMap((Function1 & Serializable & scala.Serializable)_2 -> builder.errorSubQuery(queryId, (Throwable)new IllegalStateException(new StringBuilder(40).append("Query failed with status ").append(queryExecution.getStatus().getState()).append(" with reason = ").append(queryExecution.getStatus().getStateChangeReason()).toString())).map((Function1 & Serializable & scala.Serializable)_ -> QueryExecutionState.fromValue((String)queryExecution.getStatus().getState())));
            } else {
                String string = queryExecution.getStatus().getState();
                String string2 = QueryExecutionState.SUCCEEDED.toString();
                if (!(string == null ? string2 != null : !string.equals(string2)) || BoxesRunTime.unboxToBoolean((Object)activeQuery.canceled().get())) {
                    task = Task$.MODULE$.eval((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("method=waitLoop event=finished query-id={} user={} delay={} status={} canceled={}", new Object[]{queryId, activeQuery.user().email(), delay, queryExecution.getStatus().getState(), activeQuery.canceled().get()});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }).map((Function1 & Serializable & scala.Serializable)x$4 -> QueryExecutionState.fromValue((String)queryExecution.getStatus().getState()));
                } else {
                    throw new MatchError((Object)queryExecution);
                }
            }
            return task;
        });
    }

    public FiniteDuration waitLoop$default$4() {
        return this.initialAdvanceDelay();
    }

    public Task<Option<String>> drainResults(String queryId, Option<String> nextToken, Builder builder, SubQuery query) {
        Task log = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("method=drainResults event=start query-id={} user={} tokenOpt={}", new Object[]{queryId, query.user().email(), nextToken});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        });
        Option<String> option = nextToken;
        Task task = option instanceof Some && !BoxesRunTime.unboxToBoolean((Object)query.canceled().get()) ? this.advance(builder, queryId, query, nextToken).flatMap((Function1 & Serializable & scala.Serializable)nextState -> builder.addSubQuery(queryId, this.makeBatch((GetQueryResultsResult)nextState, this.makeBatch$default$2())).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.drainResults(queryId, (Option<String>)Option$.MODULE$.apply((Object)nextState.getNextToken()), builder, query).map((Function1 & Serializable & scala.Serializable)futureState -> futureState))) : Task$.MODULE$.now(nextToken);
        Task tokenTask = task;
        return log.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> tokenTask);
    }

    public Task<Option<String>> fetchFirstBatch(String queryId, Builder builder, SubQuery query) {
        Task log = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("method=fetchFirstBatch event=start query-id={} user={} cancelled={}", new Object[]{queryId, query.user().email(), query.canceled().get()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        });
        Task batch = BoxesRunTime.unboxToBoolean((Object)query.canceled().get()) ? Task$.MODULE$.now((Object)None$.MODULE$) : this.advance(builder, queryId, query, this.advance$default$4()).flatMap((Function1 & Serializable & scala.Serializable)state -> builder.addSubQuery(queryId, this.makeBatch((GetQueryResultsResult)state, true)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("method=fetchFirstBatch event=done query-id={} user={} cancelled={} tokenOpt={}", new Object[]{queryId, query.user().email(), query.canceled().get(), state.getNextToken()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }).map((Function1 & Serializable & scala.Serializable)_ -> Option$.MODULE$.apply((Object)state.getNextToken()))));
        return log.flatMap((Function1 & Serializable & scala.Serializable)x$6 -> batch);
    }

    public Batch makeBatch(GetQueryResultsResult result, boolean isFirst) {
        None$ none$;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("method=makeBatch event=start isFirst={} rows={}", new Object[]{BoxesRunTime.boxToBoolean((boolean)isFirst), BoxesRunTime.boxToInteger((int)result.getResultSet().getRows().size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (isFirst) {
            ResultSet rs = result.getResultSet();
            none$ = Option$.MODULE$.apply((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rs.getResultSetMetadata().getColumnInfo()).asScala()).map((Function1 & Serializable & scala.Serializable)col -> new BatchColumn(col.getName()), Buffer$.MODULE$.canBuildFrom())).toList());
        } else {
            none$ = None$.MODULE$;
        }
        None$ columns = none$;
        Buffer types = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getResultSet().getResultSetMetadata().getColumnInfo()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getType(), Buffer$.MODULE$.canBuildFrom());
        ResultSet res = result.getResultSet();
        List rows = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(res.getRows()).asScala()).toList();
        List data = (List)((TraversableLike)rows.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AthenaQueryExecutor.$anonfun$makeBatch$3(check$ifrefutable$1))).withFilter(arg_0 -> AthenaQueryExecutor.$anonfun$makeBatch$4$adapted(this, (Option)columns, arg_0)).map((Function1 & Serializable & scala.Serializable)x$11 -> {
            Tuple2 tuple2 = x$11;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Row row = (Row)tuple2._1();
            List list = (List)((TraversableOnce)types.zip((GenIterable)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(row.getData()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getVarCharValue(), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).toList().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AthenaQueryExecutor.$anonfun$makeBatch$7(check$ifrefutable$2))).map((Function1 & Serializable & scala.Serializable)x$9 -> {
                Tuple2 tuple2 = x$9;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String datatype = (String)tuple2._1();
                String datum = (String)tuple2._2();
                Object object = this.convert(datatype, datum);
                return object;
            }, List$.MODULE$.canBuildFrom());
            return list;
        }, List$.MODULE$.canBuildFrom());
        return new Batch((Seq)data, (Option)columns, Batch$.MODULE$.apply$default$3(), Batch$.MODULE$.apply$default$4());
    }

    public boolean makeBatch$default$2() {
        return false;
    }

    public boolean columnsRow(Row row, int index, Option<List<BatchColumn>> maybeColumns) {
        boolean bl;
        if (index == 0) {
            List values = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(row.getData()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.getVarCharValue(), Buffer$.MODULE$.canBuildFrom())).toList();
            List types = (List)maybeColumns.map((Function1 & Serializable & scala.Serializable)x$13 -> (List)x$13.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.name(), List$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
            List list = values;
            List list2 = types;
            bl = !(list != null ? !list.equals(list2) : list2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public Object convert(String datatype, String datum) {
        String string = datatype;
        Object object = "varchar".equals(string) ? String.valueOf(datum) : ("tinyint".equals(string) ? new Integer(datum) : ("smallint".equals(string) ? new Integer(datum) : ("integer".equals(string) ? new Integer(datum) : ("bigint".equals(string) ? new Long(datum) : ("double".equals(string) ? new Double(datum) : ("boolean".equals(string) ? new Boolean(datum) : ("date".equals(string) ? String.valueOf(datum) : ("timestamp".equals(string) ? String.valueOf(datum) : String.valueOf(datum.toString())))))))));
        return object;
    }

    public Task<GetQueryResultsResult> advance(Builder builder, String queryId, SubQuery query, Option<String> token) {
        return this.client().advance(queryId, token).onErrorHandleWith((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Task task;
            Throwable throwable = x0$1;
            boolean bl = throwable instanceof ConnectException ? true : (throwable instanceof SocketTimeoutException ? true : throwable instanceof SocketException);
            if (bl) {
                IllegalStateException ex = new IllegalStateException(new StringBuilder(72).append("Athena can't be reached, please try later. Underlying exception name is ").append(throwable.getClass().getSimpleName()).toString(), throwable);
                task = builder.errorSubQuery(queryId, (Throwable)ex).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> Task$.MODULE$.raiseError((Throwable)ex));
            } else if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                Task log = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(53).append("method=advance event=error query-id=").append(queryId).append(" user=").append(query.user().email()).append(" cancelled=").append(query.canceled().get()).toString(), (Throwable)exception);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                });
                task = builder.errorSubQuery(queryId, (Throwable)exception).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> log).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> Task$.MODULE$.raiseError((Throwable)exception));
            } else {
                throw new MatchError((Object)throwable);
            }
            return task;
        });
    }

    public Option<String> advance$default$4() {
        return None$.MODULE$;
    }

    public Task<BoxedUnit> execute(SubQuery query, Builder builder) {
        Function1 & Serializable & scala.Serializable close = (Function1 & Serializable & scala.Serializable)startExecution -> this.client().close(startExecution.getQueryExecutionId());
        return this.initClient(query, builder).bracket((Function1 & Serializable & scala.Serializable)startExecution -> {
            Task queryLoop = this.waitLoop(startExecution.getQueryExecutionId(), query, builder, this.initialAdvanceDelay()).flatMap((Function1 & Serializable & scala.Serializable)queryState -> {
                QueryExecutionState queryExecutionState = queryState;
                QueryExecutionState queryExecutionState2 = QueryExecutionState.SUCCEEDED;
                return (!(queryExecutionState != null ? !queryExecutionState.equals(queryExecutionState2) : queryExecutionState2 != null) ? this.fetchFirstBatch(startExecution.getQueryExecutionId(), builder, query).flatMap((Function1 & Serializable & scala.Serializable)token -> this.drainResults(startExecution.getQueryExecutionId(), (Option<String>)token, builder, query).map((Function1 & Serializable & scala.Serializable)_ -> {
                    AthenaQueryExecutor.$anonfun$execute$5(_);
                    return BoxedUnit.UNIT;
                })) : Task$.MODULE$.unit()).map((Function1 & Serializable & scala.Serializable)_ -> {
                    AthenaQueryExecutor.$anonfun$execute$6(_);
                    return BoxedUnit.UNIT;
                });
            });
            return Task$.MODULE$.eval((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(48).append("method=runAsync event=start query-id=").append(query.id()).append(" user=").append(query.user().email()).append(" ").append("sql=").append(query.text().replace("\n", "-newline-").replace("\\s", "-space-")).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }).flatMap((Function1 & Serializable & scala.Serializable)_ -> builder.startSubQuery(startExecution.getQueryExecutionId(), query.text()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> queryLoop.onErrorFallbackTo(Task$.MODULE$.unit()).flatMap((Function1 & Serializable & scala.Serializable)_ -> builder.endSubQuery(startExecution.getQueryExecutionId(), builder.endSubQuery$default$2()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> Task$.MODULE$.eval((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("method=runAsync event=end query-id={} user={} rows={}", new Object[]{query.id(), query.user().email(), BoxesRunTime.boxToLong((long)builder.rowCount())});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }).map((Function1 & Serializable & scala.Serializable)_ -> {
                AthenaQueryExecutor.$anonfun$execute$13(_);
                return BoxedUnit.UNIT;
            })))));
        }, (Function1)close);
    }

    public Task<StartQueryExecutionResult> initClient(SubQuery query, Builder builder) {
        Task log = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("method=initClient event=start query-id={} user={} sql={}", new Object[]{query.id(), query.user().email(), query.text()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        });
        Task clientTask = TaskOps.Ops$.MODULE$.logOnError$extension(TaskOps$.MODULE$.Ops(this.client().init(query)), new StringBuilder(50).append("method=initClient event=error query-id=").append(query.id()).append(" user=").append(query.user().email()).append(" sql=").append(query.text()).toString()).onErrorHandleWith((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (!(throwable instanceof Exception)) {
                throw new MatchError((Object)throwable);
            }
            Exception exception = (Exception)throwable;
            Task task = builder.error(query.id(), (Throwable)this.rewriteException(exception)).flatMap((Function1 & Serializable & scala.Serializable)x$18 -> Task$.MODULE$.raiseError((Throwable)this.rewriteException(exception)));
            return task;
        });
        return log.flatMap((Function1 & Serializable & scala.Serializable)x$19 -> clientTask);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Exception rewriteException(Exception e) {
        void var2_11;
        SdkClientException sdkClientException;
        boolean bl = false;
        AmazonAthenaException amazonAthenaException = null;
        Exception exception = e;
        if (exception instanceof SdkClientException && ((sdkClientException = (SdkClientException)exception).getMessage().contains("Unable to load AWS credentials") || sdkClientException.getMessage().contains("Unable to load credentials"))) {
            IllegalStateException illegalStateException = AthenaQueryExecutor.badCredentials$1((Exception)sdkClientException);
            return var2_11;
        }
        if (exception instanceof AmazonAthenaException) {
            bl = true;
            amazonAthenaException = (AmazonAthenaException)exception;
            if (amazonAthenaException.getMessage().contains("Check your AWS Secret Access Key")) {
                IllegalStateException illegalStateException = AthenaQueryExecutor.badCredentials$1((Exception)amazonAthenaException);
                return var2_11;
            }
        }
        if (bl && amazonAthenaException.getMessage().contains("The security token included in the request is invalid")) {
            IllegalStateException illegalStateException = AthenaQueryExecutor.badCredentials$1((Exception)amazonAthenaException);
            return var2_11;
        }
        boolean bl2 = exception instanceof ConnectException ? true : (exception instanceof SocketTimeoutException ? true : exception instanceof SocketException);
        if (bl2) {
            IllegalStateException illegalStateException = new IllegalStateException(new StringBuilder(72).append("Athena can't be reached, please try later. Underlying exception name is ").append(exception.getClass().getSimpleName()).toString(), exception);
            return var2_11;
        }
        Exception exception2 = e;
        return var2_11;
    }

    public static final /* synthetic */ boolean $anonfun$makeBatch$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$makeBatch$4(AthenaQueryExecutor $this, Option columns$1, Tuple2 x$10) {
        int index;
        Tuple2 tuple2 = x$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Row row = (Row)tuple2._1();
        boolean bl = !$this.columnsRow(row, index = tuple2._2$mcI$sp(), (Option<List<BatchColumn>>)columns$1);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$makeBatch$7(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$execute$5(Option _) {
    }

    public static final /* synthetic */ void $anonfun$execute$6(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$execute$13(BoxedUnit _) {
    }

    private static final IllegalStateException badCredentials$1(Exception e) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(409).append("\n           |Athena can't be reached, make sure you configured aws credentials correctly.\n           |Refer to https://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/credentials.html for details.\n           |Quix is using DefaultAWSCredentialsProviderChain from aws-java-sdk to discover the aws credentials.\n           |\n           |Underlying exception name is ").append(e.getClass().getSimpleName()).append(" with message [").append(e.getMessage()).append("]\n           |\n           |").toString())).stripMargin(), e);
    }

    public AthenaQueryExecutor(AthenaClient client, FiniteDuration initialAdvanceDelay, FiniteDuration maxAdvanceDelay) {
        this.client = client;
        this.initialAdvanceDelay = initialAdvanceDelay;
        this.maxAdvanceDelay = maxAdvanceDelay;
        LazyLogging.$init$((LazyLogging)this);
    }

    public static final /* synthetic */ Object $anonfun$makeBatch$4$adapted(AthenaQueryExecutor $this, Option columns$1, Tuple2 x$10) {
        return BoxesRunTime.boxToBoolean((boolean)AthenaQueryExecutor.$anonfun$makeBatch$4($this, columns$1, x$10));
    }
}

