/*
 * Decompiled with CFR 0.152.
 */
package quix.athena;

import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.athena.model.GetQueryExecutionRequest;
import com.amazonaws.services.athena.model.GetQueryExecutionResult;
import com.amazonaws.services.athena.model.GetQueryResultsRequest;
import com.amazonaws.services.athena.model.GetQueryResultsResult;
import com.amazonaws.services.athena.model.ResultConfiguration;
import com.amazonaws.services.athena.model.StartQueryExecutionRequest;
import com.amazonaws.services.athena.model.StartQueryExecutionResult;
import com.amazonaws.services.athena.model.StopQueryExecutionRequest;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import quix.api.v2.execute.SubQuery;
import quix.athena.AthenaClient;
import quix.athena.AthenaConfig;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0005\u000b\u0001=A\u0001b\u0003\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)\u0011\u0007\u0001C\u0001e!)a\u0007\u0001C!o!)!\u000b\u0001C!'\")Q\r\u0001C!M\"9\u0011\u000fAI\u0001\n\u0003\u0011\b\"B?\u0001\t\u0003r(aD!xg\u0006#\b.\u001a8b\u00072LWM\u001c;\u000b\u0005-a\u0011AB1uQ\u0016t\u0017MC\u0001\u000e\u0003\u0011\tX/\u001b=\u0004\u0001M!\u0001\u0001\u0005\f\u001b!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0015%\u0011\u0011D\u0003\u0002\r\u0003RDWM\\1DY&,g\u000e\u001e\t\u00037\tj\u0011\u0001\b\u0006\u0003;y\tAb]2bY\u0006dwnZ4j]\u001eT!a\b\u0011\u0002\u0011QL\b/Z:bM\u0016T\u0011!I\u0001\u0004G>l\u0017BA\u0012\u001d\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0011\u0005\u0015ZS\"\u0001\u0014\u000b\u0005-9#B\u0001\u0015*\u0003!\u0019XM\u001d<jG\u0016\u001c(B\u0001\u0016!\u0003%\tW.\u0019>p]\u0006<8/\u0003\u0002-M\ta\u0011)\\1{_:\fE\u000f[3oC\u000611m\u001c8gS\u001e\u0004\"aF\u0018\n\u0005AR!\u0001D!uQ\u0016t\u0017mQ8oM&<\u0017A\u0002\u001fj]&$h\bF\u00024iU\u0002\"a\u0006\u0001\t\u000b-\u0019\u0001\u0019\u0001\u0013\t\u000b5\u001a\u0001\u0019\u0001\u0018\u0002\t%t\u0017\u000e\u001e\u000b\u0003q\u0019\u00032!\u000f A\u001b\u0005Q$BA\u001e=\u0003\u0011)g/\u00197\u000b\u0003u\nQ!\\8oSbL!a\u0010\u001e\u0003\tQ\u000b7o\u001b\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\u001a\nQ!\\8eK2L!!\u0012\"\u00033M#\u0018M\u001d;Rk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0006\u000f\u0012\u0001\r\u0001S\u0001\u0006cV,'/\u001f\t\u0003\u0013Bk\u0011A\u0013\u0006\u0003\u00172\u000bq!\u001a=fGV$XM\u0003\u0002N\u001d\u0006\u0011aO\r\u0006\u0003\u001f2\t1!\u00199j\u0013\t\t&J\u0001\u0005Tk\n\fV/\u001a:z\u0003\r9W\r\u001e\u000b\u0003)b\u00032!\u000f V!\t\te+\u0003\u0002X\u0005\n9r)\u001a;Rk\u0016\u0014\u00180\u0012=fGV$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u00063\u0016\u0001\rAW\u0001\bcV,'/_%e!\tY&M\u0004\u0002]AB\u0011QLE\u0007\u0002=*\u0011qLD\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005\u0014\u0012A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!\u0019\n\u0002\u000f\u0005$g/\u00198dKR\u0019qm\u001b7\u0011\u0007er\u0004\u000e\u0005\u0002BS&\u0011!N\u0011\u0002\u0016\u000f\u0016$\u0018+^3ssJ+7/\u001e7ugJ+7/\u001e7u\u0011\u0015If\u00011\u0001[\u0011\u001dig\u0001%AA\u00029\f\u0001\u0002^8lK:|\u0005\u000f\u001e\t\u0004#=T\u0016B\u00019\u0013\u0005\u0019y\u0005\u000f^5p]\u0006\t\u0012\r\u001a<b]\u000e,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003MT#A\u001c;,\u0003U\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\u0013Ut7\r[3dW\u0016$'B\u0001>\u0013\u0003)\tgN\\8uCRLwN\\\u0005\u0003y^\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0015\u0019Gn\\:f)\ry\u0018q\u0001\t\u0005sy\n\t\u0001E\u0002\u0012\u0003\u0007I1!!\u0002\u0013\u0005\u0011)f.\u001b;\t\u000beC\u0001\u0019\u0001.")
public class AwsAthenaClient
implements AthenaClient,
LazyLogging {
    private final AmazonAthena athena;
    private final AthenaConfig config;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        AwsAthenaClient awsAthenaClient = this;
        synchronized (awsAthenaClient) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public Task<StartQueryExecutionResult> init(SubQuery query) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("method=init query-id={} query-sql=[{}] config={}", new Object[]{query.id(), query.text().replace("\n", "-newline-"), $this.config});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            StartQueryExecutionRequest request = new StartQueryExecutionRequest().withQueryString(query.text()).withResultConfiguration(new ResultConfiguration().withOutputLocation($this.config.output()));
            return $this.athena.startQueryExecution(request);
        });
    }

    @Override
    public Task<GetQueryExecutionResult> get(String queryId) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("method=get query-id={} config={}", new Object[]{queryId, $this.config});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            GetQueryExecutionRequest request = new GetQueryExecutionRequest().withQueryExecutionId(queryId);
            return $this.athena.getQueryExecution(request);
        });
    }

    @Override
    public Task<GetQueryResultsResult> advance(String queryId, Option<String> tokenOpt) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("method=advance query-id={} tokenOpt={}", new Object[]{queryId, tokenOpt});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            GetQueryResultsRequest request = new GetQueryResultsRequest().withQueryExecutionId(queryId);
            tokenOpt.foreach((Function1 & Serializable & scala.Serializable)x$1 -> request.withNextToken(x$1));
            return $this.athena.getQueryResults(request);
        });
    }

    @Override
    public Option<String> advance$default$2() {
        return None$.MODULE$;
    }

    @Override
    public Task<BoxedUnit> close(String queryId) {
        return Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("method=close query-id={} config={}", new Object[]{queryId, $this.config});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            StopQueryExecutionRequest request = new StopQueryExecutionRequest().withQueryExecutionId(queryId);
            $this.athena.stopQueryExecution(request);
        });
    }

    public AwsAthenaClient(AmazonAthena athena, AthenaConfig config) {
        this.athena = athena;
        this.config = config;
        LazyLogging.$init$((LazyLogging)this);
    }
}

