/*
 * Decompiled with CFR 0.152.
 */
package quix.bigquery;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import quix.api.v2.execute.SubQuery;
import quix.bigquery.BigQueryClient;
import quix.bigquery.BigQueryConfig;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u00014AAB\u0004\u0001\u0019!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015y\u0003\u0001\"\u00011\u0011\u0015!\u0004\u0001\"\u00116\u0011\u0015i\u0005\u0001\"\u0011O\u0005Q9un\\4mK\nKw-U;fef\u001cE.[3oi*\u0011\u0001\"C\u0001\tE&<\u0017/^3ss*\t!\"\u0001\u0003rk&D8\u0001A\n\u0005\u00015\u0019r\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)Ui\u0011aB\u0005\u0003-\u001d\u0011aBQ5h#V,'/_\"mS\u0016tG\u000f\u0005\u0002\u0019?5\t\u0011D\u0003\u0002\u001b7\u0005a1oY1mC2|wmZ5oO*\u0011A$H\u0001\tif\u0004Xm]1gK*\ta$A\u0002d_6L!\u0001I\r\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\tE&<\u0017+^3ssB\u00111%K\u0007\u0002I)\u0011\u0001\"\n\u0006\u0003M\u001d\nQa\u00197pk\u0012T!\u0001K\u000f\u0002\r\u001d|wn\u001a7f\u0013\tQCE\u0001\u0005CS\u001e\fV/\u001a:z\u0003\u0019\u0019wN\u001c4jOB\u0011A#L\u0005\u0003]\u001d\u0011aBQ5h#V,'/_\"p]\u001aLw-\u0001\u0004=S:LGO\u0010\u000b\u0004cI\u001a\u0004C\u0001\u000b\u0001\u0011\u0015\t3\u00011\u0001#\u0011\u0015Y3\u00011\u0001-\u0003\u0011Ig.\u001b;\u0015\u0005Y\n\u0005cA\u001c=}5\t\u0001H\u0003\u0002:u\u0005!QM^1m\u0015\u0005Y\u0014!B7p]&D\u0018BA\u001f9\u0005\u0011!\u0016m]6\u0011\u0005\rz\u0014B\u0001!%\u0005\rQuN\u0019\u0005\u0006\u0005\u0012\u0001\raQ\u0001\u0006cV,'/\u001f\t\u0003\t.k\u0011!\u0012\u0006\u0003\r\u001e\u000bq!\u001a=fGV$XM\u0003\u0002I\u0013\u0006\u0011aO\r\u0006\u0003\u0015&\t1!\u00199j\u0013\taUI\u0001\u0005Tk\n\fV/\u001a:z\u0003\u0015\u0019Gn\\:f)\ty5\u000bE\u00028yA\u0003\"AD)\n\u0005I{!\u0001B+oSRDQ\u0001V\u0003A\u0002U\u000bQA[8c\u0013\u0012\u0004\"AV/\u000f\u0005][\u0006C\u0001-\u0010\u001b\u0005I&B\u0001.\f\u0003\u0019a$o\\8u}%\u0011AlD\u0001\u0007!J,G-\u001a4\n\u0005y{&AB*ue&twM\u0003\u0002]\u001f\u0001")
public class GoogleBigQueryClient
implements BigQueryClient,
LazyLogging {
    private final BigQuery bigQuery;
    private final BigQueryConfig config;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        GoogleBigQueryClient googleBigQueryClient = this;
        synchronized (googleBigQueryClient) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public Task<Job> init(SubQuery query) {
        return Task$.MODULE$.now((Object)JobInfo.of((JobConfiguration)QueryJobConfiguration.newBuilder((String)query.text()).build())).flatMap((Function1 & Serializable & scala.Serializable)jobInfo -> Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("method=init query-id={} query-sql=[{}] config={}", new Object[]{query.id(), query.text().replace("\n", "-newline-"), $this.config});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }).map((Function1 & Serializable & scala.Serializable)_ -> $this.bigQuery.create(jobInfo, new BigQuery.JobOption[0])));
    }

    @Override
    public Task<BoxedUnit> close(String jobId) {
        return Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("method=close job-id={} config={}", new Object[]{jobId, $this.config});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }).flatMap((Function1 & Serializable & scala.Serializable)_2 -> Task$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.bigQuery.cancel(jobId)).attempt().map((Function1 & Serializable & scala.Serializable)_ -> {
            GoogleBigQueryClient.$anonfun$close$4(_);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ void $anonfun$close$4(Either _) {
    }

    public GoogleBigQueryClient(BigQuery bigQuery, BigQueryConfig config) {
        this.bigQuery = bigQuery;
        this.config = config;
        LazyLogging.$init$((LazyLogging)this);
    }
}

