/*
 * Decompiled with CFR 0.152.
 */
package quix.bigquery;

import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.TableResult;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import quix.api.v1.execute.Batch;
import quix.api.v1.execute.Batch$;
import quix.api.v1.execute.BatchColumn;
import quix.api.v1.execute.BatchError;
import quix.api.v2.execute.Builder;
import quix.api.v2.execute.Executor;
import quix.api.v2.execute.SubQuery;
import quix.bigquery.BigQueryClient;
import quix.bigquery.BigQueryConfig;
import quix.bigquery.BigQueryQueryExecutor$;
import quix.core.utils.TaskOps;
import quix.core.utils.TaskOps$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001\u0002\u000b\u0016\u0001iA\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005o!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003?\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u0015a\b\u0001\"\u0001~\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!!\u000f\u0001\t\u0003\tY\u0004\u0003\u0004%\u0001\u0011\u0005\u0013Q\t\u0005\b\u0003\u0017\u0002A\u0011AA'\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003Dq!a2\u0001\t\u0003\tImB\u0004\u0002bVA\t!a9\u0007\rQ)\u0002\u0012AAs\u0011\u0019\u0011\u0015\u0003\"\u0001\u0002h\"9\u0011\u0011^\t\u0005\u0002\u0005-(!\u0006\"jOF+XM]=Rk\u0016\u0014\u00180\u0012=fGV$xN\u001d\u0006\u0003-]\t\u0001BY5hcV,'/\u001f\u0006\u00021\u0005!\u0011/^5y\u0007\u0001\u0019B\u0001A\u000e\"WA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0015\u000e\u0003\rR!\u0001J\u0013\u0002\u000f\u0015DXmY;uK*\u0011aeJ\u0001\u0003mJR!\u0001K\f\u0002\u0007\u0005\u0004\u0018.\u0003\u0002+G\tAQ\t_3dkR|'\u000f\u0005\u0002-g5\tQF\u0003\u0002/_\u0005a1oY1mC2|wmZ5oO*\u0011\u0001'M\u0001\tif\u0004Xm]1gK*\t!'A\u0002d_6L!\u0001N\u0017\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007G2LWM\u001c;\u0016\u0003]\u0002\"\u0001O\u001d\u000e\u0003UI!AO\u000b\u0003\u001d\tKw-U;fef\u001cE.[3oi\u000691\r\\5f]R\u0004\u0013AD1em\u0006t7-\u001a+j[\u0016|W\u000f^\u000b\u0002}A\u0011AdP\u0005\u0003\u0001v\u0011A\u0001T8oO\u0006y\u0011\r\u001a<b]\u000e,G+[7f_V$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\t\u00163\u0005C\u0001\u001d\u0001\u0011\u0015)T\u00011\u00018\u0011\u0015aT\u00011\u0001?\u0003\u001d!xNQ1uG\"$B!\u0013)\\AB\u0011!JT\u0007\u0002\u0017*\u0011A\u0005\u0014\u0006\u0003\u001b\u001e\n!A^\u0019\n\u0005=[%!\u0002\"bi\u000eD\u0007\"B)\u0007\u0001\u0004\u0011\u0016a\u00016pEB\u00111+W\u0007\u0002)*\u0011a#\u0016\u0006\u0003-^\u000bQa\u00197pk\u0012T!\u0001W\u0019\u0002\r\u001d|wn\u001a7f\u0013\tQFKA\u0002K_\nDQ\u0001\u0018\u0004A\u0002u\u000baA]3tk2$\bCA*_\u0013\tyFKA\u0006UC\ndWMU3tk2$\b\"B1\u0007\u0001\u0004q\u0014!\u0003:poN\u001cvNR1s\u0003%!xnQ8mk6t7\u000f\u0006\u0002ecB\u0019A$Z4\n\u0005\u0019l\"AB(qi&|g\u000eE\u0002iW:t!\u0001H5\n\u0005)l\u0012a\u00029bG.\fw-Z\u0005\u0003Y6\u0014A\u0001T5ti*\u0011!.\b\t\u0003\u0015>L!\u0001]&\u0003\u0017\t\u000bGo\u00195D_2,XN\u001c\u0005\u00069\u001e\u0001\r!X\u0001\tO\u0016$h+\u00197vKR\u0011Ao\u001e\t\u00039UL!A^\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003y\u0011\u0001\u0007\u00110A\u0003wC2,X\r\u0005\u0002Tu&\u00111\u0010\u0016\u0002\u000b\r&,G\u000e\u001a,bYV,\u0017\u0001C4fi\u0016\u0013(o\u001c:\u0015\u0007y\f)\u0001E\u0002\u001dK~\u00042ASA\u0001\u0013\r\t\u0019a\u0013\u0002\u000b\u0005\u0006$8\r[#se>\u0014\b\"B)\n\u0001\u0004\u0011\u0016\u0001\u00027p_B$\"\"a\u0003\u0002\"\u0005-\u0012QGA\u001c!\u0019\ti!a\u0006\u0002\u001c5\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0003fm\u0006d'BAA\u000b\u0003\u0015iwN\\5y\u0013\u0011\tI\"a\u0004\u0003\tQ\u000b7o\u001b\t\u00049\u0005u\u0011bAA\u0010;\t!QK\\5u\u0011\u001d\t\u0019C\u0003a\u0001\u0003K\tQ!];fef\u00042AIA\u0014\u0013\r\tIc\t\u0002\t'V\u0014\u0017+^3ss\"9\u0011Q\u0006\u0006A\u0002\u0005=\u0012a\u00022vS2$WM\u001d\t\u0004E\u0005E\u0012bAA\u001aG\t9!)^5mI\u0016\u0014\b\"B)\u000b\u0001\u0004\u0011\u0006\"\u0002/\u000b\u0001\u0004i\u0016!D<bSR4uN\u001d$j]&\u001c\b\u000e\u0006\u0004\u0002>\u0005}\u0012\u0011\t\t\u0006\u0003\u001b\t9B\u0015\u0005\u0006#.\u0001\rA\u0015\u0005\b\u0003\u0007Z\u0001\u0019AA\u0013\u0003-\t7\r^5wKF+XM]=\u0015\r\u0005-\u0011qIA%\u0011\u001d\t\u0019\u0003\u0004a\u0001\u0003KAq!!\f\r\u0001\u0004\ty#A\bgKR\u001c\u0007n\u0015;bi&\u001cH/[2t)\u0011\ty%!0\u0011\u0011\u0005E\u00131LA0\u0003_j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\nS6lW\u000f^1cY\u0016T1!!\u0017\u001e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\n\u0019FA\u0002NCB\u0004B!!\u0019\u0002l5\u0011\u00111\r\u0006\u0005\u0003K\n9'\u0001\u0003mC:<'BAA5\u0003\u0011Q\u0017M^1\n\t\u00055\u00141\r\u0002\u0007'R\u0014\u0018N\\4\u0013\u0011\u0005E\u0014QOAV\u0003c3a!a\u001d\u0001\u0001\u0005=$\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0007BA<\u0003\u0003\u0003b!!\u0019\u0002z\u0005u\u0014\u0002BA>\u0003G\u0012!bQ8na\u0006\u0014\u0018M\u00197f!\u0011\ty(!!\r\u0001\u0011Y\u00111\u0011\u0001\u0002\u0002\u0003\u0005)\u0011AAC\u0005\ty\u0016'\u0005\u0003\u0002\b\u0006U%\u0003CAE\u0003?\nY)a$\u0007\r\u0005M\u0004\u0001AAD!\u0011\t\t'!$\n\u0007\u0001\u000b\u0019\u0007\u0005\u0003\u0002b\u0005E\u0015\u0002BAJ\u0003G\u0012qAQ8pY\u0016\fgN\u0005\u0005\u0002\u0018\u0006e\u00151VAY\r\u0019\t\u0019\b\u0001\u0001\u0002\u0016B\"\u00111TAP!\u0019\t\t'!\u001f\u0002\u001eB!\u0011qPAP\t-\t\u0019\tAA\u0001\u0002\u0003\u0015\t!!)\u0012\t\u0005\r\u0016q\u0015\n\t\u0003K\u000by&a#\u0002\u0010\u001a1\u00111\u000f\u0001\u0001\u0003G\u0013b!!+\u0002,\u0006EfABA:\u0001\u0001\t9\u000b\u0005\u0003\u0002b\u00055\u0016\u0002BAX\u0003G\u0012aa\u00142kK\u000e$\b\u0003BAZ\u0003sk!!!.\u000b\t\u0005]\u0016qM\u0001\u0003S>LA!a/\u00026\na1+\u001a:jC2L'0\u00192mK\")\u0011+\u0004a\u0001%\u0006Q\u0011N\\5u\u00072LWM\u001c;\u0015\r\u0005u\u00121YAc\u0011\u001d\t\u0019C\u0004a\u0001\u0003KAq!!\f\u000f\u0001\u0004\ty#\u0001\tsK^\u0014\u0018\u000e^3Fq\u000e,\u0007\u000f^5p]R!\u00111ZAo!\u0011\ti-!7\u000f\u0007\u0005=\u0017N\u0004\u0003\u0002R\u0006]WBAAj\u0015\r\t).G\u0001\u0007yI|w\u000e\u001e \n\u0003yI1!a7n\u0005%)\u0005pY3qi&|g\u000eC\u0004\u0002`>\u0001\r!a3\u0002\u0003\u0015\fQCQ5h#V,'/_)vKJLX\t_3dkR|'\u000f\u0005\u00029#M\u0011\u0011c\u0007\u000b\u0003\u0003G\fQ!\u00199qYf$2\u0001RAw\u0011\u001d\tyo\u0005a\u0001\u0003c\faaY8oM&<\u0007c\u0001\u001d\u0002t&\u0019\u0011Q_\u000b\u0003\u001d\tKw-U;fef\u001cuN\u001c4jO\u0002")
public class BigQueryQueryExecutor
implements Executor,
LazyLogging {
    private final BigQueryClient client;
    private final long advanceTimeout;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static BigQueryQueryExecutor apply(BigQueryConfig bigQueryConfig) {
        return BigQueryQueryExecutor$.MODULE$.apply(bigQueryConfig);
    }

    private Logger logger$lzycompute() {
        BigQueryQueryExecutor bigQueryQueryExecutor = this;
        synchronized (bigQueryQueryExecutor) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public BigQueryClient client() {
        return this.client;
    }

    public long advanceTimeout() {
        return this.advanceTimeout;
    }

    public Batch toBatch(Job job, TableResult result, long rowsSoFar) {
        Seq rows = (Seq)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(result.getValues()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)row -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)row).asScala()).map((Function1 & Serializable & scala.Serializable)value -> this.getValue((FieldValue)value), Buffer$.MODULE$.canBuildFrom())).toList(), Seq$.MODULE$.canBuildFrom());
        int percentage = result.getTotalRows() > 0L ? (int)((double)(rowsSoFar + (long)rows.size()) / (double)result.getTotalRows() * (double)100) : 0;
        return Batch.BatchStatsOps$.MODULE$.withPercentage$extension(Batch$.MODULE$.BatchStatsOps(new Batch(rows, this.toColumns(result), this.getError(job), Batch$.MODULE$.apply$default$4())), percentage);
    }

    public Option<List<BatchColumn>> toColumns(TableResult result) {
        return Option$.MODULE$.apply((Object)result.getSchema()).map((Function1 & Serializable & scala.Serializable)schema -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)schema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> new BatchColumn(f.getName()), Buffer$.MODULE$.canBuildFrom())).toList());
    }

    public Object getValue(FieldValue value2) {
        FieldValue.Attribute attribute = value2.getAttribute();
        String string = FieldValue.Attribute.PRIMITIVE.equals(attribute) && !value2.isNull() ? value2.getStringValue() : (FieldValue.Attribute.REPEATED.equals(attribute) ? new StringBuilder(2).append("[").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(value2.getRepeatedValue()).asScala()).map((Function1 & Serializable & scala.Serializable)value -> this.getValue((FieldValue)value), Buffer$.MODULE$.canBuildFrom())).mkString(", ")).append("]").toString() : (FieldValue.Attribute.RECORD.equals(attribute) ? new StringBuilder(2).append("{").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)value2.getRecordValue()).asScala()).map((Function1 & Serializable & scala.Serializable)value -> this.getValue((FieldValue)value), Buffer$.MODULE$.canBuildFrom())).mkString(", ")).append("}").toString() : null));
        return string;
    }

    public Option<BatchError> getError(Job job) {
        return Option$.MODULE$.apply((Object)job.getStatus().getError()).map((Function1 & Serializable & scala.Serializable)error -> new BatchError(error.getMessage()));
    }

    public Task<BoxedUnit> loop(SubQuery query, Builder builder, Job job, TableResult result) {
        return result != null && !BoxesRunTime.unboxToBoolean((Object)query.canceled().get()) ? builder.addSubQuery(job.getGeneratedId(), this.toBatch(job, result, builder.rowCount())).flatMap((Function1 & Serializable & scala.Serializable)_ -> Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> result.getNextPage()).flatMap((Function1 & Serializable & scala.Serializable)nextPage -> this.loop(query, builder, job, (TableResult)nextPage).map((Function1 & Serializable & scala.Serializable)_ -> {
            BigQueryQueryExecutor.$anonfun$loop$4(_);
            return BoxedUnit.UNIT;
        }))) : Task$.MODULE$.unit();
    }

    public Task<Job> waitForFinish(Job job, SubQuery activeQuery) {
        return Task$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> job.waitFor(new RetryOption[0]));
    }

    public Task<BoxedUnit> execute(SubQuery query, Builder builder) {
        return this.initClient(query, builder).bracket((Function1 & Serializable & scala.Serializable)job -> builder.startSubQuery(job.getGeneratedId(), query.text()).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.waitForFinish((Job)job, query).flatMap((Function1 & Serializable & scala.Serializable)completedJob -> this.loop(query, builder, (Job)completedJob, completedJob.getQueryResults(new BigQuery.QueryResultsOption[0])).onErrorHandleWith((Function1 & Serializable & scala.Serializable)e -> builder.errorSubQuery(job.getGeneratedId(), e)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> builder.endSubQuery(job.getGeneratedId(), this.fetchStatistics((Job)completedJob)).map((Function1 & Serializable & scala.Serializable)_ -> {
            BigQueryQueryExecutor.$anonfun$execute$6(_);
            return BoxedUnit.UNIT;
        })))), (Function1 & Serializable & scala.Serializable)job -> this.close$1((Job)job));
    }

    public Map<String, Object> fetchStatistics(Job job) {
        JobStatistics.QueryStatistics jobStatistics = (JobStatistics.QueryStatistics)job.getStatistics();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cacheHit"), (Object)jobStatistics.getCacheHit()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bytesProcessed"), (Object)jobStatistics.getTotalBytesProcessed()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bytesBilled"), (Object)jobStatistics.getTotalBytesBilled()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)jobStatistics.getStatementType().name())}));
    }

    public Task<Job> initClient(SubQuery query, Builder builder) {
        Task log = Task$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("method=initClient event=start query-id={} user={} sql={}", new Object[]{query.id(), query.user().email(), query.text()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        });
        Task clientTask = TaskOps.Ops$.MODULE$.logOnError$extension(TaskOps$.MODULE$.Ops(this.client().init(query)), new StringBuilder(50).append("method=initClient event=error query-id=").append(query.id()).append(" user=").append(query.user().email()).append(" sql=").append(query.text()).toString()).onErrorHandleWith((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (!(throwable instanceof Exception)) {
                throw new MatchError((Object)throwable);
            }
            Exception exception = (Exception)throwable;
            Task task = builder.error(query.id(), (Throwable)this.rewriteException(exception)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Task$.MODULE$.raiseError((Throwable)this.rewriteException(exception)));
            return task;
        });
        return log.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> clientTask);
    }

    public Exception rewriteException(Exception e) {
        GoogleJsonResponseException googleJsonResponseException;
        Exception exception = e;
        Exception exception2 = exception instanceof GoogleJsonResponseException && (googleJsonResponseException = (GoogleJsonResponseException)exception).getMessage().contains("401 Unauthorized") ? BigQueryQueryExecutor.badCredentials$1((Exception)googleJsonResponseException) : e;
        return exception2;
    }

    public static final /* synthetic */ void $anonfun$loop$4(BoxedUnit _) {
    }

    private final Task close$1(Job job) {
        return this.client().close(job.getJobId().getJob());
    }

    public static final /* synthetic */ void $anonfun$execute$6(BoxedUnit _) {
    }

    private static final IllegalStateException badCredentials$1(Exception e) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(310).append("\n           |BigQuery can't be reached, make sure you configured credentials correctly from the JSON file.\n           |Refer to https://cloud.google.com/iam/docs/creating-managing-service-account-keys for details.\n           |\n           |Underlying exception name is ").append(e.getClass().getSimpleName()).append(" with message [").append(e.getMessage()).append("]\n           |\n           |").toString())).stripMargin(), e);
    }

    public BigQueryQueryExecutor(BigQueryClient client, long advanceTimeout) {
        this.client = client;
        this.advanceTimeout = advanceTimeout;
        LazyLogging.$init$((LazyLogging)this);
    }
}

