/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.config;

import com.wix.mysql.config.Charset;
import com.wix.mysql.distribution.Version;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MysqldConfig
extends ExecutableProcessConfig {
    private final int port;
    private final Charset charset;
    private final User user;
    private final TimeZone timeZone;
    private final Timeout timeout;
    private final List<ServerVariable> serverVariables;
    private final String tempDir;

    protected MysqldConfig(IVersion version, int port, Charset charset, User user, TimeZone timeZone, Timeout timeout, List<ServerVariable> serverVariables, String tempDir) {
        super(version, new ISupportConfig(){

            public String getName() {
                return "mysqld";
            }

            public String getSupportUrl() {
                return "https://github.com/wix/wix-embedded-mysql/issues";
            }

            public String messageOnException(Class<?> context, Exception exception) {
                return "no message";
            }
        });
        if (user.name.equals("root")) {
            throw new IllegalArgumentException("Usage of username 'root' is forbidden as it's reserved for system use");
        }
        this.port = port;
        this.charset = charset;
        this.user = user;
        this.timeZone = timeZone;
        this.timeout = timeout;
        this.serverVariables = serverVariables;
        this.tempDir = tempDir;
    }

    public Version getVersion() {
        return (Version)this.version;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getPort() {
        return this.port;
    }

    public long getTimeout(TimeUnit target) {
        return this.timeout.to(target);
    }

    public String getUsername() {
        return this.user.name;
    }

    public String getPassword() {
        return this.user.password;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public List<ServerVariable> getServerVariables() {
        return this.serverVariables;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public static Builder aMysqldConfig(Version version) {
        return new Builder(version);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)((Object)this));
    }

    public static class SystemDefaults {
        public static final String USERNAME = "root";
        public static final String SCHEMA = "information_schema";
    }

    public static class ServerVariable<T> {
        private final String name;
        private final T value;

        ServerVariable(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public String toCommandLineArgument() {
            return String.format("--%s=%s", this.name, this.value);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    private static class Timeout {
        private final long length;
        private final TimeUnit unit;

        Timeout(long length, TimeUnit unit) {
            this.length = length;
            this.unit = unit;
        }

        long to(TimeUnit target) {
            return target.convert(this.length, this.unit);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    private static class User {
        private final String name;
        private final String password;

        User(String name, String password) {
            this.name = name;
            this.password = password;
        }

        public String toString() {
            return ReflectionToStringBuilder.toStringExclude((Object)this, (String[])new String[]{"password"});
        }
    }

    public static class Builder {
        private IVersion version;
        private int port = 3310;
        private Charset charset = Charset.defaults();
        private User user = new User("auser", "sa");
        private TimeZone timeZone = TimeZone.getTimeZone("UTC");
        private Timeout timeout = new Timeout(30L, TimeUnit.SECONDS);
        private final List<ServerVariable> serverVariables = new ArrayList<ServerVariable>();
        private String tempDir = "target/";

        public Builder(IVersion version) {
            this.version = version;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withFreePort() throws IOException {
            try (ServerSocket socket = new ServerSocket(0);){
                socket.setReuseAddress(true);
                Builder builder = this.withPort(socket.getLocalPort());
                return builder;
            }
        }

        public Builder withTimeout(long length, TimeUnit unit) {
            this.timeout = new Timeout(length, unit);
            return this;
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withUser(String username, String password) {
            this.user = new User(username, password);
            return this;
        }

        public Builder withTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder withTimeZone(String timeZoneId) {
            return this.withTimeZone(TimeZone.getTimeZone(timeZoneId));
        }

        public Builder withServerVariable(String name, boolean value) {
            this.serverVariables.add(new ServerVariable<Boolean>(name, value));
            return this;
        }

        public Builder withServerVariable(String name, int value) {
            this.serverVariables.add(new ServerVariable<Integer>(name, value));
            return this;
        }

        public Builder withServerVariable(String name, String value) {
            this.serverVariables.add(new ServerVariable<String>(name, value));
            return this;
        }

        public Builder withTempDir(String tempDir) {
            this.tempDir = tempDir;
            return this;
        }

        public MysqldConfig build() {
            return new MysqldConfig(this.version, this.port, this.charset, this.user, this.timeZone, this.timeout, this.serverVariables, this.tempDir);
        }
    }
}

